/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.sql.Connection;
import java.sql.SQLException;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableMetadata;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.StandardEngineId;
import net.pms.swing.Splash;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostUpgrade {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostUpgrade.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String METADATA_KEY = "POST_UPGRADE";
    private static final int POST_UPGRADE_VERSION = 2;

    private PostUpgrade() {
    }

    public static void proceed() {
        if (!MediaDatabase.isAvailable()) {
            LOGGER.trace("Not doing Post Upgrade because database is closed");
            return;
        }
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            if (connection == null) {
                return;
            }
            Integer currentVersion = 0;
            String versionStr = MediaTableMetadata.getMetadataValue(connection, METADATA_KEY);
            if (!StringUtils.isBlank(versionStr)) {
                try {
                    currentVersion = Integer.valueOf(versionStr);
                }
                catch (NumberFormatException ex) {
                    currentVersion = 0;
                }
            }
            if (currentVersion < 2) {
                Splash.setStatusMessage("InitFirstRun");
                PostUpgrade.upgrade(connection, currentVersion);
            }
        }
        catch (SQLException ex) {
            LOGGER.trace("Error in Post Upgrade:", ex);
        }
    }

    private static void upgrade(Connection connection, Integer currentVersion) throws SQLException {
        block4: for (int version = currentVersion.intValue(); version < 2; ++version) {
            switch (version) {
                case 0: {
                    if (CONFIGURATION.hasRunOnce()) continue block4;
                    if (!EngineFactory.isEngineActive(StandardEngineId.YOUTUBE_DL)) {
                        CONFIGURATION.setEngineEnabled(StandardEngineId.YOUTUBE_DL, true);
                        CONFIGURATION.setEnginePriorityBelow(StandardEngineId.YOUTUBE_DL, StandardEngineId.FFMPEG_WEB_VIDEO);
                    }
                    CONFIGURATION.setHasRunOnce();
                    continue block4;
                }
                case 1: {
                    if (EngineFactory.isEngineActive(StandardEngineId.FFMPEG_HLS_VIDEO)) continue block4;
                    CONFIGURATION.setEngineEnabled(StandardEngineId.FFMPEG_HLS_VIDEO, true);
                    CONFIGURATION.setEnginePriorityBelow(StandardEngineId.FFMPEG_HLS_VIDEO, StandardEngineId.FFMPEG_VIDEO);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Post Upgrade version missmatch");
                }
            }
        }
        MediaTableMetadata.setOrUpdateMetadataValue(connection, METADATA_KEY, String.valueOf(2));
    }
}

