/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.FFMpegVideo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegWebFilters {
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpegWebFilters.class);
    protected static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final ReentrantReadWriteLock FILTERS_LOCK = new ReentrantReadWriteLock();
    private static final PatternMap<Object> EXCLUDES;
    private static final PatternMap<ArrayList> AUTO_OPTIONS;
    private static final PatternMap<String> REPLACEMENTS;

    private FFmpegWebFilters() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readWebFilters(String filename) {
        block12: {
            boolean bl;
            LineIterator it = FileUtils.lineIterator(new File(filename));
            FILTERS_LOCK.writeLock().lock();
            try {
                PatternMap<Object> filter = null;
                while (it.hasNext()) {
                    String line = it.nextLine().trim();
                    if (line.equals("EXCLUDE")) {
                        filter = EXCLUDES;
                        continue;
                    }
                    if (line.equals("OPTIONS")) {
                        filter = AUTO_OPTIONS;
                        continue;
                    }
                    if (line.equals("REPLACE")) {
                        filter = REPLACEMENTS;
                        continue;
                    }
                    if (line.isEmpty() || line.startsWith("#") || filter == null) continue;
                    String[] value = line.split(" \\| ", 2);
                    filter.add(value[0], value.length > 1 ? value[1] : null);
                }
                bl = true;
                FILTERS_LOCK.writeLock().unlock();
            }
            catch (Throwable throwable) {
                try {
                    FILTERS_LOCK.writeLock().unlock();
                    it.close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.info("FFmpeg web filters \"{}\" not found, web filters ignored: {}", (Object)filename, (Object)e.getMessage());
                    } else {
                        LOGGER.info("FFmpeg web filters \"{}\" not found, web filters ignored", (Object)filename);
                    }
                    break block12;
                }
                catch (IOException e) {
                    LOGGER.debug("Error reading ffmpeg web filters from file \"{}\": {}", (Object)filename, (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
            }
            it.close();
            return bl;
        }
        return false;
    }

    public static boolean isExluded(String value) {
        FILTERS_LOCK.readLock().lock();
        try {
            boolean bl = EXCLUDES.match(value) != null;
            return bl;
        }
        finally {
            FILTERS_LOCK.readLock().unlock();
        }
    }

    public static List<String> getAutoOptions(String value) {
        FILTERS_LOCK.readLock().lock();
        try {
            String match = AUTO_OPTIONS.match(value);
            if (match != null) {
                List list = (List)AUTO_OPTIONS.get(match);
                return list;
            }
        }
        finally {
            FILTERS_LOCK.readLock().unlock();
        }
        return null;
    }

    public static String getReplacements(String value) {
        FILTERS_LOCK.readLock().lock();
        try {
            String r = REPLACEMENTS.match(value);
            if (r != null) {
                value = value.replaceAll(r, (String)REPLACEMENTS.get(r));
                LOGGER.debug("Modified url: {}", (Object)value);
            }
        }
        finally {
            FILTERS_LOCK.readLock().unlock();
        }
        return value;
    }

    static {
        FFmpegWebFilters.readWebFilters(CONFIGURATION.getProfileDirectory() + File.separator + "ffmpeg.webfilters");
        EXCLUDES = new PatternMap();
        AUTO_OPTIONS = new PatternMap<ArrayList>(){
            private static final long serialVersionUID = 5225786297932747007L;

            @Override
            public ArrayList add(String key, Object value) {
                return this.put(key, (ArrayList)FFMpegVideo.parseOptions((String)value));
            }
        };
        REPLACEMENTS = new PatternMap();
    }

    private static class PatternMap<T>
    extends ModAwareHashMap<String, T> {
        private static final long serialVersionUID = 3096452459003158959L;
        Matcher combo;
        List<String> groupmap = new ArrayList<String>();

        private PatternMap() {
        }

        public T add(String key, Object value) {
            return (T)this.put(key, value);
        }

        String match(String str) {
            if (!this.isEmpty()) {
                if (this.modified) {
                    this.compile();
                }
                if (this.combo.reset(str).find()) {
                    for (int i = 0; i < this.combo.groupCount(); ++i) {
                        if (this.combo.group(i + 1) == null) continue;
                        return this.groupmap.get(i);
                    }
                }
            }
            return null;
        }

        void compile() {
            StringBuilder joined = new StringBuilder();
            this.groupmap.clear();
            for (String regex : this.keySet()) {
                joined.append("|(").append(regex).append(')');
                for (int i = 0; i < Pattern.compile(regex).matcher("").groupCount() + 1; ++i) {
                    this.groupmap.add(regex);
                }
            }
            this.combo = Pattern.compile(joined.substring(1)).matcher("");
            this.modified = false;
        }
    }

    private static class ModAwareHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = -5334451082377480129L;
        protected boolean modified = false;

        private ModAwareHashMap() {
        }

        @Override
        public void clear() {
            this.modified = true;
            super.clear();
        }

        @Override
        public V put(K key, V value) {
            this.modified = true;
            return super.put(key, value);
        }

        @Override
        public V remove(Object key) {
            this.modified = true;
            return super.remove(key);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ModAwareHashMap)) {
                return false;
            }
            ModAwareHashMap m = (ModAwareHashMap)o;
            if (m.size() != this.size()) {
                return false;
            }
            if (m.modified != this.modified) {
                return false;
            }
            try {
                for (Map.Entry e : this.entrySet()) {
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                    return false;
                }
            }
            catch (ClassCastException | NullPointerException unused) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (this.modified ? 1 : 0);
        }
    }
}

