/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.pms.platform.PlatformProgramPaths;
import net.pms.util.ExecutableInfo;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.FFmpegProgramInfo;
import net.pms.util.FileUtil;
import net.pms.util.ProgramExecutableType;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConfigurableProgramPaths
extends PlatformProgramPaths {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableProgramPaths.class);
    public static final String KEY_MPLAYER_EXECUTABLE_TYPE = "mplayer_executable_type";
    public static final String KEY_MPLAYER_PATH = "mplayer_path";
    public static final String KEY_FLAC_EXECUTABLE_TYPE = "flac_executable_type";
    public static final String KEY_FLAC_PATH = "flac_path";
    public static final String KEY_INTERFRAME_EXECUTABLE_TYPE = "interframe_executable_type";
    public static final String KEY_INTERFRAME_PATH = "interframe_path";
    public static final String KEY_FFMS2_EXECUTABLE_TYPE = "ffms2_executable_type";
    public static final String KEY_FFMS2_PATH = "ffms2_path";
    public static final String KEY_2DTO3D_EXECUTABLE_TYPE = "2DTO3D_executable_type";
    public static final String KEY_2DTO3D_PATH = "2dTo3d_path";
    public static final String KEY_CROP_RESIZE_EXECUTABLE_TYPE = "cropResize_executable_type";
    public static final String KEY_CROP_RESIZE_PATH = "cropResize_path";
    public static final String KEY_YOUTUBEDL_PATH = "youtubedl_path";
    private final Configuration configuration;
    private final PlatformProgramPaths platformPaths = PlatformProgramPaths.get();

    protected ConfigurableProgramPaths(@Nullable Configuration configuration) {
        this.configuration = configuration;
        this.setCustomPathFromConfiguration(this.getMPlayer(), KEY_MPLAYER_PATH);
        this.setCustomPathFromConfiguration(this.getFLAC(), KEY_FLAC_PATH);
        this.setCustomPathFromConfiguration(this.getInterFrame(), KEY_INTERFRAME_PATH);
        this.setCustomPathFromConfiguration(this.getYoutubeDl(), KEY_YOUTUBEDL_PATH);
    }

    @Override
    public final FFmpegProgramInfo getFFmpeg() {
        return this.platformPaths.getFFmpeg();
    }

    @Override
    public final ExternalProgramInfo getMPlayer() {
        return this.platformPaths.getMPlayer();
    }

    @Override
    public final ExternalProgramInfo getVLC() {
        return this.platformPaths.getVLC();
    }

    @Override
    public ExternalProgramInfo getMEncoder() {
        return this.platformPaths.getMEncoder();
    }

    @Override
    public final ExternalProgramInfo getTsMuxeR() {
        return this.platformPaths.getTsMuxeR();
    }

    @Override
    public final ExternalProgramInfo getFLAC() {
        return this.platformPaths.getFLAC();
    }

    @Override
    public final ExternalProgramInfo getDCRaw() {
        return this.platformPaths.getDCRaw();
    }

    @Override
    public final ExternalProgramInfo getAviSynth() {
        return this.platformPaths.getAviSynth();
    }

    @Override
    public final ExternalProgramInfo getInterFrame() {
        return this.platformPaths.getInterFrame();
    }

    @Override
    public final ExternalProgramInfo getFFMS2() {
        return this.platformPaths.getFFMS2();
    }

    @Override
    public final ExternalProgramInfo getDirectShowSource() {
        return this.platformPaths.getFFMS2();
    }

    @Override
    public final ExternalProgramInfo getMvtools2() {
        return this.platformPaths.getMvtools2();
    }

    @Override
    public final ExternalProgramInfo getDepan() {
        return this.platformPaths.getDepan();
    }

    @Override
    public final ExternalProgramInfo getMasktools2() {
        return this.platformPaths.getMasktools2();
    }

    @Override
    public final ExternalProgramInfo getConvert2dTo3d() {
        return this.platformPaths.getConvert2dTo3d();
    }

    @Override
    public final ExternalProgramInfo getCropResize() {
        return this.platformPaths.getCropResize();
    }

    @Override
    public final ExternalProgramInfo getYoutubeDl() {
        return this.platformPaths.getYoutubeDl();
    }

    public void setCustomMPlayerPath(@Nullable Path path) {
        this.setCustomProgramPath(path, this.platformPaths.getMPlayer(), KEY_MPLAYER_PATH, true);
    }

    public void setCustomFlacPath(@Nullable Path path) {
        this.setCustomProgramPath(path, this.platformPaths.getFLAC(), KEY_FLAC_PATH, true);
    }

    public void setCustomInterFramePath(@Nullable Path path) {
        this.setCustomProgramPath(path, this.platformPaths.getInterFrame(), KEY_INTERFRAME_PATH, true);
    }

    public void setCustomFFMS2Path(@Nullable Path path) {
        this.setCustomProgramPath(path, this.platformPaths.getFFMS2(), KEY_FFMS2_PATH, true);
    }

    public void setCustomConvert2dTo3dPath(@Nullable Path path) {
        this.setCustomProgramPath(path, this.platformPaths.getConvert2dTo3d(), KEY_2DTO3D_PATH, true);
    }

    public void setCustomCropResizePath(@Nullable Path path) {
        this.setCustomProgramPath(path, this.platformPaths.getCropResize(), KEY_CROP_RESIZE_PATH, true);
    }

    public void setCustomYoutubeDlPath(@Nullable Path path) {
        this.setCustomProgramPath(path, this.platformPaths.getYoutubeDl(), KEY_YOUTUBEDL_PATH, true);
    }

    @Nullable
    public ProgramExecutableType getConfiguredExecutableType(@Nullable ExternalProgramInfo programInfo, @Nullable String configurationKey) {
        if (this.configuration == null) {
            return null;
        }
        return this.getConfiguredExecutableType(configurationKey, programInfo == null ? null : programInfo.getDefault());
    }

    @Nullable
    public ProgramExecutableType getConfiguredExecutableType(@Nullable String configurationKey, @Nullable ProgramExecutableType defaultExecutableType) {
        if (this.configuration == null || StringUtils.isBlank(configurationKey)) {
            return null;
        }
        return ProgramExecutableType.toProgramExecutableType(this.configuration.getString(configurationKey), defaultExecutableType);
    }

    private void setCustomPathFromConfiguration(@Nullable ExternalProgramInfo programInfo, @Nullable String configurationKey) {
        Path customPath;
        if (programInfo == null || this.configuration == null) {
            return;
        }
        if (StringUtils.isBlank(configurationKey)) {
            throw new IllegalArgumentException("configurationKey can't be blank");
        }
        try {
            customPath = this.getCustomProgramPath(configurationKey);
        }
        catch (ConfigurationException e) {
            customPath = null;
        }
        this.setCustomProgramPath(customPath, programInfo, configurationKey, false);
    }

    @Nullable
    public Path getCustomProgramPath(@Nullable String configurationKey) throws ConfigurationException {
        if (StringUtils.isBlank(configurationKey) || this.configuration == null) {
            return null;
        }
        try {
            String configuredPath = this.configuration.getString(configurationKey);
            if (StringUtils.isBlank(configuredPath)) {
                return null;
            }
            return Paths.get(configuredPath, new String[0]);
        }
        catch (InvalidPathException | ConversionException e) {
            throw new ConfigurationException("Invalid configured custom program path in \"" + configurationKey + "\": " + e.getMessage(), e);
        }
    }

    public boolean setCustomProgramPathConfiguration(@Nullable Path customPath, @Nonnull String configurationKey) {
        boolean changed;
        if (StringUtils.isBlank(configurationKey)) {
            throw new IllegalArgumentException("configurationKey can't be blank");
        }
        if (this.configuration == null) {
            return false;
        }
        if (customPath == null) {
            if (this.configuration.containsKey(configurationKey)) {
                this.configuration.clearProperty(configurationKey);
                return true;
            }
            return false;
        }
        try {
            String currentValue = this.configuration.getString(configurationKey);
            changed = !customPath.toString().equals(currentValue);
        }
        catch (ConversionException e) {
            changed = true;
        }
        if (changed) {
            this.configuration.setProperty(configurationKey, customPath.toString());
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCustomProgramPath(@Nullable Path customPath, @Nullable ExternalProgramInfo programInfo, @Nullable String configurationKey, boolean setConfiguration) {
        if (programInfo == null || this.configuration == null) {
            return;
        }
        if (setConfiguration && StringUtils.isBlank(configurationKey)) {
            throw new IllegalArgumentException("configurationKey can't be blank if setConfiguration is true");
        }
        if (setConfiguration && configurationKey != null) {
            this.setCustomProgramPathConfiguration(customPath, configurationKey);
        }
        customPath = ConfigurableProgramPaths.resolveCustomProgramPath(customPath);
        ReentrantReadWriteLock lock = programInfo.getLock();
        lock.writeLock().lock();
        try {
            if (customPath == null) {
                if (programInfo.getExecutableInfo(ProgramExecutableType.CUSTOM) != null) {
                    programInfo.setExecutableInfo(ProgramExecutableType.CUSTOM, null);
                    programInfo.setOriginalDefault();
                    LOGGER.debug("Cleared custom {} path", (Object)programInfo.getName());
                }
            } else {
                ExecutableInfo executableInfo = programInfo.getExecutableInfo(ProgramExecutableType.CUSTOM);
                if (executableInfo == null || !customPath.equals(executableInfo.getPath())) {
                    programInfo.setPath(ProgramExecutableType.CUSTOM, customPath);
                    programInfo.setDefault(ProgramExecutableType.CUSTOM);
                    LOGGER.debug("Set custom {} path \"{}\"", (Object)programInfo.getName(), (Object)customPath);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Nullable
    public static Path resolveCustomProgramPath(@Nullable Path customPath) {
        Path osPathCustom;
        if (customPath == null) {
            return null;
        }
        if (!Files.exists(customPath, new LinkOption[0]) && !customPath.isAbsolute() && (osPathCustom = FileUtil.findExecutableInOSPath(customPath)) != null) {
            customPath = osPathCustom;
        }
        return customPath;
    }
}

