/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.AdvancedSearch;
import de.sfuhrm.radiobrowser4j.ConnectionParams;
import de.sfuhrm.radiobrowser4j.Limit;
import de.sfuhrm.radiobrowser4j.Paging;
import de.sfuhrm.radiobrowser4j.PagingSpliterator;
import de.sfuhrm.radiobrowser4j.Parameter;
import de.sfuhrm.radiobrowser4j.RadioBrowserException;
import de.sfuhrm.radiobrowser4j.RestDelegate;
import de.sfuhrm.radiobrowser4j.RestDelegateImpl;
import de.sfuhrm.radiobrowser4j.SearchMode;
import de.sfuhrm.radiobrowser4j.Station;
import de.sfuhrm.radiobrowser4j.Stats;
import de.sfuhrm.radiobrowser4j.UrlResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioBrowser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadioBrowser.class);
    @Deprecated
    static final String DEFAULT_API_URL = "https://at1.api.radio-browser.info/";
    private final RestDelegate rest;

    public RadioBrowser(@NonNull ConnectionParams connectionParams) {
        if (connectionParams == null) {
            throw new NullPointerException("connectionParams is marked non-null but is null");
        }
        connectionParams.check();
        this.rest = new RestDelegateImpl(connectionParams);
    }

    private static Paging findPaging(Parameter ... listParam) {
        Optional<Parameter> pagingParameter = Arrays.stream(listParam).filter(param -> param instanceof Paging).findFirst();
        return pagingParameter.orElse(null);
    }

    private static List<Parameter> exceptPaging(Parameter ... listParam) {
        List<Parameter> nonPagingParameters = Arrays.stream(listParam).filter(param -> !(param instanceof Paging)).collect(Collectors.toList());
        return nonPagingParameters;
    }

    private static String paths(String ... components) {
        return Arrays.stream(components).collect(Collectors.joining("/"));
    }

    private Map<String, Integer> retrieveValueStationCountList(String keyFieldName, String subPath) {
        List<Map<String, String>> map = this.rest.postWithListOfMapOfString(subPath, Collections.emptyMap());
        return map.stream().collect(Collectors.toMap(m -> (String)m.get(keyFieldName), m -> Integer.parseInt((String)m.get("stationcount")), (a, b) -> a));
    }

    @Deprecated
    public Map<String, Integer> listCountries() {
        return this.retrieveValueStationCountList("name", "json/countries");
    }

    public Map<String, Integer> listCountryCodes() {
        return this.retrieveValueStationCountList("iso_3166_1", "json/countries");
    }

    public Map<String, Integer> listCodecs() {
        return this.retrieveValueStationCountList("name", "json/codecs");
    }

    public Map<String, Integer> listLanguages() {
        return this.retrieveValueStationCountList("name", "json/languages");
    }

    public Map<String, Integer> listTags() {
        return this.retrieveValueStationCountList("name", "json/tags");
    }

    private List<Station> listStationsPathWithPaging(Optional<Paging> paging, String path, Parameter ... listParam) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        paging.ifPresent(p -> p.apply(requestParams));
        Arrays.stream(listParam).forEach(lp -> lp.apply(requestParams));
        return this.rest.postWithListOfStation(path, requestParams);
    }

    private List<Station> listStationsPathWithLimit(Optional<Limit> limit, String path, Parameter ... listParam) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Arrays.stream(listParam).forEach(lp -> lp.apply(requestParams));
        String myPath = path;
        if (limit.isPresent()) {
            myPath = myPath + '/' + limit.get().getSize();
        }
        return this.rest.postWithListOfStation(myPath, requestParams);
    }

    public List<Station> listStations(@NonNull Paging paging, Parameter ... listParam) {
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        return this.listStationsPathWithPaging(Optional.of(paging), "json/stations", listParam);
    }

    public Stream<Station> listStations(Parameter ... listParam) {
        Parameter[] nonPaging = RadioBrowser.exceptPaging(listParam).toArray(new Parameter[0]);
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStations((Paging)p, nonPaging), RadioBrowser.findPaging(listParam)), false);
    }

    public List<Station> listBrokenStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/broken", new Parameter[0]);
    }

    public Stream<Station> listBrokenStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/broken", new Parameter[0]), null), false);
    }

    public List<Station> listTopClickStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/topclick", new Parameter[0]);
    }

    public Stream<Station> listTopClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/topclick", new Parameter[0]), null), false);
    }

    public List<Station> listTopVoteStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/topvote", new Parameter[0]);
    }

    public Stream<Station> listTopVoteStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/topvote", new Parameter[0]), null), false);
    }

    public List<Station> listLastClickStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/lastclick", new Parameter[0]);
    }

    public Stream<Station> listLastClickStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/lastclick", new Parameter[0]), null), false);
    }

    public List<Station> listLastChangedStations(@NonNull Limit limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        return this.listStationsPathWithLimit(Optional.of(limit), "json/stations/lastchange", new Parameter[0]);
    }

    public Stream<Station> listLastChangedStations() {
        return StreamSupport.stream(new PagingSpliterator(p -> this.listStationsPathWithPaging(Optional.of(p), "json/stations/lastchange", new Parameter[0]), null), false);
    }

    public Optional<Station> getStationByUUID(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        List<Station> stationList = this.listStationsBy(Paging.at(0, 1), SearchMode.BYUUID, uuid.toString(), new Parameter[0]);
        if (stationList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(stationList.get(0));
    }

    public List<Station> listStationsBy(@NonNull Paging paging, @NonNull SearchMode searchMode, @NonNull String searchTerm, Parameter ... listParam) {
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        if (searchMode == null) {
            throw new NullPointerException("searchMode is marked non-null but is null");
        }
        if (searchTerm == null) {
            throw new NullPointerException("searchTerm is marked non-null but is null");
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        paging.apply(requestParams);
        Arrays.stream(listParam).forEach(l -> l.apply(requestParams));
        String path = RadioBrowser.paths("json/stations", searchMode.name().toLowerCase(), searchTerm);
        return this.rest.postWithListOfStation(path, requestParams);
    }

    public Stream<Station> listStationsBy(@NonNull SearchMode searchMode, @NonNull String searchTerm, Parameter ... listParam) {
        if (searchMode == null) {
            throw new NullPointerException("searchMode is marked non-null but is null");
        }
        if (searchTerm == null) {
            throw new NullPointerException("searchTerm is marked non-null but is null");
        }
        Function fetcher = p -> {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            p.apply(requestParams);
            RadioBrowser.exceptPaging(listParam).stream().forEach(l -> l.apply(requestParams));
            String path = RadioBrowser.paths("json/stations", searchMode.name().toLowerCase(), searchTerm);
            return this.rest.postWithListOfStation(path, requestParams);
        };
        return StreamSupport.stream(new PagingSpliterator(fetcher, RadioBrowser.findPaging(listParam)), false);
    }

    public URL resolveStreamUrl(@NonNull UUID stationUUID) {
        if (stationUUID == null) {
            throw new NullPointerException("stationUUID is marked non-null but is null");
        }
        String path = RadioBrowser.paths("json/url", stationUUID.toString());
        try {
            UrlResponse urlResponse = this.rest.get(path, UrlResponse.class);
            if (!urlResponse.isOk()) {
                throw new RadioBrowserException(urlResponse.getMessage());
            }
            return new URL(urlResponse.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RadioBrowserException(e);
        }
    }

    public UUID postNewStation(@NonNull Station station) {
        if (station == null) {
            throw new NullPointerException("station is marked non-null but is null");
        }
        return this.postNewOrEditStation(station, "json/add");
    }

    public void voteForStation(@NonNull UUID stationUUID) {
        if (stationUUID == null) {
            throw new NullPointerException("stationUUID is marked non-null but is null");
        }
        String path = RadioBrowser.paths("json/vote", stationUUID.toString());
        UrlResponse urlResponse = this.rest.get(path, UrlResponse.class);
        if (!urlResponse.isOk()) {
            throw new RadioBrowserException(urlResponse.getMessage());
        }
    }

    public Stats getServerStats() {
        return this.rest.get("json/stats", Stats.class);
    }

    public List<Station> listStationsWithAdvancedSearch(@NonNull Paging paging, @NonNull AdvancedSearch advancedSearch, Parameter ... listParam) {
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        if (advancedSearch == null) {
            throw new NullPointerException("advancedSearch is marked non-null but is null");
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        advancedSearch.apply(requestParams);
        paging.apply(requestParams);
        RadioBrowser.exceptPaging(listParam).stream().forEach(l -> l.apply(requestParams));
        return this.rest.postWithListOfStation("/json/stations/search", requestParams);
    }

    public Stream<Station> listStationsWithAdvancedSearch(@NonNull AdvancedSearch advancedSearch, Parameter ... listParam) {
        if (advancedSearch == null) {
            throw new NullPointerException("advancedSearch is marked non-null but is null");
        }
        Function fetcher = p -> {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            p.apply(requestParams);
            advancedSearch.apply(requestParams);
            RadioBrowser.exceptPaging(listParam).stream().forEach(l -> l.apply(requestParams));
            return this.rest.postWithListOfStation("/json/stations/search", requestParams);
        };
        return StreamSupport.stream(new PagingSpliterator(fetcher, RadioBrowser.findPaging(listParam)), false);
    }

    private UUID postNewOrEditStation(@NonNull Station station, String path) {
        if (station == null) {
            throw new NullPointerException("station is marked non-null but is null");
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        station.apply(requestParams);
        UrlResponse urlResponse = this.rest.post(path, requestParams, UrlResponse.class);
        if (log.isDebugEnabled()) {
            log.debug("Result: {}", (Object)urlResponse);
        }
        if (!urlResponse.isOk()) {
            throw new RadioBrowserException(urlResponse.getMessage());
        }
        return urlResponse.getUuid();
    }
}

