/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.schema.media;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.universalmediaserver.tmdbapi.schema.media.MediaTypeInterface;
import com.universalmediaserver.tmdbapi.schema.movie.MovieJobCreditTypedSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieRoleCreditTypedSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieRoleTypedSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieTypedSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonShortTypedSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonTypedSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvJobCreditTypedSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvPlainSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvRoleCreditTypedSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvTypedSchema;
import java.lang.reflect.Type;

public class MediaTypeInterfaceDeserializer
implements JsonDeserializer<MediaTypeInterface> {
    private static final String MEDIA_TYPE = "media_type";

    @Override
    public MediaTypeInterface deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        block13: {
            String mediaType;
            JsonObject media;
            if (!json.isJsonObject() || !(media = json.getAsJsonObject()).has(MEDIA_TYPE)) break block13;
            switch (mediaType = media.get(MEDIA_TYPE).getAsString()) {
                case "movie": {
                    return this.deserializeMovie(json, media, context);
                }
                case "person": {
                    return this.deserializePerson(json, media, context);
                }
                case "tv": {
                    return this.deserializeTv(json, media, context);
                }
            }
            throw new JsonParseException("Unknown media type " + mediaType);
        }
        throw new JsonParseException("Wrong media");
    }

    private MediaTypeInterface deserializeMovie(JsonElement json, JsonObject media, JsonDeserializationContext context) throws JsonParseException {
        if (media.has("character")) {
            if (media.has("credit_id")) {
                return (MediaTypeInterface)context.deserialize(json, (Type)((Object)MovieRoleCreditTypedSchema.class));
            }
            return (MediaTypeInterface)context.deserialize(json, (Type)((Object)MovieRoleTypedSchema.class));
        }
        if (media.has("job") && media.has("credit_id")) {
            return (MediaTypeInterface)context.deserialize(json, (Type)((Object)MovieJobCreditTypedSchema.class));
        }
        return (MediaTypeInterface)context.deserialize(json, (Type)((Object)MovieTypedSchema.class));
    }

    private MediaTypeInterface deserializePerson(JsonElement json, JsonObject media, JsonDeserializationContext context) throws JsonParseException {
        if (media.has("known_for")) {
            return (MediaTypeInterface)context.deserialize(json, (Type)((Object)PersonTypedSchema.class));
        }
        return (MediaTypeInterface)context.deserialize(json, (Type)((Object)PersonShortTypedSchema.class));
    }

    private MediaTypeInterface deserializeTv(JsonElement json, JsonObject media, JsonDeserializationContext context) throws JsonParseException {
        if (media.has("character") && media.has("credit_id")) {
            return (MediaTypeInterface)context.deserialize(json, (Type)((Object)TvRoleCreditTypedSchema.class));
        }
        if (media.has("job") && media.has("credit_id")) {
            return (MediaTypeInterface)context.deserialize(json, (Type)((Object)TvJobCreditTypedSchema.class));
        }
        if (media.has("episodes")) {
            return (MediaTypeInterface)context.deserialize(json, (Type)((Object)TvPlainSchema.class));
        }
        return (MediaTypeInterface)context.deserialize(json, (Type)((Object)TvTypedSchema.class));
    }
}

