/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.tv.season;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.tv.season.TvSeasonAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.credit.AggregateCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.season.TvSeasonAccountStatesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.season.TvSeasonCreditsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.season.TvSeasonDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.season.TvSeasonExternalIdsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.season.TvSeasonImagesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.tv.season.TvSeasonTranslationsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.video.VideosResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TvSeasonTvIdEndpoint
extends Endpoint {
    private static final String V3_TV_ENDPOINT = "/3/tv/";
    private static final String SEASON_ENDPOINT = "/season/";
    private static final String ACCOUNT_STATES_ENDPOINT = "/" + String.valueOf((Object)TvSeasonAppendToResponse.ACCOUNT_STATES);
    private static final String AGGREGATE_CREDITS_ENDPOINT = "/" + String.valueOf((Object)TvSeasonAppendToResponse.AGGREGATE_CREDITS);
    private static final String CREDITS_ENDPOINT = "/" + String.valueOf((Object)TvSeasonAppendToResponse.CREDITS);
    private static final String EXTERNAL_IDS_ENDPOINT = "/" + String.valueOf((Object)TvSeasonAppendToResponse.EXTERNAL_IDS);
    private static final String IMAGES_ENDPOINT = "/" + String.valueOf((Object)TvSeasonAppendToResponse.IMAGES);
    private static final String TRANSLATIONS_ENDPOINT = "/" + String.valueOf((Object)TvSeasonAppendToResponse.TRANSLATIONS);
    private static final String VIDEOS_ENDPOINT = "/" + String.valueOf((Object)TvSeasonAppendToResponse.VIDEOS);
    private final long tvId;
    private final long seasonNumber;
    private final List<TvSeasonAppendToResponse> appendToResponse = new ArrayList<TvSeasonAppendToResponse>();
    private final List<String> includeImageLanguage = new ArrayList<String>();
    private final List<String> includeVideoLanguage = new ArrayList<String>();
    private String language;

    public TvSeasonTvIdEndpoint(TMDbClient tmdbClient, long tvId, long seasonNumber) {
        super(tmdbClient);
        this.tvId = tvId;
        this.seasonNumber = seasonNumber;
    }

    public TvSeasonTvIdEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public TvSeasonTvIdEndpoint appendToResponse(TvSeasonAppendToResponse ... values) {
        if (values != null) {
            TvSeasonAppendToResponse[] tvSeasonAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                TvSeasonAppendToResponse value = tvSeasonAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)value)) {
                    this.appendToResponse.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvSeasonTvIdEndpoint includeImageLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!this.includeImageLanguage.contains(value)) {
                    this.includeImageLanguage.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvSeasonTvIdEndpoint includeVideoLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!this.includeVideoLanguage.contains(value)) {
                    this.includeVideoLanguage.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public TvSeasonDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvSeasonTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvSeasonTvIdEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        TvSeasonTvIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        TvSeasonTvIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber, TvSeasonDetailsSchema.class, query);
    }

    public TvSeasonAccountStatesResponseSchema getAccountStates() {
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + ACCOUNT_STATES_ENDPOINT, TvSeasonAccountStatesResponseSchema.class, null);
    }

    public AggregateCreditsResponseSchema getAggregateCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvSeasonTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + AGGREGATE_CREDITS_ENDPOINT, AggregateCreditsResponseSchema.class, query);
    }

    public TvSeasonCreditsResponseSchema getCredits() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvSeasonTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + CREDITS_ENDPOINT, TvSeasonCreditsResponseSchema.class, query);
    }

    public TvSeasonExternalIdsResponseSchema getExternalIds() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvSeasonTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + EXTERNAL_IDS_ENDPOINT, TvSeasonExternalIdsResponseSchema.class, query);
    }

    public TvSeasonImagesResponseSchema getImages() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvSeasonTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvSeasonTvIdEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + IMAGES_ENDPOINT, TvSeasonImagesResponseSchema.class, query);
    }

    public TvSeasonTranslationsResponseSchema getTranslations() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvSeasonTvIdEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + TRANSLATIONS_ENDPOINT, TvSeasonTranslationsResponseSchema.class, query);
    }

    public VideosResponseSchema getVideos() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvSeasonTvIdEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvSeasonTvIdEndpoint.addQueryStrings(query, "include_video_language", this.includeVideoLanguage);
        return this.tmdbClient.get(V3_TV_ENDPOINT + this.tvId + SEASON_ENDPOINT + this.seasonNumber + VIDEOS_ENDPOINT, VideosResponseSchema.class, query);
    }
}

