/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.tv;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.change.ChangesIdsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvSimpleResultsSchema;
import java.util.HashMap;

public class TvEndpoint
extends Endpoint {
    private static final String V3_TV_ENDPOINT = "/3/tv/";
    private static final String CHANGES_ENDPOINT = "/3/tv/changes";
    private static final String LATEST_ENDPOINT = "/3/tv/latest";
    private static final String AIRING_TODAY_ENDPOINT = "/3/tv/airing_today";
    private static final String ON_THE_AIR_ENDPOINT = "/3/tv/on_the_air";
    private static final String POPULAR_ENDPOINT = "/3/tv/popular";
    private static final String TOP_RATED_ENDPOINT = "/3/tv/top_rated";
    private String endDate;
    private String language;
    private int page;
    private String startDate;

    public TvEndpoint(TMDbClient tmdbClient) {
        super(tmdbClient);
    }

    public TvEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public TvEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public TvEndpoint setStartDate(String value) {
        this.startDate = value;
        return this;
    }

    public TvEndpoint setEndDate(String value) {
        this.endDate = value;
        return this;
    }

    public ChangesIdsSchema getChanges() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEndpoint.addQueryString(query, "start_date", this.startDate);
        TvEndpoint.addQueryString(query, "end_date", this.endDate);
        TvEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(CHANGES_ENDPOINT, ChangesIdsSchema.class, query);
    }

    public TvSchema getLatest() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(LATEST_ENDPOINT, TvSchema.class, query);
    }

    public TvSimpleResultsSchema getAiringToday() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(AIRING_TODAY_ENDPOINT, TvSimpleResultsSchema.class, query);
    }

    public TvSimpleResultsSchema getOnTheAir() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(ON_THE_AIR_ENDPOINT, TvSimpleResultsSchema.class, query);
    }

    public TvSimpleResultsSchema getPopular() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(POPULAR_ENDPOINT, TvSimpleResultsSchema.class, query);
    }

    public TvSimpleResultsSchema getTopRated() {
        HashMap<String, String> query = new HashMap<String, String>();
        TvEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        TvEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(TOP_RATED_ENDPOINT, TvSimpleResultsSchema.class, query);
    }
}

