/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.trending;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.trending.TrendingTimeWindow;
import com.universalmediaserver.tmdbapi.schema.media.MediaTypedResultsSchema;
import com.universalmediaserver.tmdbapi.schema.movie.MovieTypedResultsSchema;
import com.universalmediaserver.tmdbapi.schema.person.PersonTypedResultsSchema;
import com.universalmediaserver.tmdbapi.schema.tv.TvTypedResultsSchema;
import java.util.HashMap;

public class TrendingEndpoint
extends Endpoint {
    private static final String V3_TRENDING_ENDPOINT = "/3/trending/";
    private static final String TRENDING_ALL_ENDPOINT = "/3/trending/all/";
    private static final String TRENDING_MOVIE_ENDPOINT = "/3/trending/movie/";
    private static final String TRENDING_TV_ENDPOINT = "/3/trending/tv/";
    private static final String TRENDING_PERSON_ENDPOINT = "/3/trending/person/";
    private final TrendingTimeWindow timeWindow;
    private String language;

    public TrendingEndpoint(TMDbClient tmdbClient, TrendingTimeWindow timeWindow) {
        super(tmdbClient);
        this.timeWindow = timeWindow;
    }

    public TrendingEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public MediaTypedResultsSchema getAllResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        TrendingEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(TRENDING_ALL_ENDPOINT + this.timeWindow.toString(), MediaTypedResultsSchema.class, query);
    }

    public MovieTypedResultsSchema getMovieResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        TrendingEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(TRENDING_MOVIE_ENDPOINT + this.timeWindow.toString(), MovieTypedResultsSchema.class, query);
    }

    public TvTypedResultsSchema getTvResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        TrendingEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(TRENDING_TV_ENDPOINT + this.timeWindow.toString(), TvTypedResultsSchema.class, query);
    }

    public PersonTypedResultsSchema getPersonResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        TrendingEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(TRENDING_PERSON_ENDPOINT + this.timeWindow.toString(), PersonTypedResultsSchema.class, query);
    }
}

