/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.search;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.tv.TvSimpleResultsSchema;
import java.util.HashMap;

public class SearchTvEndpoint
extends Endpoint {
    private static final String V3_SEARCH_TV_ENDPOINT = "/3/search/tv";
    private final String searchQuery;
    private boolean includeAdult;
    private int firstAirDateYear;
    private String language;
    private int page;

    public SearchTvEndpoint(TMDbClient tmdbClient, String searchQuery) {
        super(tmdbClient);
        this.searchQuery = searchQuery;
    }

    public SearchTvEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public SearchTvEndpoint setPage(int value) {
        this.page = value;
        return this;
    }

    public SearchTvEndpoint setFirstAirDateYear(int value) {
        this.firstAirDateYear = value;
        return this;
    }

    public SearchTvEndpoint includeAdultContent(boolean value) {
        this.includeAdult = value;
        return this;
    }

    public TvSimpleResultsSchema getResults() {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("query", this.searchQuery);
        SearchTvEndpoint.addQueryNumber(query, "first_air_date_year", this.firstAirDateYear);
        SearchTvEndpoint.addQueryBoolean(query, "include_adult", this.includeAdult, false);
        SearchTvEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        SearchTvEndpoint.addQueryNumber(query, "page", this.page);
        return this.tmdbClient.get(V3_SEARCH_TV_ENDPOINT, TvSimpleResultsSchema.class, query);
    }
}

