/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.list;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.list.ListSortBy;
import com.universalmediaserver.tmdbapi.schema.list.ListV4StatusSchema;

public class ListV4Endpoint
extends Endpoint {
    private static final String V4_LIST_ENDPOINT = "/4/list";
    private final String name;
    private final String iso639Part1;
    private String description;
    private String iso3166Part1;
    private Boolean isPublic;
    private String sortBy;

    public ListV4Endpoint(TMDbClient tmdbClient, String name, String iso639Part1) {
        super(tmdbClient);
        this.iso639Part1 = iso639Part1;
        this.name = name;
    }

    public ListV4Endpoint setDescription(String value) {
        this.description = value;
        return this;
    }

    public ListV4Endpoint setIso3166Part1(String value) {
        this.iso3166Part1 = value;
        return this;
    }

    public ListV4Endpoint setPublic(Boolean value) {
        this.isPublic = value;
        return this;
    }

    public ListV4Endpoint setSortBy(ListSortBy value) {
        this.sortBy = value != null ? value.toString() : null;
        return this;
    }

    public ListV4StatusSchema create() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("iso_639_1", this.iso639Part1);
        ListV4Endpoint.addPostString(jsonObject, "description", this.description);
        ListV4Endpoint.addPostString(jsonObject, "iso_3166_1", this.iso3166Part1);
        ListV4Endpoint.addPostBoolean(jsonObject, "public", this.isPublic, true);
        ListV4Endpoint.addPostString(jsonObject, "sort_by", this.sortBy);
        return this.tmdbClient.post(V4_LIST_ENDPOINT, ListV4StatusSchema.class, null, jsonObject.toString());
    }
}

