/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.list;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.list.ListSortBy;
import com.universalmediaserver.tmdbapi.schema.StatusSchema;
import com.universalmediaserver.tmdbapi.schema.list.ListV4ClearStatusSchema;

public class ListIdV4Endpoint
extends Endpoint {
    private static final String V4_LIST_ENDPOINT = "/4/list/";
    private static final String LIST_CLEAR_ENDPOINT = "/clear";
    private final long listId;
    private String description;
    private String iso3166Part1;
    private String iso639Part1;
    private Boolean isPublic;
    private String name;
    private String sortBy;

    public ListIdV4Endpoint(TMDbClient tmdbClient, long listId) {
        super(tmdbClient);
        this.listId = listId;
    }

    public ListIdV4Endpoint setDescription(String value) {
        this.description = value;
        return this;
    }

    public ListIdV4Endpoint setIso3166Part1(String value) {
        this.iso3166Part1 = value;
        return this;
    }

    public ListIdV4Endpoint setIso639Part1(String value) {
        this.iso639Part1 = value;
        return this;
    }

    public ListIdV4Endpoint setName(String value) {
        this.name = value;
        return this;
    }

    public ListIdV4Endpoint setSortBy(ListSortBy value) {
        this.sortBy = value != null ? value.toString() : null;
        return this;
    }

    public ListIdV4Endpoint setPublic(Boolean value) {
        this.isPublic = value;
        return this;
    }

    public ListV4ClearStatusSchema clear() {
        return this.tmdbClient.get(V4_LIST_ENDPOINT + this.listId + LIST_CLEAR_ENDPOINT, ListV4ClearStatusSchema.class, null);
    }

    public StatusSchema delete() {
        return this.tmdbClient.delete(V4_LIST_ENDPOINT + this.listId, StatusSchema.class, null);
    }

    public StatusSchema update() {
        JsonObject jsonObject = new JsonObject();
        ListIdV4Endpoint.addPostString(jsonObject, "description", this.description);
        ListIdV4Endpoint.addPostString(jsonObject, "iso_3166_1", this.iso3166Part1);
        ListIdV4Endpoint.addPostString(jsonObject, "iso_639_1", this.iso639Part1);
        ListIdV4Endpoint.addPostString(jsonObject, "name", this.name);
        ListIdV4Endpoint.addPostBoolean(jsonObject, "public", this.isPublic, true);
        ListIdV4Endpoint.addPostString(jsonObject, "sort_by", this.sortBy);
        return this.tmdbClient.put(V4_LIST_ENDPOINT + this.listId, StatusSchema.class, null, jsonObject.toString());
    }
}

