/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.list;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.list.ListSortBy;
import com.universalmediaserver.tmdbapi.schema.StatusSchema;
import com.universalmediaserver.tmdbapi.schema.list.ListClearStatusSchema;
import java.util.HashMap;

public class ListIdV3Endpoint
extends Endpoint {
    private static final String V3_LIST_ENDPOINT = "/3/list/";
    private static final String LIST_CLEAR_ENDPOINT = "/clear";
    private final long listId;
    private String description;
    private String iso3166Part1;
    private String iso639Part1;
    private Boolean isPublic;
    private String name;
    private Boolean confirm;
    private String sortBy;

    public ListIdV3Endpoint(TMDbClient tmdbClient, long listId) {
        super(tmdbClient);
        this.listId = listId;
    }

    public ListIdV3Endpoint setDescription(String value) {
        this.description = value;
        return this;
    }

    public ListIdV3Endpoint setIso3166Part1(String value) {
        this.iso3166Part1 = value;
        return this;
    }

    public ListIdV3Endpoint setIso639Part1(String value) {
        this.iso639Part1 = value;
        return this;
    }

    public ListIdV3Endpoint setName(String value) {
        this.name = value;
        return this;
    }

    public ListIdV3Endpoint setSortBy(ListSortBy value) {
        this.sortBy = value != null ? value.toString() : null;
        return this;
    }

    public ListIdV3Endpoint setPage(boolean value) {
        this.confirm = value;
        return this;
    }

    public ListIdV3Endpoint setPublic(Boolean value) {
        this.isPublic = value;
        return this;
    }

    public ListClearStatusSchema clear() {
        HashMap<String, String> query = new HashMap<String, String>();
        ListIdV3Endpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        ListIdV3Endpoint.addQueryBoolean(query, "confirm", this.confirm);
        return this.tmdbClient.get(V3_LIST_ENDPOINT + this.listId + LIST_CLEAR_ENDPOINT, ListClearStatusSchema.class, query);
    }

    public StatusSchema delete() {
        HashMap<String, String> query = new HashMap<String, String>();
        ListIdV3Endpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        return this.tmdbClient.delete(V3_LIST_ENDPOINT + this.listId, StatusSchema.class, query);
    }

    public StatusSchema update() {
        HashMap<String, String> query = new HashMap<String, String>();
        ListIdV3Endpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        JsonObject jsonObject = new JsonObject();
        ListIdV3Endpoint.addPostString(jsonObject, "description", this.description);
        ListIdV3Endpoint.addPostString(jsonObject, "iso_3166_1", this.iso3166Part1);
        ListIdV3Endpoint.addPostString(jsonObject, "iso_639_1", this.iso639Part1);
        ListIdV3Endpoint.addPostString(jsonObject, "name", this.name);
        ListIdV3Endpoint.addPostBoolean(jsonObject, "public", this.isPublic, true);
        ListIdV3Endpoint.addPostString(jsonObject, "sort_by", this.sortBy);
        return this.tmdbClient.put(V3_LIST_ENDPOINT + this.listId, StatusSchema.class, query, jsonObject.toString());
    }
}

