/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.collection;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.collection.CollectionAppendToResponse;
import com.universalmediaserver.tmdbapi.schema.collection.CollectionDetailsSchema;
import com.universalmediaserver.tmdbapi.schema.collection.CollectionImagesResponseSchema;
import com.universalmediaserver.tmdbapi.schema.collection.CollectionTranslationsResponseSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CollectionEndpoint
extends Endpoint {
    private static final String COLLECTION_ENDPOINT = "/3/collection/";
    private static final String IMAGES_ENDPOINT = "/images";
    private static final String TRANSLATION_ENDPOINT = "/translations";
    private final long collectionId;
    private final List<CollectionAppendToResponse> appendToResponse = new ArrayList<CollectionAppendToResponse>();
    private final List<String> includeImageLanguage = new ArrayList<String>();
    private String language;

    public CollectionEndpoint(TMDbClient tmdbClient, long collectionId) {
        super(tmdbClient);
        this.collectionId = collectionId;
    }

    public CollectionEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public CollectionEndpoint appendToResponse(CollectionAppendToResponse ... values) {
        if (values != null) {
            CollectionAppendToResponse[] collectionAppendToResponseArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                CollectionAppendToResponse value = collectionAppendToResponseArray[n2];
                if (!this.appendToResponse.contains((Object)value)) {
                    this.appendToResponse.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public CollectionEndpoint includeImageLanguage(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!this.includeImageLanguage.contains(value)) {
                    this.includeImageLanguage.add(value);
                }
                ++n2;
            }
        }
        return this;
    }

    public CollectionDetailsSchema getDetails() {
        HashMap<String, String> query = new HashMap<String, String>();
        CollectionEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        CollectionEndpoint.addQueryEnums(query, "append_to_response", this.appendToResponse);
        CollectionEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(COLLECTION_ENDPOINT + this.collectionId, CollectionDetailsSchema.class, query);
    }

    public CollectionImagesResponseSchema getImages() {
        HashMap<String, String> query = new HashMap<String, String>();
        CollectionEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        CollectionEndpoint.addQueryStrings(query, "include_image_language", this.includeImageLanguage);
        return this.tmdbClient.get(COLLECTION_ENDPOINT + this.collectionId + IMAGES_ENDPOINT, CollectionImagesResponseSchema.class, query);
    }

    public CollectionTranslationsResponseSchema getTranslations() {
        HashMap<String, String> query = new HashMap<String, String>();
        CollectionEndpoint.addQueryString(query, "language", this.language);
        return this.tmdbClient.get(COLLECTION_ENDPOINT + this.collectionId + TRANSLATION_ENDPOINT, CollectionTranslationsResponseSchema.class, query);
    }
}

