/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.authentication;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.SuccessSchema;
import com.universalmediaserver.tmdbapi.schema.authentication.AuthenticationGuestSessionSchema;
import com.universalmediaserver.tmdbapi.schema.authentication.AuthenticationRequestTokenSchema;
import com.universalmediaserver.tmdbapi.schema.authentication.AuthenticationSessionSchema;
import java.util.HashMap;

public class AuthenticationEndpoint
extends Endpoint {
    private static final String V3_AUTHENTICATION_ENDPOINT = "/3/authentication/";
    private static final String V3_AUTHENTICATION_GUEST_SESSION_ENDPOINT = "/3/authentication/guest_session";
    private static final String V3_AUTHENTICATION_GUEST_SESSION_NEW_ENDPOINT = "/3/authentication/guest_session/new";
    private static final String V3_AUTHENTICATION_TOKEN_ENDPOINT = "/3/authentication/token";
    private static final String V3_AUTHENTICATION_TOKEN_VALIDATE_WITH_LOGIN_ENDPOINT = "/3/authentication/token/validate_with_login";
    private static final String V3_AUTHENTICATION_TOKEN_NEW_ENDPOINT = "/3/authentication/token/new";
    private static final String V3_AUTHENTICATION_SESSION_ENDPOINT = "/3/authentication/session";
    private static final String V3_AUTHENTICATION_SESSION_NEW_ENDPOINT = "/3/authentication/session/new";
    private static final String V3_AUTHENTICATION_SESSION_CONVERT_4_ENDPOINT = "/3/authentication/session/convert/4";

    public AuthenticationEndpoint(TMDbClient tmdbClient) {
        super(tmdbClient);
    }

    public AuthenticationGuestSessionSchema createGuestSession() {
        return this.tmdbClient.get(V3_AUTHENTICATION_GUEST_SESSION_NEW_ENDPOINT, AuthenticationGuestSessionSchema.class, null);
    }

    public AuthenticationRequestTokenSchema createRequestToken() {
        return this.tmdbClient.get(V3_AUTHENTICATION_TOKEN_NEW_ENDPOINT, AuthenticationRequestTokenSchema.class, null);
    }

    public AuthenticationSessionSchema convertSession(String accessToken) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("access_token", accessToken);
        AuthenticationSessionSchema result = this.tmdbClient.post(V3_AUTHENTICATION_SESSION_CONVERT_4_ENDPOINT, AuthenticationSessionSchema.class, null, jsonObject.toString());
        if (result != null && result.getSuccess() && result.getSessionId() != null) {
            this.tmdbClient.setSessionId(result.getSessionId());
        }
        return result;
    }

    public AuthenticationSessionSchema createSession(String requestToken) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("request_token", requestToken);
        AuthenticationSessionSchema result = this.tmdbClient.post(V3_AUTHENTICATION_SESSION_NEW_ENDPOINT, AuthenticationSessionSchema.class, null, jsonObject.toString());
        if (result != null && result.getSuccess() && result.getSessionId() != null) {
            this.tmdbClient.setSessionId(result.getSessionId());
        }
        return result;
    }

    public SuccessSchema deleteSession(String sessionId) {
        HashMap<String, String> query = new HashMap<String, String>();
        AuthenticationEndpoint.addQueryString(query, "session_id", sessionId);
        SuccessSchema result = this.tmdbClient.delete(V3_AUTHENTICATION_SESSION_ENDPOINT, SuccessSchema.class, query);
        if (result != null && result.getSuccess()) {
            this.tmdbClient.setSessionId(null);
        }
        return result;
    }

    public AuthenticationRequestTokenSchema validateTokenWithLogin(String requestToken, String username, String password) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("request_token", requestToken);
        jsonObject.addProperty("username", username);
        jsonObject.addProperty("password", password);
        return this.tmdbClient.post(V3_AUTHENTICATION_TOKEN_VALIDATE_WITH_LOGIN_ENDPOINT, AuthenticationRequestTokenSchema.class, null, jsonObject.toString());
    }
}

