/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.coverartarchive.api;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CoverArtArchiveRateLimiter {
    private static final AtomicInteger REQUEST_ID = new AtomicInteger();
    private static final ConcurrentHashMap<Integer, Long> REQUESTS = new ConcurrentHashMap();
    private static final int REQUEST_LIMIT = 40;
    private static final int REQUEST_LIMIT_MILLIS = 1000;
    private static final int REQUEST_LIMIT_WAIT_MILLIS = 25;

    private CoverArtArchiveRateLimiter() {
    }

    public static int getRequestId() throws InterruptedException {
        int id = REQUEST_ID.getAndIncrement();
        while (!CoverArtArchiveRateLimiter.hasRequestLimitWindow(id)) {
            Thread.sleep(25L);
        }
        return id;
    }

    public static synchronized void setRequestEnd(int id) {
        REQUESTS.put(id, System.currentTimeMillis());
    }

    private static synchronized boolean hasRequestLimitWindow(int id) {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Integer, Long>> iter = REQUESTS.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Long> entry = iter.next();
            if (entry.getValue() + 1000L >= now) continue;
            iter.remove();
        }
        if (REQUESTS.size() < 40) {
            REQUESTS.put(id, System.currentTimeMillis());
            return true;
        }
        return false;
    }
}

