/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.coverartarchive.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.universalmediaserver.coverartarchive.api.CoverArtArchiveException;
import com.universalmediaserver.coverartarchive.api.CoverArtArchiveRateLimiter;
import com.universalmediaserver.coverartarchive.api.endpoint.release.ReleaseEndpoint;
import com.universalmediaserver.coverartarchive.api.endpoint.release_group.ReleaseGroupEndpoint;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoverArtArchiveClient {
    private static final String DEFAULT_BASE_URL = "https://coverartarchive.org/";
    private static final Gson GSON = new GsonBuilder().create();
    private static final String ERROR = ": CoverArtArchive error";
    private static final String ERROR_REQUEST = "Error while sending the request";
    private String userAgent;
    private String baseUrl;
    private String lastBody;
    private boolean testing;

    public CoverArtArchiveClient() {
        this(DEFAULT_BASE_URL, null);
    }

    public CoverArtArchiveClient(String userAgent) {
        this(DEFAULT_BASE_URL, userAgent);
    }

    public CoverArtArchiveClient(String baseUrl, String userAgent) {
        this.baseUrl = baseUrl;
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getLastBody() {
        return this.lastBody;
    }

    public void setUserAgent(String value) {
        this.userAgent = value;
    }

    public void setBaseUrl(String value) {
        this.baseUrl = value;
    }

    public void setTesting(boolean value) {
        this.testing = value;
    }

    public ReleaseEndpoint release(String musicBrainzId) {
        return new ReleaseEndpoint(this, musicBrainzId);
    }

    public ReleaseGroupEndpoint releaseGroup(String musicBrainzId) {
        return new ReleaseGroupEndpoint(this, musicBrainzId);
    }

    public <T> T get(String endpoint, Class<T> resultClass, Map<String, String> query) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).GET().build();
            return this.getResult(request, resultClass);
        }
        catch (CoverArtArchiveException ex) {
            Logger.getLogger(CoverArtArchiveClient.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public <T> T post(String endpoint, Class<T> resultClass, Map<String, String> query, String postData) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).POST(HttpRequest.BodyPublishers.ofString(postData)).build();
            return this.getResult(request, resultClass);
        }
        catch (CoverArtArchiveException ex) {
            Logger.getLogger(CoverArtArchiveClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public <T> T put(String endpoint, Class<T> resultClass, Map<String, String> query, String postData) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).PUT(HttpRequest.BodyPublishers.ofString(postData)).build();
            return this.getResult(request, resultClass);
        }
        catch (CoverArtArchiveException ex) {
            Logger.getLogger(CoverArtArchiveClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public <T> T delete(String endpoint, Class<T> resultClass, Map<String, String> query) {
        try {
            HttpRequest request = this.getBuilder(endpoint, query).DELETE().build();
            return this.getResult(request, resultClass);
        }
        catch (CoverArtArchiveException ex) {
            Logger.getLogger(CoverArtArchiveClient.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private <T> T getResult(HttpRequest request, Class<T> resultClass) throws CoverArtArchiveException {
        try {
            int requestId = CoverArtArchiveRateLimiter.getRequestId();
            return this.getResult(requestId, request, resultClass);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private <T> T getResult(int requestId, HttpRequest request, Class<T> resultClass) throws InterruptedException, CoverArtArchiveException {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            int statusCode = response.statusCode();
            if (this.testing) {
                this.lastBody = body;
            }
            if (statusCode >= 200 && statusCode < 300) {
                T t = GSON.fromJson(body, resultClass);
                return t;
            }
            try {
                throw new CoverArtArchiveException(statusCode + ERROR);
            }
            catch (IOException ex) {
                throw new CoverArtArchiveException(ERROR_REQUEST, ex);
            }
        }
        finally {
            CoverArtArchiveRateLimiter.setRequestEnd(requestId);
        }
    }

    private String getRedirectLocation(int requestId, HttpRequest request) throws InterruptedException, CoverArtArchiveException {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            if (statusCode == 307 && response.headers().firstValue("location").isPresent()) {
                String string = response.headers().firstValue("location").orElse(null);
                return string;
            }
            if (statusCode == 404) {
                String string = null;
                return string;
            }
            try {
                throw new CoverArtArchiveException(statusCode + ERROR);
            }
            catch (IOException ex) {
                throw new CoverArtArchiveException(ERROR_REQUEST, ex);
            }
        }
        finally {
            CoverArtArchiveRateLimiter.setRequestEnd(requestId);
        }
    }

    public String getRedirectLocation(String endpoint) {
        try {
            HttpRequest request = this.getBuilder(endpoint, null).GET().build();
            int requestId = CoverArtArchiveRateLimiter.getRequestId();
            return this.getRedirectLocation(requestId, request);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (CoverArtArchiveException ex) {
            Logger.getLogger(CoverArtArchiveClient.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private byte[] getJpegBytes(int requestId, HttpRequest request) throws InterruptedException, CoverArtArchiveException {
        try {
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpResponse<byte[]> response = client.send(request, HttpResponse.BodyHandlers.ofByteArray());
            int statusCode = response.statusCode();
            switch (statusCode) {
                case 200: {
                    byte[] byArray = response.body();
                    return byArray;
                }
                case 404: {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
            }
            try {
                throw new CoverArtArchiveException(statusCode + ERROR);
            }
            catch (IOException ex) {
                throw new CoverArtArchiveException(ERROR_REQUEST, ex);
            }
        }
        finally {
            CoverArtArchiveRateLimiter.setRequestEnd(requestId);
        }
    }

    public byte[] getJpegBytes(String endpoint) {
        try {
            HttpRequest request = this.getBuilder(endpoint, null).GET().setHeader("accept", "image/jpeg").build();
            int requestId = CoverArtArchiveRateLimiter.getRequestId();
            return this.getJpegBytes(requestId, request);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CoverArtArchiveException ex) {
            Logger.getLogger(CoverArtArchiveClient.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return new byte[0];
    }

    private HttpRequest.Builder getBuilder(String endpoint, Map<String, String> query) throws CoverArtArchiveException {
        URI requestUri;
        URI contextURI;
        StringBuilder urlBuilder = new StringBuilder();
        if (query == null) {
            query = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> param : query.entrySet()) {
            String value = param.getValue();
            if (value == null || value.trim().length() <= 0) continue;
            urlBuilder.append(urlBuilder.isEmpty() ? "?" : "&");
            String key = param.getKey();
            value = URLEncoder.encode(value, StandardCharsets.UTF_8);
            urlBuilder.append(key).append("=").append(value);
        }
        urlBuilder.insert(0, endpoint);
        try {
            contextURI = new URI(this.baseUrl);
        }
        catch (URISyntaxException ex) {
            throw new CoverArtArchiveException("Base url '" + this.baseUrl + "' malformed", ex);
        }
        try {
            requestUri = contextURI.resolve(urlBuilder.toString());
        }
        catch (IllegalArgumentException ex) {
            throw new CoverArtArchiveException("Request url malformed", ex);
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder(requestUri).setHeader("Content-Type", "application/json;charset=utf-8").setHeader("accept", "application/json");
        if (this.userAgent != null) {
            builder.setHeader("userAgent", this.userAgent);
        }
        return builder;
    }
}

