/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.svg;

import com.twelvemonkeys.imageio.plugins.svg.SVGImageReader;
import com.twelvemonkeys.imageio.plugins.svg.SVGProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.SystemUtil;
import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public final class SVGImageReaderSpi
extends ImageReaderSpiBase {
    static final boolean SVG_READER_AVAILABLE = SystemUtil.isClassAvailable("com.twelvemonkeys.imageio.plugins.svg.SVGImageReader", SVGImageReaderSpi.class);

    public SVGImageReaderSpi() {
        super(new SVGProviderInfo());
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && SVGImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        try {
            int n;
            imageInputStream.mark();
            while (Character.isWhitespace((char)(n = imageInputStream.read()))) {
            }
            if (n != 60) {
                boolean bl = false;
                return bl;
            }
            byte[] byArray = new byte[4];
            block11: while (true) {
                imageInputStream.readFully(byArray);
                if (byArray[0] == 63) {
                    while ((imageInputStream.readByte() & 0xFF) != 63 || imageInputStream.read() != 62) {
                    }
                } else if (byArray[0] == 33) {
                    if (byArray[1] == 45 && byArray[2] == 45) {
                        while ((imageInputStream.readByte() & 0xFF) != 45 || imageInputStream.read() != 45 || imageInputStream.read() != 62) {
                        }
                    } else if (byArray[1] == 68 && byArray[2] == 79 && byArray[3] == 67 && imageInputStream.read() == 84 && imageInputStream.read() == 89 && imageInputStream.read() == 80 && imageInputStream.read() == 69) {
                        while (Character.isWhitespace((char)(n = imageInputStream.read()))) {
                        }
                        if (n == 115 && imageInputStream.read() == 118 && imageInputStream.read() == 103) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    if (byArray[0] == 115 && byArray[1] == 118 && byArray[2] == 103 && (Character.isWhitespace((char)byArray[3]) || byArray[3] == 58)) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                while (true) {
                    if ((imageInputStream.readByte() & 0xFF) == 60) continue block11;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new SVGImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Scalable Vector Graphics (SVG) format image reader";
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (!SVG_READER_AVAILABLE) {
            System.err.println("Could not instantiate SVGImageReader (missing support classes).");
            try {
                new SVGImageReader(this);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            IIOUtil.deregisterProvider(serviceRegistry, this, clazz);
        }
    }
}

