/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pntg;

import com.twelvemonkeys.imageio.plugins.pntg.PNTGImageReader;
import com.twelvemonkeys.imageio.plugins.pntg.PNTGProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.stream.ImageInputStream;

public final class PNTGImageReaderSpi
extends ImageReaderSpiBase {
    public PNTGImageReaderSpi() {
        super(new PNTGProviderInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            boolean bl = PNTGImageReaderSpi.isMacBinaryPNTG(imageInputStream);
            return bl;
        }
        catch (EOFException eOFException) {
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    static boolean isMacBinaryPNTG(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.seek(0L);
        if (imageInputStream.readByte() != 0) {
            return false;
        }
        byte by = imageInputStream.readByte();
        if (by < 0 || by > 63) {
            return false;
        }
        imageInputStream.skipBytes(63);
        return imageInputStream.readInt() == 1347310663 && (imageInputStream.readInt() & 0x80808080) == 0;
    }

    @Override
    public PNTGImageReader createReaderInstance(Object object) {
        return new PNTGImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Apple MacPaint Painting (PNTG) image reader";
    }
}

