/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.PICTImageReader;
import com.twelvemonkeys.imageio.plugins.pict.PICTUtil;
import com.twelvemonkeys.imageio.plugins.pict.QTBMPDecompressor;
import com.twelvemonkeys.imageio.plugins.pict.QTDecompressor;
import com.twelvemonkeys.imageio.plugins.pict.QTGenericDecompressor;
import com.twelvemonkeys.imageio.plugins.pict.QTRAWDecompressor;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class QuickTime {
    static final String VENDOR_APPLE = "appl";
    private static final List<QTDecompressor> sDecompressors = Arrays.asList(new QTBMPDecompressor(), new QTRAWDecompressor(), new QTGenericDecompressor());

    QuickTime() {
    }

    private static QTDecompressor getDecompressor(ImageDesc imageDesc) {
        for (QTDecompressor qTDecompressor : sDecompressors) {
            if (!qTDecompressor.canDecompress(imageDesc)) continue;
            return qTDecompressor;
        }
        return null;
    }

    public static BufferedImage decompress(ImageInputStream imageInputStream) throws IOException {
        QTDecompressor qTDecompressor;
        ImageDesc imageDesc = ImageDesc.read(imageInputStream);
        if (PICTImageReader.DEBUG) {
            System.out.println(imageDesc);
        }
        if ((qTDecompressor = QuickTime.getDecompressor(imageDesc)) == null) {
            return null;
        }
        try (InputStream inputStream = IIOUtil.createStreamAdapter(imageInputStream, imageDesc.dataSize);){
            BufferedImage bufferedImage = qTDecompressor.decompress(imageDesc, inputStream);
            return bufferedImage;
        }
    }

    static final class ImageDesc {
        private static final int SIZE = 86;
        int size;
        String compressorIdentifer;
        short version;
        short revision;
        String compressorVendor;
        int temporalQuality;
        int spatialQuality;
        int width;
        int height;
        double horizontalRes;
        double verticalRes;
        int dataSize;
        int frameCount;
        String compressorName;
        short depth;
        short colorLUTId;
        byte[] extraDesc;

        ImageDesc() {
        }

        public static ImageDesc read(DataInput dataInput) throws IOException {
            ImageDesc imageDesc = new ImageDesc();
            imageDesc.size = dataInput.readInt();
            imageDesc.compressorIdentifer = PICTUtil.readIdString(dataInput);
            dataInput.skipBytes(4);
            dataInput.skipBytes(2);
            dataInput.skipBytes(2);
            imageDesc.version = dataInput.readShort();
            imageDesc.revision = dataInput.readShort();
            imageDesc.compressorVendor = PICTUtil.readIdString(dataInput);
            imageDesc.temporalQuality = dataInput.readInt();
            imageDesc.spatialQuality = dataInput.readInt();
            imageDesc.width = dataInput.readShort();
            imageDesc.height = dataInput.readShort();
            imageDesc.horizontalRes = PICTUtil.readFixedPoint(dataInput);
            imageDesc.verticalRes = PICTUtil.readFixedPoint(dataInput);
            imageDesc.dataSize = dataInput.readInt();
            imageDesc.frameCount = dataInput.readShort();
            imageDesc.compressorName = PICTUtil.readStr31(dataInput);
            imageDesc.depth = dataInput.readShort();
            imageDesc.colorLUTId = dataInput.readShort();
            int n = imageDesc.size - 86;
            if (n < 0) {
                throw new IIOException("Negative array size in 'idsc' Atom: " + n);
            }
            imageDesc.extraDesc = new byte[n];
            dataInput.readFully(imageDesc.extraDesc);
            return imageDesc;
        }

        public String toString() {
            return String.format("'idsc', size: %s, id: '%s', ver: %s, rev: %s, vendor: '%s', w: %d, h: %d, data-size: %d, frame-count: %s, name: '%s', depth: %d, lut: %s, extra: %d", this.size, this.compressorIdentifer, this.version, this.revision, this.compressorVendor, this.width, this.height, this.dataSize, this.frameCount, this.compressorName, this.depth, this.colorLUTId, this.extraDesc != null ? this.extraDesc.length : 0);
        }
    }
}

