/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jupnp.support.model.dlna.DLNAConversionIndicatorAttribute;
import org.jupnp.support.model.dlna.DLNAFlagsAttribute;
import org.jupnp.support.model.dlna.DLNAOperationsAttribute;
import org.jupnp.support.model.dlna.DLNAPlaySpeedAttribute;
import org.jupnp.support.model.dlna.DLNAProfileAttribute;
import org.jupnp.support.model.dlna.InvalidDLNAProtocolAttributeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DLNAAttribute<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DLNAAttribute.class);
    private T value;

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public abstract void setString(String var1, String var2);

    public abstract String getString();

    public static DLNAAttribute<?> newInstance(Type type, String attributeValue, String contentFormat) {
        DLNAAttribute<?> attr = null;
        for (int i = 0; i < type.getAttributeTypes().length && attr == null; ++i) {
            Class<DLNAAttribute<?>> attributeClass = type.getAttributeTypes()[i];
            try {
                LOGGER.trace("Trying to parse DLNA '{}' with class: {}", (Object)type, (Object)attributeClass.getSimpleName());
                attr = attributeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (attributeValue == null) continue;
                attr.setString(attributeValue, contentFormat);
                continue;
            }
            catch (InvalidDLNAProtocolAttributeException e) {
                LOGGER.trace("Invalid DLNA attribute value for tested type: {} - {}", (Object)attributeClass.getSimpleName(), (Object)e.getMessage());
                attr = null;
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error instantiating DLNA attribute of type '{}' with value: {}", new Object[]{type, attributeValue, e});
            }
        }
        return attr;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") '" + String.valueOf(this.getValue()) + "'";
    }

    public static enum Type {
        DLNA_ORG_PN("DLNA.ORG_PN", DLNAProfileAttribute.class),
        DLNA_ORG_OP("DLNA.ORG_OP", DLNAOperationsAttribute.class),
        DLNA_ORG_PS("DLNA.ORG_PS", DLNAPlaySpeedAttribute.class),
        DLNA_ORG_CI("DLNA.ORG_CI", DLNAConversionIndicatorAttribute.class),
        DLNA_ORG_FLAGS("DLNA.ORG_FLAGS", DLNAFlagsAttribute.class);

        private static final Map<String, Type> byName;
        private final String attributeName;
        private final Class<? extends DLNAAttribute<?>>[] attributeTypes;

        @SafeVarargs
        private Type(String attributeName, Class<? extends DLNAAttribute<?>> ... attributeClass) {
            this.attributeName = attributeName;
            this.attributeTypes = attributeClass;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public Class<? extends DLNAAttribute<?>>[] getAttributeTypes() {
            return this.attributeTypes;
        }

        public static Type valueOfAttributeName(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            return byName.get(attributeName.toUpperCase(Locale.ROOT));
        }

        static {
            byName = new HashMap<String, Type>(){
                private static final long serialVersionUID = -4611773458029624524L;
                {
                    for (Type t : Type.values()) {
                        this.put(t.getAttributeName().toUpperCase(Locale.ROOT), t);
                    }
                }
            };
        }
    }
}

