/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.igd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDADeviceType;
import org.jupnp.model.types.UDAServiceType;
import org.jupnp.registry.DefaultRegistryListener;
import org.jupnp.registry.Registry;
import org.jupnp.support.igd.callback.PortMappingAdd;
import org.jupnp.support.igd.callback.PortMappingDelete;
import org.jupnp.support.model.PortMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMappingListener
extends DefaultRegistryListener {
    private final Logger logger = LoggerFactory.getLogger(PortMappingListener.class);
    public static final DeviceType IGD_DEVICE_TYPE = new UDADeviceType("InternetGatewayDevice", 1);
    public static final DeviceType CONNECTION_DEVICE_TYPE = new UDADeviceType("WANConnectionDevice", 1);
    public static final ServiceType IP_SERVICE_TYPE = new UDAServiceType("WANIPConnection", 1);
    public static final ServiceType PPP_SERVICE_TYPE = new UDAServiceType("WANPPPConnection", 1);
    protected PortMapping[] portMappings;
    protected Map<Service<?, ?>, List<PortMapping>> activePortMappings = new HashMap();

    public PortMappingListener(PortMapping portMapping) {
        this(new PortMapping[]{portMapping});
    }

    public PortMappingListener(PortMapping[] portMappings) {
        this.portMappings = portMappings;
    }

    @Override
    public synchronized void deviceAdded(Registry registry, Device device) {
        Service<?, ?> connectionService = this.discoverConnectionService(device);
        if (connectionService == null) {
            return;
        }
        this.logger.debug("Activating port mappings on: {}", (Object)connectionService);
        final ArrayList activeForService = new ArrayList();
        for (final PortMapping pm : this.portMappings) {
            new PortMappingAdd(this, connectionService, registry.getUpnpService().getControlPoint(), pm){
                final /* synthetic */ PortMappingListener this$0;
                {
                    this.this$0 = this$0;
                    super(service, controlPoint, portMapping);
                }

                @Override
                public void success(ActionInvocation invocation) {
                    this.this$0.logger.debug("Port mapping added: {}", (Object)pm);
                    activeForService.add(pm);
                }

                @Override
                public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                    this.this$0.handleFailureMessage("Failed to add port mapping: " + String.valueOf(pm));
                    this.this$0.handleFailureMessage("Reason: " + defaultMsg);
                }
            }.run();
        }
        this.activePortMappings.put(connectionService, activeForService);
    }

    @Override
    public synchronized void deviceRemoved(Registry registry, Device device) {
        for (Service service : device.findServices()) {
            Iterator<Map.Entry<Service<?, ?>, List<PortMapping>>> it = this.activePortMappings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Service<?, ?>, List<PortMapping>> activeEntry = it.next();
                if (!activeEntry.getKey().equals(service)) continue;
                if (!activeEntry.getValue().isEmpty()) {
                    this.handleFailureMessage("Device disappeared, couldn't delete port mappings: " + activeEntry.getValue().size());
                }
                it.remove();
            }
        }
    }

    @Override
    public synchronized void beforeShutdown(Registry registry) {
        for (Map.Entry<Service<?, ?>, List<PortMapping>> activeEntry : this.activePortMappings.entrySet()) {
            final Iterator<PortMapping> it = activeEntry.getValue().iterator();
            while (it.hasNext()) {
                final PortMapping pm = it.next();
                this.logger.debug("Trying to delete port mapping on IGD: {}", (Object)pm);
                new PortMappingDelete(this, activeEntry.getKey(), registry.getUpnpService().getControlPoint(), pm){
                    final /* synthetic */ PortMappingListener this$0;
                    {
                        this.this$0 = this$0;
                        super(service, controlPoint, portMapping);
                    }

                    @Override
                    public void success(ActionInvocation invocation) {
                        this.this$0.logger.debug("Port mapping deleted: {}", (Object)pm);
                        it.remove();
                    }

                    @Override
                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                        this.this$0.handleFailureMessage("Failed to delete port mapping: " + String.valueOf(pm));
                        this.this$0.handleFailureMessage("Reason: " + defaultMsg);
                    }
                }.run();
            }
        }
    }

    protected Service<?, ?> discoverConnectionService(Device<?, ?, ?> device) {
        if (!device.getType().equals(IGD_DEVICE_TYPE)) {
            return null;
        }
        Device[] connectionDevices = device.findDevices(CONNECTION_DEVICE_TYPE);
        if (connectionDevices.length == 0) {
            this.logger.debug("IGD doesn't support '{}': {}", (Object)CONNECTION_DEVICE_TYPE, (Object)device);
            return null;
        }
        Device connectionDevice = connectionDevices[0];
        this.logger.debug("Using first discovered WAN connection device: {}", (Object)connectionDevice);
        Object ipConnectionService = connectionDevice.findService(IP_SERVICE_TYPE);
        Object pppConnectionService = connectionDevice.findService(PPP_SERVICE_TYPE);
        if (ipConnectionService == null && pppConnectionService == null) {
            this.logger.debug("IGD doesn't support IP or PPP WAN connection service: {}", (Object)device);
        }
        return ipConnectionService != null ? ipConnectionService : pppConnectionService;
    }

    protected void handleFailureMessage(String s) {
        this.logger.warn(s);
    }
}

