/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.contentdirectory.callback;

import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.contentdirectory.DIDLParser;
import org.jupnp.support.model.DIDLContent;
import org.jupnp.support.model.SearchResult;
import org.jupnp.support.model.SortCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Search
extends ActionCallback {
    private static final long DEFAULT_MAX_RESULTS = 999L;
    public static final String CAPS_WILDCARD = "*";
    private final Logger logger = LoggerFactory.getLogger(Search.class);

    protected Search(Service<?, ?> service, String containerId, String searchCriteria) {
        this(service, containerId, searchCriteria, CAPS_WILDCARD, 0L, null, new SortCriterion[0]);
    }

    protected Search(Service<?, ?> service, String containerId, String searchCriteria, String filter, long firstResult, Long maxResults, SortCriterion ... orderBy) {
        super(new ActionInvocation(service.getAction("Search")));
        this.logger.debug("Creating browse action for container ID: {}", (Object)containerId);
        this.getActionInvocation().setInput("ContainerID", containerId);
        this.getActionInvocation().setInput("SearchCriteria", searchCriteria);
        this.getActionInvocation().setInput("Filter", filter);
        this.getActionInvocation().setInput("StartingIndex", new UnsignedIntegerFourBytes(firstResult));
        this.getActionInvocation().setInput("RequestedCount", new UnsignedIntegerFourBytes(maxResults == null ? this.getDefaultMaxResults() : maxResults));
        this.getActionInvocation().setInput("SortCriteria", SortCriterion.toString(orderBy));
    }

    @Override
    public void run() {
        this.updateStatus(Status.LOADING);
        super.run();
    }

    @Override
    public void success(ActionInvocation actionInvocation) {
        this.logger.debug("Successful search action, reading output argument values");
        SearchResult result = new SearchResult(actionInvocation.getOutput("Result").getValue().toString(), (UnsignedIntegerFourBytes)actionInvocation.getOutput("NumberReturned").getValue(), (UnsignedIntegerFourBytes)actionInvocation.getOutput("TotalMatches").getValue(), (UnsignedIntegerFourBytes)actionInvocation.getOutput("UpdateID").getValue());
        boolean proceed = this.receivedRaw(actionInvocation, result);
        if (proceed && result.getCountLong() > 0L && !result.getResult().isEmpty()) {
            try {
                DIDLParser didlParser = new DIDLParser();
                DIDLContent didl = didlParser.parse(result.getResult());
                this.received(actionInvocation, didl);
                this.updateStatus(Status.OK);
            }
            catch (Exception e) {
                actionInvocation.setFailure(new ActionException(ErrorCode.ACTION_FAILED, "Can't parse DIDL XML response: " + String.valueOf(e), (Throwable)e));
                this.failure(actionInvocation, null);
            }
        } else {
            this.received(actionInvocation, new DIDLContent());
            this.updateStatus(Status.NO_CONTENT);
        }
    }

    public Long getDefaultMaxResults() {
        return 999L;
    }

    public boolean receivedRaw(ActionInvocation<?> actionInvocation, SearchResult searchResult) {
        return true;
    }

    public abstract void received(ActionInvocation<?> var1, DIDLContent var2);

    public abstract void updateStatus(Status var1);

    public static enum Status {
        NO_CONTENT("No Content"),
        LOADING("Loading..."),
        OK("OK");

        private final String defaultMessage;

        private Status(String defaultMessage) {
            this.defaultMessage = defaultMessage;
        }

        public String getDefaultMessage() {
            return this.defaultMessage;
        }
    }
}

