/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.common;

import jakarta.websocket.EncodeException;
import jakarta.websocket.Encoder;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketRemoteEndpoint;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.ee10.websocket.jakarta.common.SendHandlerCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.messages.MessageOutputStream;
import org.eclipse.jetty.websocket.core.messages.MessageWriter;
import org.eclipse.jetty.websocket.core.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaWebSocketAsyncRemote
extends JakartaWebSocketRemoteEndpoint
implements RemoteEndpoint.Async {
    static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketAsyncRemote.class);

    protected JakartaWebSocketAsyncRemote(JakartaWebSocketSession session, CoreSession coreSession) {
        super(session, coreSession);
    }

    @Override
    public long getSendTimeout() {
        return this.getWriteTimeout();
    }

    @Override
    public void setSendTimeout(long timeoutmillis) {
        this.setWriteTimeout(timeoutmillis);
    }

    @Override
    public Future<Void> sendBinary(ByteBuffer data) {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", (Object)BufferUtil.toDetailString(data));
        }
        FutureCallback future = new FutureCallback();
        this.sendFrame(new Frame(2).setPayload(data), future, this.batch);
        return future;
    }

    @Override
    public void sendBinary(ByteBuffer data, SendHandler handler) {
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", (Object)BufferUtil.toDetailString(data), (Object)handler);
        }
        this.sendFrame(new Frame(2).setPayload(data), new SendHandlerCallback(handler), this.batch);
    }

    @Override
    public Future<Void> sendObject(Object data) {
        FutureCallback future = new FutureCallback();
        try {
            this.sendObject(data, future);
        }
        catch (Throwable t) {
            future.failed(t);
        }
        return future;
    }

    @Override
    public void sendObject(Object data, SendHandler handler) {
        Encoder encoder;
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendObject({},{})", data, (Object)handler);
        }
        if ((encoder = this.session.getEncoders().getInstanceFor(data.getClass())) == null) {
            throw new IllegalArgumentException("No encoder for type: " + String.valueOf(data.getClass()));
        }
        if (encoder instanceof Encoder.Text) {
            Encoder.Text etxt = (Encoder.Text)encoder;
            try {
                String msg = etxt.encode(data);
                this.sendText(msg, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.TextStream) {
            Encoder.TextStream etxt = (Encoder.TextStream)encoder;
            SendHandlerCallback callback = new SendHandlerCallback(handler);
            try (MessageWriter writer = this.newMessageWriter();){
                writer.setCallback(callback);
                etxt.encode(data, writer);
                return;
            }
            catch (EncodeException | IOException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.Binary) {
            Encoder.Binary ebin = (Encoder.Binary)encoder;
            try {
                ByteBuffer buf = ebin.encode(data);
                this.sendBinary(buf, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.BinaryStream) {
            Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
            SendHandlerCallback callback = new SendHandlerCallback(handler);
            try (MessageOutputStream out = this.newMessageOutputStream();){
                out.setCallback(callback);
                ebin.encode(data, out);
                return;
            }
            catch (EncodeException | IOException e) {
                handler.onResult(new SendResult(e));
            }
        }
        throw new IllegalArgumentException("Unknown encoder type: " + String.valueOf(encoder));
    }

    @Override
    public Future<Void> sendText(String text) {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", (Object)TextUtils.hint(text));
        }
        FutureCallback future = new FutureCallback();
        this.sendFrame(new Frame(1).setPayload(text), future, this.batch);
        return future;
    }

    @Override
    public void sendText(String text, SendHandler handler) {
        this.assertMessageNotNull(text);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", (Object)TextUtils.hint(text), (Object)handler);
        }
        this.sendFrame(new Frame(1).setPayload(text), new SendHandlerCallback(handler), this.batch);
    }
}

