/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtils.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();

    private XmlUtils() {
    }

    public static DocumentBuilderFactory xxeDisabledDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (CONFIGURATION.disableExternalEntities()) {
            String feature = null;
            try {
                feature = "http://apache.org/xml/features/disallow-doctype-decl";
                dbf.setFeature(feature, true);
                feature = "http://xml.org/sax/features/external-general-entities";
                dbf.setFeature(feature, false);
                feature = "http://xml.org/sax/features/external-parameter-entities";
                dbf.setFeature(feature, false);
                feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
                dbf.setFeature(feature, false);
            }
            catch (ParserConfigurationException e) {
                LOGGER.info("ParserConfigurationException was thrown. The feature '{}' is probably not supported by the XML processor.", (Object)feature);
            }
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        return dbf;
    }

    public static TransformerFactory xxeDisabledTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (CONFIGURATION.disableExternalEntities()) {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        return transformerFactory;
    }

    public static XMLInputFactory xxeDisabledXMLInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        if (CONFIGURATION.disableExternalEntities()) {
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        return xmlInputFactory;
    }
}

