/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class SortedHeaderMap
extends TreeMap<String, String> {
    private static final long serialVersionUID = -5090333053981045429L;
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = (s1, s2) -> s1.compareToIgnoreCase((String)s2);
    String headers = null;

    public SortedHeaderMap() {
        super(CASE_INSENSITIVE_COMPARATOR);
    }

    public SortedHeaderMap(Collection<Map.Entry<String, String>> headers) {
        this();
        for (Map.Entry<String, String> h : headers) {
            this.put(h.getKey(), h.getValue());
        }
    }

    @Override
    public final String put(String key, String value) {
        if (StringUtils.isNotBlank(key) && StringUtils.isNotBlank(value)) {
            this.headers = null;
            return super.put(key.trim(), value.trim());
        }
        return null;
    }

    public String put(String raw) {
        return this.put(StringUtils.substringBefore(raw, ":"), StringUtils.substringAfter(raw, ":"));
    }

    public String joined() {
        if (this.headers == null) {
            this.headers = StringUtils.join(this.values(), " ");
        }
        return this.headers;
    }

    public String toRegex() {
        int size = this.size();
        return (size > 1 ? "(" : "") + StringUtils.join(this.values(), ").*(") + (size > 1 ? ")" : "");
    }
}

