/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.transcoding;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineFactory;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.CustomJButton;
import net.pms.swing.components.CustomJSpinner;
import net.pms.swing.components.CustomTabbedPaneUI;
import net.pms.swing.components.JImageButton;
import net.pms.swing.components.KeyedComboBoxModel;
import net.pms.swing.components.KeyedStringComboBoxModel;
import net.pms.swing.components.RestrictedFileSystemView;
import net.pms.swing.components.SpinnerIntModel;
import net.pms.swing.gui.FormLayoutUtil;
import net.pms.swing.gui.JavaGui;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.ViewLevel;
import net.pms.swing.gui.tabs.transcoding.FontFileFilter;
import net.pms.swing.gui.tabs.transcoding.TreeNodeSettings;
import net.pms.swing.gui.tabs.transcoding.TreeRenderer;
import net.pms.util.SubtitleColor;
import net.pms.util.SubtitleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscodingTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranscodingTab.class);
    private static final String COMMON_COL_SPEC = "left:pref, 3dlu, pref:grow";
    private static final String COMMON_ROW_SPEC = "4*(pref, 3dlu), pref, 10dlu, pref, 10dlu:grow, pref";
    private static final String EMPTY_COL_SPEC = "left:pref, 3dlu, pref:grow";
    private static final String EMPTY_ROW_SPEC = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p , 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 20dlu, p, 3dlu, p, 3dlu, p";
    private static final String LEFT_COL_SPEC = "left:pref, pref, pref, pref, 0:grow";
    private static final String LEFT_ROW_SPEC = "fill:10:grow, 3dlu, p, 3dlu, p, 3dlu, p";
    private static final String MAIN_COL_SPEC = "left:pref, pref, 7dlu, pref, pref, fill:10:grow";
    private static final String MAIN_ROW_SPEC = "fill:10:grow";
    private static final String EMPTY_PANEL = "empty_panel";
    private static final int MAX_CORES = 16;
    private static final String BUTTON_ARROW_DOWN = "button-arrow-down.svg";
    private static final String BUTTON_ARROW_UP = "button-arrow-up.svg";
    private static final String BUTTON_TOOGLE_OFF = "button-toggle-off.svg";
    private static final String BUTTON_TOOGLE_ON_DISABLED = "button-toggle-on_disabled.svg";
    private static final String BUTTON_TOOGLE_ON = "button-toggle-on.svg";
    private final UmsConfiguration configuration;
    private final ComponentOrientation orientation;
    private final JavaGui looksFrame;
    private JCheckBox disableSubs;
    private JTextField forcetranscode;
    private JTextField notranscode;
    private JTextField maxbuffer;
    private DefaultMutableTreeNode[] parent;
    private JPanel tabbedPanel;
    private CardLayout cardLayout;
    private JTextField abitrate;
    private JTree tree;
    private JComboBox<String> vq;
    private JComboBox<String> x264Quality;
    private JCheckBox videoHWacceleration;
    private JTextField langs;
    private JTextField defaultsubs;
    private JTextField forcedsub;
    private JTextField forcedtags;
    private JTextField alternateSubFolder;
    private JTextField defaultaudiosubs;
    private JTextField defaultfont;
    private JTextField assScale;
    private JImageButton arrowDownButton;
    private JImageButton arrowUpButton;
    private JImageButton toggleButton;

    public TranscodingTab(UmsConfiguration configuration, JavaGui looksFrame) {
        this.configuration = configuration;
        this.looksFrame = looksFrame;
        this.orientation = ComponentOrientation.getOrientation(PMS.getLocale());
    }

    public JComponent build() {
        String colSpec = FormLayoutUtil.getColSpec(MAIN_COL_SPEC, this.orientation);
        FormLayout layout = new FormLayout(colSpec, MAIN_ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.DLU4);
        builder.opaque(true);
        CellConstraints cc = new CellConstraints();
        if (!this.configuration.isHideAdvancedOptions()) {
            builder.add(this.buildRightTabbedPanel()).at(FormLayoutUtil.flip(cc.xyw(4, 1, 3), colSpec, this.orientation));
            builder.add(this.buildLeft()).at(FormLayoutUtil.flip(cc.xy(2, 1), colSpec, this.orientation));
        } else {
            builder.add(this.buildRightTabbedPanel()).at(FormLayoutUtil.flip(cc.xyw(2, 1, 5), colSpec, this.orientation));
            builder.add(this.buildLeft()).at(FormLayoutUtil.flip(cc.xy(2, 1), colSpec, this.orientation));
        }
        this.addEngines();
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildRightTabbedPanel() {
        this.cardLayout = new CardLayout();
        this.tabbedPanel = new JPanel(this.cardLayout);
        return this.tabbedPanel;
    }

    private void setButtonsState() {
        TreePath path = null;
        if (this.tree != null) {
            path = this.tree.getSelectionModel().getSelectionPath();
        }
        if (path == null || !(path.getLastPathComponent() instanceof TreeNodeSettings) || ((TreeNodeSettings)path.getLastPathComponent()).getPlayer() == null) {
            this.arrowDownButton.setEnabled(false);
            this.arrowUpButton.setEnabled(false);
            this.toggleButton.setIconName(ToggleButtonState.UNKNOWN.getIconName());
            this.toggleButton.setEnabled(false);
        } else {
            TreeNodeSettings node = (TreeNodeSettings)path.getLastPathComponent();
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            int index = treeModel.getIndexOfChild(node.getParent(), node);
            this.arrowUpButton.setEnabled(index != 0);
            this.arrowDownButton.setEnabled(index != node.getParent().getChildCount() - 1);
            Engine player = node.getPlayer();
            if (player.isEnabled()) {
                this.toggleButton.setIconName(ToggleButtonState.ON.getIconName());
                this.toggleButton.setEnabled(true);
            } else {
                this.toggleButton.setIconName(ToggleButtonState.OFF.getIconName());
                this.toggleButton.setEnabled(player.isAvailable());
            }
        }
    }

    public JComponent buildLeft() {
        String colSpec = FormLayoutUtil.getColSpec(LEFT_COL_SPEC, this.orientation);
        FormLayout layout = new FormLayout(colSpec, LEFT_ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.EMPTY);
        builder.opaque(false);
        CellConstraints cc = new CellConstraints();
        this.arrowDownButton = new JImageButton(BUTTON_ARROW_DOWN);
        this.arrowDownButton.setToolTipText(Messages.getGuiString("ChangePositionSelectedEngine"));
        this.arrowDownButton.addActionListener(e -> {
            DefaultTreeModel treeModel;
            int index;
            TreeNodeSettings node;
            TreePath path = this.tree.getSelectionModel().getSelectionPath();
            if (path != null && path.getLastPathComponent() instanceof TreeNodeSettings && (node = (TreeNodeSettings)path.getLastPathComponent()).getPlayer() != null && (index = (treeModel = (DefaultTreeModel)this.tree.getModel()).getIndexOfChild(node.getParent(), node)) < node.getParent().getChildCount() - 1) {
                treeModel.insertNodeInto(node, (DefaultMutableTreeNode)node.getParent(), index + 1);
                treeModel.reload();
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
                this.tree.getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
                ((TreeNodeSettings)treeModel.getChild(node.getParent(), index)).getPlayer();
                this.configuration.setEnginePriorityBelow(node.getPlayer(), ((TreeNodeSettings)treeModel.getChild(node.getParent(), index)).getPlayer());
            }
        });
        builder.add(this.arrowDownButton).at(FormLayoutUtil.flip(cc.xy(2, 3), colSpec, this.orientation));
        this.arrowUpButton = new JImageButton(BUTTON_ARROW_UP);
        this.arrowUpButton.setToolTipText(Messages.getGuiString("ChangePositionSelectedEngine"));
        this.arrowUpButton.addActionListener(e -> {
            DefaultTreeModel treeModel;
            int index;
            TreeNodeSettings node;
            TreePath path = this.tree.getSelectionModel().getSelectionPath();
            if (path != null && path.getLastPathComponent() instanceof TreeNodeSettings && (node = (TreeNodeSettings)path.getLastPathComponent()).getPlayer() != null && (index = (treeModel = (DefaultTreeModel)this.tree.getModel()).getIndexOfChild(node.getParent(), node)) != 0) {
                treeModel.insertNodeInto(node, (DefaultMutableTreeNode)node.getParent(), index - 1);
                treeModel.reload();
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
                this.tree.getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
                this.configuration.setEnginePriorityAbove(node.getPlayer(), ((TreeNodeSettings)treeModel.getChild(node.getParent(), index)).getPlayer());
            }
        });
        builder.add(this.arrowUpButton).at(FormLayoutUtil.flip(cc.xy(3, 3), colSpec, this.orientation));
        this.toggleButton = new JImageButton();
        this.toggleButton.setToolTipText(Messages.getGuiString("EnableDisableTranscodingEngine"));
        this.setButtonsState();
        this.toggleButton.addActionListener(e -> {
            TreePath path = this.tree.getSelectionModel().getSelectionPath();
            if (path != null && path.getLastPathComponent() instanceof TreeNodeSettings && ((TreeNodeSettings)path.getLastPathComponent()).getPlayer() != null) {
                ((TreeNodeSettings)path.getLastPathComponent()).getPlayer().toggleEnabled(true);
                this.tree.updateUI();
                this.setButtonsState();
            }
        });
        builder.add(this.toggleButton).at(FormLayoutUtil.flip(cc.xy(4, 3), colSpec, this.orientation));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Messages.getGuiString("Engines"));
        TreeNodeSettings commonEnc = new TreeNodeSettings(Messages.getGuiString("CommonTranscodeSettings"), null, this.buildCommon());
        this.tabbedPanel.add(commonEnc.id(), commonEnc.getConfigPanel());
        root.add(commonEnc);
        this.parent = new DefaultMutableTreeNode[5];
        this.parent[0] = new DefaultMutableTreeNode(Messages.getGuiString("VideoFilesEngines"));
        this.parent[1] = new DefaultMutableTreeNode(Messages.getGuiString("AudioFilesEngines"));
        this.parent[2] = new DefaultMutableTreeNode(Messages.getGuiString("WebVideoStreamingEngines"));
        this.parent[3] = new DefaultMutableTreeNode(Messages.getGuiString("WebAudioStreamingEngines"));
        this.parent[4] = new DefaultMutableTreeNode(Messages.getGuiString("MiscEngines"));
        root.add(this.parent[0]);
        root.add(this.parent[1]);
        root.add(this.parent[2]);
        root.add(this.parent[3]);
        root.add(this.parent[4]);
        this.tabbedPanel.add(EMPTY_PANEL, new JPanel());
        this.tree = new JTree(new DefaultTreeModel(root)){
            private static final long serialVersionUID = -6703434752606636290L;
        };
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(e -> {
            this.setButtonsState();
            if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() instanceof TreeNodeSettings) {
                TreeNodeSettings tns = (TreeNodeSettings)e.getNewLeadSelectionPath().getLastPathComponent();
                this.cardLayout.show(this.tabbedPanel, tns.id());
            } else {
                this.cardLayout.show(this.tabbedPanel, EMPTY_PANEL);
            }
        });
        this.tree.setRequestFocusEnabled(false);
        this.tree.setCellRenderer(new TreeRenderer());
        JScrollPane pane = new JScrollPane(this.tree, 20, 31);
        builder.add(pane).at(FormLayoutUtil.flip(cc.xyw(2, 1, 4), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("EnginesAreInDescending"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(2, 5, 4), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("OrderTheHighestIsFirst"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(2, 7, 4), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    public void addEngines() {
        if (!EngineFactory.isInitialized()) {
            return;
        }
        for (Engine engine : EngineFactory.getEngines(false, true)) {
            if (this.videoHWacceleration == null || !engine.isGPUAccelerationReady()) continue;
            this.videoHWacceleration.setEnabled(true);
            this.videoHWacceleration.setSelected(this.configuration.isGPUAcceleration());
            break;
        }
        for (Engine engine : EngineFactory.getAllEngines()) {
            TreeNodeSettings engineNode = new TreeNodeSettings(engine.getName(), engine, null);
            JComponent configPanel = engineNode.getConfigPanel();
            if (configPanel == null) {
                configPanel = this.buildEmpty();
            }
            this.tabbedPanel.add(engineNode.id(), configPanel);
            this.parent[engine.purpose()].add(engineNode);
        }
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setSelectionRow(0);
        this.tree.updateUI();
    }

    public JComponent buildEmpty() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, EMPTY_ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.EMPTY);
        builder.opaque(false);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Messages.getGuiString("NoSettingsForNow"), FormLayoutUtil.flip(cc.xyw(1, 1, 3), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    public JComponent buildCommon() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, COMMON_ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.EMPTY);
        builder.opaque(false);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Messages.getGuiString("GeneralSettings_SentenceCase"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 1, 3), colSpec, this.orientation));
        this.disableSubs = new JCheckBox(Messages.getGuiString("DisableSubtitles"), this.configuration.isDisableSubtitles());
        this.disableSubs.setContentAreaFilled(false);
        this.disableSubs.addItemListener(e -> this.configuration.setDisableSubtitles(e.getStateChange() == 1));
        if (!this.configuration.isHideAdvancedOptions()) {
            JCheckBox disableTranscoding = new JCheckBox(Messages.getGuiString("DisableAllTranscoding"), this.configuration.isDisableTranscoding());
            disableTranscoding.setContentAreaFilled(false);
            disableTranscoding.addItemListener(e -> this.configuration.setDisableTranscoding(e.getStateChange() == 1));
            builder.add(SwingUtil.getPreferredSizeComponent(disableTranscoding)).at(FormLayoutUtil.flip(cc.xy(1, 3), colSpec, this.orientation));
            builder.add(new JLabel(Messages.getGuiString("SkipTranscodingFollowingExtensions"))).at(FormLayoutUtil.flip(cc.xy(1, 5), colSpec, this.orientation));
            this.notranscode = new JTextField(this.configuration.getDisableTranscodeForExtensions());
            this.notranscode.setToolTipText(Messages.getGuiString("ThisOverridesRendererConfiguration"));
            this.notranscode.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    TranscodingTab.this.configuration.setDisableTranscodeForExtensions(TranscodingTab.this.notranscode.getText());
                }
            });
            builder.add(this.notranscode).at(FormLayoutUtil.flip(cc.xy(3, 5), colSpec, this.orientation));
            builder.addLabel(Messages.getGuiString("ForceTranscodingFollowingExtensions"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 7), colSpec, this.orientation));
            this.forcetranscode = new JTextField(this.configuration.getForceTranscodeForExtensions());
            this.forcetranscode.setToolTipText(Messages.getGuiString("ThisOverridesRendererConfiguration"));
            this.forcetranscode.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    TranscodingTab.this.configuration.setForceTranscodeForExtensions(TranscodingTab.this.forcetranscode.getText());
                }
            });
            builder.add(this.forcetranscode).at(FormLayoutUtil.flip(cc.xy(3, 7), colSpec, this.orientation));
            builder.addLabel(Messages.getGuiString("MaximumTranscodeBufferSize"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 9), colSpec, this.orientation));
            this.maxbuffer = new JTextField("" + this.configuration.getMaxMemoryBufferSize());
            this.maxbuffer.setToolTipText(Messages.getGuiString("UsingSettingHigherThan200"));
            this.maxbuffer.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        int ab = Integer.parseInt(TranscodingTab.this.maxbuffer.getText());
                        TranscodingTab.this.configuration.setMaxMemoryBufferSize(ab);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.debug("Could not parse max memory buffer size from \"" + TranscodingTab.this.maxbuffer.getText() + "\"");
                    }
                }
            });
            builder.add(this.maxbuffer).at(FormLayoutUtil.flip(cc.xy(3, 9), colSpec, this.orientation));
            String nCpusLabel = String.format(Messages.getGuiString("CpuThreadsToUse"), Runtime.getRuntime().availableProcessors());
            builder.addLabel(nCpusLabel, new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 11), colSpec, this.orientation));
            Integer[] guiCores = new Integer[16];
            for (int i = 0; i < 16; ++i) {
                guiCores[i] = i + 1;
            }
            JComboBox<Integer> nbcores = new JComboBox<Integer>(guiCores);
            nbcores.setEditable(false);
            int nbConfCores = this.configuration.getNumberOfCpuCores();
            if (nbConfCores > 0 && nbConfCores <= 16) {
                nbcores.setSelectedItem(nbConfCores);
            } else {
                nbcores.setSelectedIndex(0);
            }
            nbcores.addItemListener(e -> this.configuration.setNumberOfCpuCores((Integer)e.getItem()));
            builder.add(nbcores).at(FormLayoutUtil.flip(cc.xy(3, 11), colSpec, this.orientation));
        } else {
            builder.add(SwingUtil.getPreferredSizeComponent(this.disableSubs)).at(FormLayoutUtil.flip(cc.xy(1, 3), colSpec, this.orientation));
        }
        if (!this.configuration.isHideAdvancedOptions()) {
            JTabbedPane setupTabbedPanel = new JTabbedPane();
            setupTabbedPanel.setUI(new CustomTabbedPaneUI());
            setupTabbedPanel.addTab(Messages.getGuiString("VideoSettings"), this.buildVideoSetupPanel());
            setupTabbedPanel.addTab(Messages.getGuiString("AudioSettings"), this.buildAudioSetupPanel());
            setupTabbedPanel.addTab(Messages.getGuiString("SubtitlesSettings"), this.buildSubtitlesSetupPanel());
            builder.add(setupTabbedPanel).at(FormLayoutUtil.flip(cc.xywh(1, 13, 3, 1), colSpec, this.orientation));
        }
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildVideoSetupPanel() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, "$lgap, 2*(pref, 3dlu), 10dlu, 10dlu, 4*(pref, 3dlu), pref");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.DLU4);
        CellConstraints cc = new CellConstraints();
        this.videoHWacceleration = new JCheckBox(Messages.getGuiString("EnableGpuAcceleration"), this.configuration.isGPUAcceleration());
        this.videoHWacceleration.addItemListener(e -> this.configuration.setGPUAcceleration(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(this.videoHWacceleration)).at(FormLayoutUtil.flip(cc.xy(1, 2), colSpec, this.orientation));
        this.videoHWacceleration.setEnabled(false);
        JCheckBox mpeg2remux = new JCheckBox(Messages.getGuiString("LosslessDvdVideoPlayback"), this.configuration.isMencoderRemuxMPEG2());
        mpeg2remux.setToolTipText(Messages.getGuiString("WhenEnabledMuxesDvd") + (String)(Platform.isWindows() ? " " + Messages.getGuiString("AviSynthNotSupported") : "") + "</html>");
        mpeg2remux.setContentAreaFilled(false);
        mpeg2remux.addItemListener(e -> this.configuration.setMencoderRemuxMPEG2(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(mpeg2remux)).at(FormLayoutUtil.flip(cc.xy(1, 6), colSpec, this.orientation));
        builder.addSeparator(Messages.getGuiString("MiscSettings"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 8, 3), colSpec, this.orientation));
        builder.add(new JLabel(Messages.getGuiString("TranscodingQualityMpeg2"))).at(FormLayoutUtil.flip(cc.xy(1, 10), colSpec, this.orientation));
        String[] keys = new String[]{"Automatic (Wired)", "Automatic (Wireless)", "keyint=5:vqscale=1:vqmin=1", "keyint=5:vqscale=1:vqmin=2", "keyint=5:vqscale=2:vqmin=3", "keyint=25:vqmax=5:vqmin=2", "keyint=25:vqmax=7:vqmin=2", "keyint=25:vqmax=8:vqmin=3"};
        String[] values = new String[]{Messages.getGuiString("AutomaticWiredRecommend"), Messages.getGuiString("AutomaticWirelessRecommend"), String.format(Messages.getGuiString("LosslessQuality") + "%s", this.looksFrame.getViewLevel().isGreaterOrEqual(ViewLevel.ADVANCED) ? " (keyint=5:vqscale=1:vqmin=1)" : ""), String.format(Messages.getGuiString("GreatQuality") + "%s", this.looksFrame.getViewLevel().isGreaterOrEqual(ViewLevel.ADVANCED) ? " (keyint=5:vqscale=1:vqmin=2)" : ""), String.format(Messages.getGuiString("GoodQuality") + "%s", this.looksFrame.getViewLevel().isGreaterOrEqual(ViewLevel.ADVANCED) ? " (keyint=5:vqscale=2:vqmin=3)" : ""), String.format(Messages.getGuiString("GoodQualityHdWifi") + "%s", this.looksFrame.getViewLevel().isGreaterOrEqual(ViewLevel.ADVANCED) ? " (keyint=25:vqmax=5:vqmin=2)" : ""), String.format(Messages.getGuiString("MediumQualityHdWifi") + "%s", this.looksFrame.getViewLevel().isGreaterOrEqual(ViewLevel.ADVANCED) ? " (keyint=25:vqmax=7:vqmin=2)" : ""), String.format(Messages.getGuiString("LowQualitySlowCpu") + "%s", this.looksFrame.getViewLevel().isGreaterOrEqual(ViewLevel.ADVANCED) ? " (keyint=25:vqmax=8:vqmin=3)" : "")};
        KeyedStringComboBoxModel mPEG2MainModel = new KeyedStringComboBoxModel(keys, values);
        this.vq = new JComboBox<String>(mPEG2MainModel);
        this.vq.setPreferredSize(TranscodingTab.getPreferredHeight(this.vq));
        this.vq.setToolTipText(Messages.getGuiString("AutomaticWiredOrWireless"));
        mPEG2MainModel.setSelectedKey(this.configuration.getMPEG2MainSettings());
        this.vq.setEnabled(!this.configuration.isAutomaticMaximumBitrate());
        this.vq.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setMPEG2MainSettings((String)mPEG2MainModel.getSelectedKey());
            }
        });
        this.vq.setEditable(true);
        builder.add(this.vq).at(FormLayoutUtil.flip(cc.xy(3, 10), colSpec, this.orientation));
        builder.add(new JLabel(Messages.getGuiString("TranscodingQualityH264"))).at(FormLayoutUtil.flip(cc.xy(1, 12), colSpec, this.orientation));
        keys = new String[]{"Automatic (Wired)", "Automatic (Wireless)", "16"};
        values = new String[]{Messages.getGuiString("AutomaticWiredRecommend"), Messages.getGuiString("AutomaticWirelessRecommend"), String.format(Messages.getGuiString("LosslessQuality") + "%s", this.looksFrame.getViewLevel().isGreaterOrEqual(ViewLevel.ADVANCED) ? " (16)" : "")};
        KeyedStringComboBoxModel x264QualityModel = new KeyedStringComboBoxModel(keys, values);
        this.x264Quality = new JComboBox<String>(x264QualityModel);
        this.x264Quality.setPreferredSize(TranscodingTab.getPreferredHeight(this.x264Quality));
        this.x264Quality.setToolTipText(Messages.getGuiString("AutomaticSettingServeBestQuality"));
        x264QualityModel.setSelectedKey(this.configuration.getx264ConstantRateFactor());
        this.x264Quality.setEnabled(!this.configuration.isAutomaticMaximumBitrate());
        this.x264Quality.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setx264ConstantRateFactor((String)x264QualityModel.getSelectedKey());
            }
        });
        this.x264Quality.setEditable(true);
        builder.add(this.x264Quality).at(FormLayoutUtil.flip(cc.xy(3, 12), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildAudioSetupPanel() {
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, "$lgap, pref, 3dlu, 5*(pref, 3dlu), pref, 12dlu, 3*(pref, 3dlu), pref:grow");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.DLU4);
        CellConstraints cc = new CellConstraints();
        builder.addLabel(Messages.getGuiString("MaximumNumberAudioChannelsOutput"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 2), colSpec, this.orientation));
        Integer[] keys = new Integer[]{2, 6};
        String[] values = new String[]{Messages.getGuiString("2ChannelsStereo"), Messages.getGuiString("6Channels51")};
        KeyedComboBoxModel<Integer, String> audioChannelsModel = new KeyedComboBoxModel<Integer, String>(keys, values);
        JComboBox channels = new JComboBox(audioChannelsModel);
        channels.setEditable(false);
        audioChannelsModel.setSelectedKey(this.configuration.getAudioChannelCount());
        channels.addItemListener(e -> this.configuration.setAudioChannelCount((Integer)audioChannelsModel.getSelectedKey()));
        builder.add(SwingUtil.getPreferredSizeComponent(channels)).at(FormLayoutUtil.flip(cc.xy(3, 2), colSpec, this.orientation));
        JCheckBox forcePCM = new JCheckBox(Messages.getGuiString("UseLpcmForAudio"), this.configuration.isAudioUsePCM());
        forcePCM.setToolTipText(Messages.getGuiString("ThisOptionLosslessNotBest"));
        forcePCM.setContentAreaFilled(false);
        forcePCM.addItemListener(e -> this.configuration.setAudioUsePCM(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(forcePCM)).at(FormLayoutUtil.flip(cc.xy(1, 4), colSpec, this.orientation));
        JCheckBox ac3remux = new JCheckBox(Messages.getGuiString("KeepAc3Tracks"), this.configuration.isAudioRemuxAC3());
        ac3remux.setToolTipText(Messages.getGuiString("ThisOptionLosslessVeryStable") + (String)(Platform.isWindows() ? " " + Messages.getGuiString("AviSynthNotSupported") : "") + "</html>");
        ac3remux.setEnabled(!this.configuration.isEncodedAudioPassthrough());
        ac3remux.addItemListener(e -> this.configuration.setAudioRemuxAC3(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(ac3remux)).at(FormLayoutUtil.flip(cc.xy(1, 6), colSpec, this.orientation));
        JCheckBox forceDTSinPCM = new JCheckBox(Messages.getGuiString("KeepDtsTracks"), this.configuration.isAudioEmbedDtsInPcm());
        forceDTSinPCM.setToolTipText(Messages.getGuiString("ThisOptionLosslessUnstable") + (String)(Platform.isWindows() ? " " + Messages.getGuiString("AviSynthNotSupported") : "") + "</html>");
        forceDTSinPCM.setEnabled(!this.configuration.isEncodedAudioPassthrough());
        forceDTSinPCM.setContentAreaFilled(false);
        forceDTSinPCM.addActionListener(e -> this.configuration.setAudioEmbedDtsInPcm(forceDTSinPCM.isSelected()));
        builder.add(SwingUtil.getPreferredSizeComponent(forceDTSinPCM)).at(FormLayoutUtil.flip(cc.xy(1, 8), colSpec, this.orientation));
        JCheckBox encodedAudioPassthrough = new JCheckBox(Messages.getGuiString("EncodedAudioPassthrough"), this.configuration.isEncodedAudioPassthrough());
        encodedAudioPassthrough.setToolTipText(Messages.getGuiString("ThisOptionLossless") + (String)(Platform.isWindows() ? " " + Messages.getGuiString("AviSynthNotSupported") : "") + "</html>");
        encodedAudioPassthrough.setContentAreaFilled(false);
        encodedAudioPassthrough.addItemListener(e -> {
            this.configuration.setEncodedAudioPassthrough(e.getStateChange() == 1);
            ac3remux.setEnabled(e.getStateChange() != 1);
            forceDTSinPCM.setEnabled(e.getStateChange() != 1);
        });
        builder.add(SwingUtil.getPreferredSizeComponent(encodedAudioPassthrough)).at(cc.xyw(1, 10, 3));
        builder.addLabel(Messages.getGuiString("Ac3ReencodingAudioBitrate"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 12), colSpec, this.orientation));
        this.abitrate = new JTextField("" + this.configuration.getAudioBitrate());
        this.abitrate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(TranscodingTab.this.abitrate.getText());
                    TranscodingTab.this.configuration.setAudioBitrate(ab);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.debug("Could not parse audio bitrate from \"" + TranscodingTab.this.abitrate.getText() + "\"");
                }
            }
        });
        builder.add(this.abitrate).at(FormLayoutUtil.flip(cc.xy(3, 12), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("AudioLanguagePriority"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 14), colSpec, this.orientation));
        this.langs = new JTextField(this.configuration.getAudioLanguages());
        this.langs.setToolTipText(Messages.getGuiString("YouCanRearrangeOrderAudio"));
        this.langs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAudioLanguages(TranscodingTab.this.langs.getText());
            }
        });
        builder.add(this.langs).at(FormLayoutUtil.flip(cc.xy(3, 14), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private JComponent buildSubtitlesSetupPanel() {
        int assMarginValue;
        int assShadowValue;
        int assOutlineValue;
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 3dlu, p:grow, 3dlu, right:p:grow, 3dlu, p:grow, 3dlu, right:p:grow, 3dlu, p:grow, 3dlu, right:p:grow, 3dlu, pref:grow", this.orientation);
        FormLayout layout = new FormLayout(colSpec, "$lgap, 11*(pref, 3dlu), pref");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.DLU4);
        CellConstraints cc = new CellConstraints();
        builder.add(SwingUtil.getPreferredSizeComponent(this.disableSubs)).at(FormLayoutUtil.flip(cc.xy(1, 2), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("SubtitlesLanguagePriority"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 4), colSpec, this.orientation));
        this.defaultsubs = new JTextField(this.configuration.getSubtitlesLanguages());
        this.defaultsubs.setToolTipText(Messages.getGuiString("YouCanRearrangeOrderSubtitles"));
        this.defaultsubs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setSubtitlesLanguages(TranscodingTab.this.defaultsubs.getText());
            }
        });
        builder.add(this.defaultsubs).at(FormLayoutUtil.flip(cc.xyw(3, 4, 13), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("ForcedLanguage"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 6), colSpec, this.orientation));
        this.forcedsub = new JTextField(this.configuration.getForcedSubtitleLanguage());
        this.forcedsub.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setForcedSubtitleLanguage(TranscodingTab.this.forcedsub.getText());
            }
        });
        builder.add(this.forcedsub).at(FormLayoutUtil.flip(cc.xyw(3, 6, 3), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("ForcedTags"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(7, 6, 5, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, this.orientation));
        this.forcedtags = new JTextField(this.configuration.getForcedSubtitleTags());
        this.forcedtags.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setForcedSubtitleTags(TranscodingTab.this.forcedtags.getText());
            }
        });
        builder.add(this.forcedtags).at(FormLayoutUtil.flip(cc.xyw(13, 6, 3), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("AudioSubtitlesLanguagePriority"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 8), colSpec, this.orientation));
        this.defaultaudiosubs = new JTextField(this.configuration.getAudioSubLanguages());
        this.defaultaudiosubs.setToolTipText(Messages.getGuiString("AnExplanationDefaultValueAudio"));
        this.defaultaudiosubs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAudioSubLanguages(TranscodingTab.this.defaultaudiosubs.getText());
            }
        });
        builder.add(this.defaultaudiosubs).at(FormLayoutUtil.flip(cc.xyw(3, 8, 13), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("AlternateSubtitlesFolder"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 10), colSpec, this.orientation));
        this.alternateSubFolder = new JTextField(this.configuration.getAlternateSubtitlesFolder());
        this.alternateSubFolder.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAlternateSubtitlesFolder(TranscodingTab.this.alternateSubFolder.getText());
            }
        });
        builder.add(this.alternateSubFolder).at(FormLayoutUtil.flip(cc.xyw(3, 10, 12), colSpec, this.orientation));
        JButton folderSelectButton = new JButton("...");
        folderSelectButton.addActionListener(e -> {
            JFileChooser chooser;
            try {
                chooser = new JFileChooser();
            }
            catch (Exception ee) {
                chooser = new JFileChooser(new RestrictedFileSystemView());
            }
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showDialog((Component)e.getSource(), Messages.getGuiString("ChooseAFolder"));
            if (returnVal == 0) {
                this.alternateSubFolder.setText(chooser.getSelectedFile().getAbsolutePath());
                this.configuration.setAlternateSubtitlesFolder(chooser.getSelectedFile().getAbsolutePath());
            }
        });
        builder.add(folderSelectButton).at(FormLayoutUtil.flip(cc.xy(15, 10), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("NonUnicodeSubtitleEncoding"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 12), colSpec, this.orientation));
        String[] keys = new String[]{"", "cp874", "cp932", "cp936", "cp949", "cp950", "cp1250", "cp1251", "cp1252", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "cp1258", "ISO-2022-CN", "ISO-2022-JP", "ISO-2022-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-10", "ISO-8859-11", "ISO-8859-13", "ISO-8859-14", "ISO-8859-15", "ISO-8859-16", "Big5", "EUC-JP", "EUC-KR", "GB18030", "IBM420", "IBM424", "KOI8-R", "Shift_JIS", "TIS-620"};
        String[] values = new String[]{Messages.getGuiString("AutoDetect"), Messages.getGuiString("CharacterSet.874"), Messages.getGuiString("CharacterSet.932"), Messages.getGuiString("CharacterSet.936"), Messages.getGuiString("CharacterSet.949"), Messages.getGuiString("CharacterSet.950"), Messages.getGuiString("CharacterSet.1250"), Messages.getGuiString("CharacterSet.1251"), Messages.getGuiString("CharacterSet.1252"), Messages.getGuiString("CharacterSet.1253"), Messages.getGuiString("CharacterSet.1254"), Messages.getGuiString("CharacterSet.1255"), Messages.getGuiString("CharacterSet.1256"), Messages.getGuiString("CharacterSet.1257"), Messages.getGuiString("CharacterSet.1258"), Messages.getGuiString("CharacterSet.2022-CN"), Messages.getGuiString("CharacterSet.2022-JP"), Messages.getGuiString("CharacterSet.2022-KR"), Messages.getGuiString("CharacterSet.8859-1"), Messages.getGuiString("CharacterSet.8859-2"), Messages.getGuiString("CharacterSet.8859-3"), Messages.getGuiString("CharacterSet.8859-4"), Messages.getGuiString("CharacterSet.8859-5"), Messages.getGuiString("CharacterSet.8859-6"), Messages.getGuiString("CharacterSet.8859-7"), Messages.getGuiString("CharacterSet.8859-8"), Messages.getGuiString("CharacterSet.8859-9"), Messages.getGuiString("CharacterSet.8859-10"), Messages.getGuiString("CharacterSet.8859-11"), Messages.getGuiString("CharacterSet.8859-13"), Messages.getGuiString("CharacterSet.8859-14"), Messages.getGuiString("CharacterSet.8859-15"), Messages.getGuiString("CharacterSet.8859-16"), Messages.getGuiString("CharacterSet.Big5"), Messages.getGuiString("CharacterSet.EUC-JP"), Messages.getGuiString("CharacterSet.EUC-KR"), Messages.getGuiString("CharacterSet.GB18030"), Messages.getGuiString("CharacterSet.IBM420"), Messages.getGuiString("CharacterSet.IBM424"), Messages.getGuiString("CharacterSet.KOI8-R"), Messages.getGuiString("CharacterSet.ShiftJIS"), Messages.getGuiString("CharacterSet.TIS-620")};
        KeyedComboBoxModel<String, String> subtitleCodePageModel = new KeyedComboBoxModel<String, String>(keys, values);
        JComboBox subtitleCodePage = new JComboBox(subtitleCodePageModel);
        subtitleCodePage.setPreferredSize(TranscodingTab.getPreferredHeight(subtitleCodePage));
        subtitleCodePage.setToolTipText(Messages.getGuiString("YouFindListSupportedCharacter"));
        subtitleCodePageModel.setSelectedKey(this.configuration.getSubtitlesCodepage());
        subtitleCodePage.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setSubtitlesCodepage((String)subtitleCodePageModel.getSelectedKey());
            }
        });
        subtitleCodePage.setEditable(false);
        builder.add(subtitleCodePage).at(FormLayoutUtil.flip(cc.xyw(3, 12, 7), colSpec, this.orientation));
        JCheckBox fribidi = new JCheckBox(Messages.getGuiString("FribidiMode"), this.configuration.isMencoderSubFribidi());
        fribidi.setContentAreaFilled(false);
        fribidi.addItemListener(e -> this.configuration.setMencoderSubFribidi(e.getStateChange() == 1));
        builder.add(fribidi).at(FormLayoutUtil.flip(cc.xyw(11, 12, 5, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("SpecifyTruetypeFont"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 14), colSpec, this.orientation));
        this.defaultfont = new JTextField(this.configuration.getFont());
        this.defaultfont.setToolTipText(Messages.getGuiString("ToUseFontMustBeRegistered"));
        this.defaultfont.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setFont(TranscodingTab.this.defaultfont.getText());
            }
        });
        builder.add(this.defaultfont).at(FormLayoutUtil.flip(cc.xyw(3, 14, 12), colSpec, this.orientation));
        CustomJButton fontselect = new CustomJButton("...");
        fontselect.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FontFileFilter());
            int returnVal = chooser.showDialog((Component)e.getSource(), Messages.getGuiString("SelectTruetypeFont"));
            if (returnVal == 0) {
                this.defaultfont.setText(chooser.getSelectedFile().getAbsolutePath());
                this.configuration.setFont(chooser.getSelectedFile().getAbsolutePath());
            }
        });
        builder.add(fontselect).at(FormLayoutUtil.flip(cc.xy(15, 14), colSpec, this.orientation));
        builder.addLabel(Messages.getGuiString("StyledSubtitles"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 16), colSpec, this.orientation));
        JPanel flowPanel = new JPanel(new FlowLayout(3));
        flowPanel.setComponentOrientation(this.orientation);
        builder.addLabel(Messages.getGuiString("FontScale"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 16, CellConstraints.RIGHT, CellConstraints.CENTER), colSpec, this.orientation));
        this.assScale = new JTextField(this.configuration.getAssScale());
        this.assScale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TranscodingTab.this.configuration.setAssScale(TranscodingTab.this.assScale.getText());
            }
        });
        flowPanel.add(this.assScale);
        flowPanel.add(new JLabel(Messages.getGuiString("FontOutline")));
        try {
            assOutlineValue = Integer.parseInt(this.configuration.getAssOutline());
        }
        catch (NumberFormatException e2) {
            assOutlineValue = 1;
        }
        SpinnerIntModel assOutlineModel = new SpinnerIntModel(assOutlineValue, 0, 99, 1);
        CustomJSpinner assOutline = new CustomJSpinner(assOutlineModel, true);
        assOutline.addChangeListener(e -> this.configuration.setAssOutline(assOutlineModel.getValue().toString()));
        flowPanel.add(assOutline);
        flowPanel.add(new JLabel(Messages.getGuiString("FontShadow")));
        try {
            assShadowValue = Integer.parseInt(this.configuration.getAssShadow());
        }
        catch (NumberFormatException e3) {
            assShadowValue = 1;
        }
        SpinnerIntModel assShadowModel = new SpinnerIntModel(assShadowValue, 0, 99, 1);
        CustomJSpinner assShadow = new CustomJSpinner(assShadowModel, true);
        assShadow.addChangeListener(e -> this.configuration.setAssShadow(assShadowModel.getValue().toString()));
        flowPanel.add(assShadow);
        flowPanel.add(new JLabel(Messages.getGuiString("MarginPx")));
        try {
            assMarginValue = Integer.parseInt(this.configuration.getAssMargin());
        }
        catch (NumberFormatException e4) {
            assMarginValue = 10;
        }
        SpinnerIntModel assMarginModel = new SpinnerIntModel(assMarginValue, 0, 999, 5);
        CustomJSpinner assMargin = new CustomJSpinner(assMarginModel, true);
        assMargin.addChangeListener(e -> this.configuration.setAssMargin(assMarginModel.getValue().toString()));
        flowPanel.add(assMargin);
        builder.add(flowPanel).at(FormLayoutUtil.flip(cc.xyw(3, 16, 13), colSpec, this.orientation));
        JCheckBox autoloadExternalSubtitles = new JCheckBox(Messages.getGuiString("AutomaticallyLoadSrtSubtitles"), this.configuration.isAutoloadExternalSubtitles());
        autoloadExternalSubtitles.setToolTipText(Messages.getGuiString("IfEnabledExternalSubtitlesPrioritized"));
        autoloadExternalSubtitles.setContentAreaFilled(false);
        autoloadExternalSubtitles.setEnabled(!this.configuration.isForceExternalSubtitles());
        autoloadExternalSubtitles.addItemListener(e -> this.configuration.setAutoloadExternalSubtitles(e.getStateChange() == 1));
        builder.add(autoloadExternalSubtitles).at(FormLayoutUtil.flip(cc.xyw(1, 18, 10), colSpec, this.orientation));
        JButton subColor = new JButton();
        subColor.setText(Messages.getGuiString("Color"));
        subColor.setBackground(this.configuration.getSubsColor());
        subColor.addActionListener(e -> {
            JColorChooser jColorChooser = new JColorChooser(subColor.getBackground());
            Locale locale = PMS.getLocale();
            jColorChooser.setLocale(locale);
            jColorChooser.setComponentOrientation(ComponentOrientation.getOrientation(locale));
            JDialog dialog = JColorChooser.createDialog(this.looksFrame, Messages.getGuiString("ChooseSubtitlesColor"), true, jColorChooser, e1 -> {
                Color newColor = jColorChooser.getColor();
                if (newColor != null) {
                    subColor.setBackground(newColor);
                    this.configuration.setSubsColor(new SubtitleColor(newColor));
                    SubtitleUtils.deleteSubs();
                }
            }, null);
            dialog.setVisible(true);
            dialog.dispose();
        });
        builder.add(subColor).at(FormLayoutUtil.flip(cc.xyw(11, 18, 5), colSpec, this.orientation));
        JCheckBox forceExternalSubtitles = new JCheckBox(Messages.getGuiString("ForceExternalSubtitles"), this.configuration.isForceExternalSubtitles());
        forceExternalSubtitles.setToolTipText(Messages.getGuiString("IfEnabledExternalSubtitlesAlways"));
        forceExternalSubtitles.setContentAreaFilled(false);
        forceExternalSubtitles.addItemListener(e -> {
            this.configuration.setForceExternalSubtitles(e.getStateChange() == 1);
            if (this.configuration.isForceExternalSubtitles()) {
                autoloadExternalSubtitles.setSelected(true);
            }
            autoloadExternalSubtitles.setEnabled(!this.configuration.isForceExternalSubtitles());
        });
        builder.add(SwingUtil.getPreferredSizeComponent(forceExternalSubtitles)).at(FormLayoutUtil.flip(cc.xyw(1, 20, 6), colSpec, this.orientation));
        JCheckBox useEmbeddedSubtitlesStyle = new JCheckBox(Messages.getGuiString("UseEmbeddedStyle"), this.configuration.isUseEmbeddedSubtitlesStyle());
        useEmbeddedSubtitlesStyle.setToolTipText(Messages.getGuiString("IfEnabledWontModifySubtitlesStyling"));
        useEmbeddedSubtitlesStyle.setContentAreaFilled(false);
        useEmbeddedSubtitlesStyle.addItemListener(e -> this.configuration.setUseEmbeddedSubtitlesStyle(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(useEmbeddedSubtitlesStyle)).at(FormLayoutUtil.flip(cc.xyw(1, 22, 4), colSpec, this.orientation));
        Integer[] depth = new Integer[]{-5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5};
        builder.addLabel(Messages.getGuiString("3dSubtitlesDepth"), new Object[0]).at(FormLayoutUtil.flip(cc.xy(1, 24), colSpec, this.orientation));
        JComboBox<Integer> depth3D = new JComboBox<Integer>(depth);
        depth3D.setSelectedItem(this.configuration.getDepth3D());
        depth3D.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.configuration.setDepth3D((Integer)e.getItem());
            }
        });
        builder.add(depth3D).at(FormLayoutUtil.flip(cc.xyw(3, 24, 13), colSpec, this.orientation));
        JPanel panel = builder.getPanel();
        SwingUtil.enableContainer(panel, !this.configuration.isDisableSubtitles());
        this.disableSubs.addItemListener(e -> SwingUtil.enableContainer(panel, e.getStateChange() != 1));
        panel.applyComponentOrientation(this.orientation);
        return panel;
    }

    private static Dimension getPreferredHeight(JComponent component) {
        return new Dimension(20, component.getPreferredSize().height);
    }

    public void enableVideoQualitySettings(boolean automatic) {
        this.vq.setEnabled(!automatic);
        this.x264Quality.setEnabled(!automatic);
    }

    private static enum ToggleButtonState {
        UNKNOWN("button-toggle-on_disabled.svg"),
        ON("button-toggle-on.svg"),
        OFF("button-toggle-off.svg");

        private final String iconName;

        private ToggleButtonState(String name) {
            this.iconName = name;
        }

        public String getIconName() {
            return this.iconName;
        }
    }
}

