/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.status;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.imageio.ImageIO;
import javax.swing.ButtonModel;
import javax.swing.GrayFilter;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.pms.configuration.RendererConfigurations;
import net.pms.renderers.Renderer;
import net.pms.swing.components.SvgMultiResolutionImage;
import net.pms.swing.gui.JavaGui;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererImage
extends JButton {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererImage.class);
    private static final Color BACKGROUND = UIManager.getLookAndFeelDefaults().getColor("Button.background");
    private static final Color HIGHLIGHT = UIManager.getLookAndFeelDefaults().getColor("Button.highlight");
    protected transient Image source;
    protected transient Image grey;
    protected boolean isGrey;

    public RendererImage() {
        this((Renderer)null);
    }

    public RendererImage(Renderer renderer) {
        this.setLayout(null);
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        if (renderer != null) {
            this.set(renderer);
        }
    }

    public final void set(Renderer renderer) {
        this.source = RendererImage.getRendererIcon(renderer.getRendererIcon(), renderer.getRendererIconOverlays());
        int w = 0;
        int h = 0;
        if (this.source != null) {
            w = this.source.getWidth(null);
            h = this.source.getHeight(null);
            if (w > 300 || h != 128) {
                LOGGER.warn("Renderer icon \"{}\" is not sized correctly", (Object)renderer.getRendererIcon());
            }
        }
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(w + insets.left + insets.right, h + insets.top + insets.bottom);
        this.setPreferredSize(dimension);
        this.revalidate();
        this.repaint();
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D graphics2d = (Graphics2D)g;
        if (this.source == null) {
            graphics2d.setColor(this.getBackground());
            graphics2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Rectangle rectangle = graphics2d.getClipBounds();
        graphics2d.setColor(this.getBackground());
        graphics2d.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = this.getInsets();
        int i = insets.left;
        int j = insets.top;
        try {
            graphics2d.drawImage(this.getCurrentSource(), AffineTransform.getTranslateInstance(i, j), null);
        }
        catch (OutOfMemoryError e) {
            LOGGER.debug("Caught exception", e);
        }
    }

    public void enableRollover() {
        this.setRolloverEnabled(true);
        this.getModel().addChangeListener(e -> {
            if (e.getSource() != null) {
                ButtonModel model1 = (ButtonModel)e.getSource();
                this.setBackground(model1.isRollover() ? HIGHLIGHT : BACKGROUND);
            }
        });
    }

    public void setGrey(boolean b) {
        if (this.isGrey != b) {
            this.isGrey = b;
            SwingUtilities.invokeLater(() -> this.repaint());
        }
    }

    public Image getCurrentSource() {
        if (this.isGrey && this.grey == null) {
            this.grey = this.greyed(this.source, 60);
        }
        return this.isGrey ? this.grey : this.source;
    }

    public Image greyed(Image image, int pct) {
        if (image == null) {
            return null;
        }
        GrayFilter filter = new GrayFilter(true, pct);
        if (image instanceof SvgMultiResolutionImage) {
            SvgMultiResolutionImage svgImage = (SvgMultiResolutionImage)image;
            return new SvgMultiResolutionImage(svgImage.getSVGDocument(), filter);
        }
        FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
        return this.createImage(producer);
    }

    private static Image getRendererIcon(String icon) {
        BufferedImage bi = null;
        if (icon != null) {
            if (icon.matches(".*\\S+://.*")) {
                try {
                    bi = ImageIO.read(URI.create(icon).toURL());
                }
                catch (IOException e) {
                    LOGGER.debug("Error reading icon url: " + String.valueOf(e));
                }
                if (bi != null) {
                    return bi;
                }
                LOGGER.debug("Unable to read icon url \"{}\", using \"{}\" instead.", (Object)icon, (Object)"unknown.png");
                icon = "unknown.png";
            }
            try {
                InputStream is = null;
                File f = RendererConfigurations.getRenderersIconFile(icon);
                if (f.isFile() && f.exists()) {
                    is = new FileInputStream(f);
                }
                if (is == null) {
                    is = JavaGui.class.getResourceAsStream("/resources/images/clients/" + icon);
                }
                if (is == null) {
                    is = JavaGui.class.getResourceAsStream("/renderers/" + icon);
                }
                if (is != null && "svg".equalsIgnoreCase(FileUtil.getExtension(icon))) {
                    return new SvgMultiResolutionImage(is);
                }
                if (is == null) {
                    LOGGER.debug("Unable to read icon \"{}\", using \"{}\" instead.", (Object)icon, (Object)"unknown.png");
                    is = JavaGui.class.getResourceAsStream("/resources/images/clients/unknown.png");
                }
                if (is != null) {
                    bi = ImageIO.read(is);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception", e);
            }
        }
        if (bi == null) {
            LOGGER.debug("Failed to load icon: " + icon);
        }
        return bi;
    }

    private static Image getRendererIcon(String icon, String overlays) {
        Image bi = RendererImage.getRendererIcon(icon);
        if (bi != null && StringUtils.isNotBlank(overlays)) {
            Graphics g = bi.getGraphics();
            g.setColor(Color.DARK_GRAY);
            for (String overlay : overlays.split("[|]")) {
                if (!overlay.contains("@")) continue;
                String text = overlay.substring(0, overlay.indexOf("@"));
                String[] values = overlay.substring(overlay.indexOf("@") + 1).split(",");
                if (values.length != 3) continue;
                int x = Integer.parseInt(values[0]);
                int y = Integer.parseInt(values[1]);
                int size = Integer.parseInt(values[2]);
                g.setFont(new Font("Courier", 1, size));
                g.drawString(text, x, y);
            }
            g.dispose();
        }
        return bi;
    }
}

