/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.pms.swing.components.CheckTreeSelectionModel;
import net.pms.swing.components.TristateCheckBox;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = 5762499761493341720L;
    private final CheckTreeSelectionModel selectionModel;
    private final TreeCellRenderer delegate;
    private final TristateCheckBox checkBox = new TristateCheckBox();

    public CheckTreeCellRenderer(TreeCellRenderer delegate, CheckTreeSelectionModel selectionModel) {
        this.delegate = delegate;
        this.selectionModel = selectionModel;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            if (this.selectionModel.isPathSelected(path, true)) {
                this.checkBox.setState(TristateCheckBox.SELECTED);
            } else {
                this.checkBox.setState(this.selectionModel.isPartiallySelected(path) ? null : TristateCheckBox.NOT_SELECTED);
            }
        }
        this.removeAll();
        this.add((Component)this.checkBox, "West");
        this.add(renderer, "Center");
        return this;
    }
}

