/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.media.video.metadata.TvSeasonMetadata;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.container.MediaLibraryFolder;
import net.pms.store.container.MediaLibraryTvSeries;
import org.apache.commons.lang3.StringUtils;

public class MediaLibraryTvSeason
extends MediaLibraryFolder {
    private final Integer tvSeasonId;
    private TvSeriesMetadata tvSeriesMetadata;
    private TvSeasonMetadata tvSeasonMetadata;

    public MediaLibraryTvSeason(Renderer renderer, String i18nName, String tvSeason, String[] sql, int[] expectedOutput) {
        super(renderer, i18nName, sql, expectedOutput, tvSeason);
        this.tvSeasonId = MediaLibraryTvSeason.getInteger(tvSeason);
    }

    @Override
    public String getName() {
        return super.getName().concat(this.getSeasonName(null));
    }

    @Override
    public String getLocalizedDisplayName(String lang) {
        return super.getLocalizedDisplayName(lang).concat(this.getSeasonName(lang));
    }

    private TvSeriesMetadata getTvSeriesMetadata() {
        StoreContainer storeContainer;
        if (this.tvSeriesMetadata == null && this.tvSeasonId != null && (storeContainer = this.getParent()) instanceof MediaLibraryTvSeries) {
            MediaLibraryTvSeries mediaLibraryTvSeries = (MediaLibraryTvSeries)storeContainer;
            this.tvSeriesMetadata = mediaLibraryTvSeries.getTvSeriesMetadata();
        }
        return this.tvSeriesMetadata;
    }

    private synchronized String getSeasonName(String lang) {
        if (this.getTvSeasonMetadata() != null && !this.tvSeasonMetadata.getName(null).equalsIgnoreCase("Season " + this.tvSeasonMetadata.getSeasonNumber()) && !StringUtils.isBlank(this.tvSeasonMetadata.getName(lang))) {
            return ": " + this.tvSeasonMetadata.getName(lang);
        }
        return lang == null ? "" : this.getSeasonName(null);
    }

    public TvSeasonMetadata getTvSeasonMetadata() {
        if (this.tvSeasonMetadata == null && this.getTvSeriesMetadata() != null && this.tvSeasonId != null) {
            this.tvSeasonMetadata = this.tvSeriesMetadata.getSeasonMetadata(this.tvSeasonId);
        }
        return this.tvSeasonMetadata;
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

