/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.pms.encoders.TranscodingSettings;
import net.pms.media.MediaInfo;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.item.RealFile;
import net.pms.util.TimeRange;
import org.apache.commons.lang3.StringUtils;
import org.digitalmediaserver.cuelib.CueParser;
import org.digitalmediaserver.cuelib.CueSheet;
import org.digitalmediaserver.cuelib.FileData;
import org.digitalmediaserver.cuelib.Position;
import org.digitalmediaserver.cuelib.TrackData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CueFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CueFolder.class);
    private final File playlistfile;

    public File getPlaylistfile() {
        return this.playlistfile;
    }

    public CueFolder(Renderer renderer, File f) {
        super(renderer, f.getName(), null);
        this.playlistfile = f;
        this.setLastModified(this.playlistfile.lastModified());
    }

    @Override
    protected void resolveOnce() {
        if (this.playlistfile.length() < 10000000L) {
            List<FileData> files;
            CueSheet sheet;
            try {
                sheet = CueParser.parse(this.playlistfile, null);
            }
            catch (IOException e) {
                LOGGER.info("Error in parsing cue: " + e.getMessage());
                return;
            }
            if (sheet != null && !(files = sheet.getFileData()).isEmpty()) {
                StoreResource lastTrack;
                FileData f = files.get(0);
                List<TrackData> tracks = f.getTrackData();
                TranscodingSettings defaultTranscodingSettings = null;
                MediaInfo originalMedia = null;
                ArrayList<RealFile> addedResources = new ArrayList<RealFile>();
                for (int i = 0; i < tracks.size(); ++i) {
                    TrackData track = tracks.get(i);
                    if (i > 0) {
                        double end = CueFolder.getTime(track.getIndices().get(0).getPosition());
                        if (addedResources.isEmpty()) {
                            return;
                        }
                        StoreResource prec = (StoreResource)addedResources.get(i - 1);
                        int count = 0;
                        while (prec.isFolder() && i + count < addedResources.size()) {
                            prec = (StoreResource)addedResources.get(i + count);
                            ++count;
                        }
                        if (prec instanceof StoreItem) {
                            StoreItem item = (StoreItem)prec;
                            item.getSplitRange().setEnd(end);
                            prec.getMediaInfo().setDuration(item.getSplitRange().getDuration());
                            LOGGER.debug("Track #" + i + " split range: " + item.getSplitRange().getStartOrZero() + " - " + item.getSplitRange().getDuration());
                        }
                    }
                    Position start = track.getIndices().get(0).getPosition();
                    RealFile realFile = new RealFile(this.renderer, new File(this.playlistfile.getParentFile(), f.getFile()));
                    this.addChild(realFile);
                    addedResources.add(realFile);
                    if (i > 0 && realFile.getMediaInfo() == null) {
                        realFile.setMediaInfo(new MediaInfo());
                        realFile.getMediaInfo().setMediaParser("CueLib");
                    }
                    realFile.syncResolve();
                    if (i == 0) {
                        originalMedia = realFile.getMediaInfo();
                    }
                    if (originalMedia == null) {
                        LOGGER.trace("Couldn't resolve media \"{}\" for cue file \"{}\" - aborting", (Object)realFile.getName(), (Object)this.playlistfile.getAbsolutePath());
                        return;
                    }
                    realFile.getSplitRange().setStart(CueFolder.getTime(start));
                    realFile.setSplitTrack(i + 1);
                    if (!realFile.isTranscoded()) {
                        if (defaultTranscodingSettings == null) {
                            defaultTranscodingSettings = TranscodingSettings.getBestTranscodingSettings(realFile);
                        }
                        realFile.setTranscodingSettings(defaultTranscodingSettings);
                    }
                    if (realFile.getMediaInfo() == null) continue;
                    try {
                        realFile.setMediaInfo(originalMedia.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        LOGGER.info("Error in cloning media info: " + e.getMessage());
                    }
                    if (realFile.getMediaInfo() == null || !realFile.getMediaInfo().hasAudioMetadata()) continue;
                    if (realFile.getFormat().isAudio()) {
                        realFile.getMediaInfo().getAudioMetadata().setSongname(track.getTitle());
                    } else {
                        realFile.getMediaInfo().getDefaultAudioTrack().setTitle("Chapter #" + (i + 1));
                    }
                    realFile.getMediaInfo().getAudioMetadata().setTrack(i + 1);
                    realFile.getMediaInfo().setSize(-1L);
                    if (StringUtils.isNotBlank(sheet.getTitle())) {
                        realFile.getMediaInfo().getAudioMetadata().setAlbum(sheet.getTitle());
                    }
                    if (StringUtils.isNotBlank(sheet.getPerformer())) {
                        realFile.getMediaInfo().getAudioMetadata().setArtist(sheet.getPerformer());
                    }
                    if (!StringUtils.isNotBlank(track.getPerformer())) continue;
                    realFile.getMediaInfo().getAudioMetadata().setArtist(track.getPerformer());
                }
                if (!tracks.isEmpty() && !addedResources.isEmpty() && (lastTrack = (StoreResource)addedResources.get(addedResources.size() - 1)) instanceof StoreItem) {
                    StoreItem item = (StoreItem)lastTrack;
                    TimeRange lastTrackSplitRange = item.getSplitRange();
                    MediaInfo lastTrackMedia = item.getMediaInfo();
                    if (lastTrackSplitRange != null && lastTrackMedia != null) {
                        lastTrackSplitRange.setEnd(lastTrackMedia.getDurationInSeconds());
                        lastTrackMedia.setDuration(lastTrackSplitRange.getDuration());
                        LOGGER.debug("Track #" + this.childrenCount() + " split range: " + lastTrackSplitRange.getStartOrZero() + " - " + lastTrackSplitRange.getDuration());
                    }
                }
            }
        }
    }

    private static double getTime(Position p) {
        return (double)(p.getMinutes() * 60 + p.getSeconds()) + (double)p.getFrames() / 100.0;
    }
}

