/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.util.TimeRange;

public class ChapterFileTranscodeVirtualFolder
extends LocalizedStoreContainer {
    private final int interval;

    public ChapterFileTranscodeVirtualFolder(Renderer renderer, String name, StoreResource child, int interval) {
        super(renderer, "ChapterX", null, name);
        this.interval = interval;
        this.addChildInternal(child);
        this.setSortable(false);
    }

    @Override
    protected void resolveOnce() {
        StoreResource child;
        if (this.getChildren().size() == 1 && (child = this.getChildren().get(0)) instanceof StoreItem) {
            StoreItem item = (StoreItem)child;
            item.syncResolve();
            int nbMinutes = (int)(item.getMediaInfo().getDurationInSeconds() / 60.0);
            int nbIntervals = nbMinutes / this.interval;
            for (int i = 1; i <= nbIntervals; ++i) {
                StoreItem newChildNoSub = item.clone();
                newChildNoSub.setTranscodingSettings(item.getTranscodingSettings());
                newChildNoSub.setMediaInfo(item.getMediaInfo());
                newChildNoSub.setNoName(true);
                newChildNoSub.setMediaAudio(item.getMediaAudio());
                newChildNoSub.setMediaSubtitle(item.getMediaSubtitle());
                newChildNoSub.setSplitRange(new TimeRange(60.0 * (double)i * (double)this.interval, newChildNoSub.getMediaInfo().getDurationInSeconds()));
                this.addChildInternal(newChildNoSub);
            }
        }
    }
}

