/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.iam.AccountService;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererUser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererUser.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final Map<String, Integer> USERS = new HashMap<String, Integer>();
    private static final Gson GSON = new Gson();

    private RendererUser() {
    }

    public static synchronized void reset() {
        USERS.clear();
        String rendererUser = CONFIGURATION.getRenderersUser().replace('|', '\"');
        try {
            Map users = (Map)GSON.fromJson(rendererUser, USERS.getClass());
            for (Map.Entry entry : users.entrySet()) {
                USERS.put((String)entry.getKey(), ((Number)entry.getValue()).intValue());
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Renderer User: error reading configuration value {}", (Object)rendererUser, (Object)e);
        }
    }

    public static synchronized void setRendererUser(String uuid, int userId) {
        if (StringUtils.isBlank(uuid)) {
            return;
        }
        String uuidLowerCase = uuid.toLowerCase();
        if (userId == RendererUser.getUserId(uuidLowerCase)) {
            LOGGER.trace("Renderer User: No change made, {} is already linked to userId {}", (Object)uuidLowerCase, (Object)userId);
            return;
        }
        if (userId > -1) {
            if (AccountService.getUserById(userId) == null) {
                LOGGER.error("Renderer User: trying to link renderer {} to inexistant userId {}", (Object)uuidLowerCase, (Object)userId);
            } else {
                LOGGER.trace("Renderer User: linking renderer {} to userId {}", (Object)uuidLowerCase, (Object)userId);
                USERS.put(uuidLowerCase, userId);
            }
        } else {
            LOGGER.trace("Renderer User: removing renderer {} linked userId", (Object)uuidLowerCase);
            USERS.remove(uuidLowerCase);
        }
        Renderer renderer = ConnectedRenderers.getRendererByUUID(uuidLowerCase);
        if (renderer != null) {
            renderer.setUserId(userId);
        }
        CONFIGURATION.setRenderersUser(GSON.toJson(USERS).replace('\"', '|'));
    }

    public static synchronized int getUserId(String uuid) {
        if (StringUtils.isBlank(uuid)) {
            return -1;
        }
        String uuidLowerCase = uuid.toLowerCase();
        if (USERS.containsKey(uuidLowerCase)) {
            return USERS.get(uuidLowerCase);
        }
        return -1;
    }
}

