/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.RendererDeviceConfiguration;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.dlna.protocolinfo.DeviceProtocolInfo;
import net.pms.dlna.protocolinfo.PanasonicDmpProfiles;
import net.pms.gui.IRendererGuiListener;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.network.SpeedStats;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.JUPnPDeviceHelper;
import net.pms.renderers.RendererFilter;
import net.pms.renderers.RendererUser;
import net.pms.renderers.devices.players.BasicPlayer;
import net.pms.renderers.devices.players.PlaybackTimer;
import net.pms.renderers.devices.players.PlayerState;
import net.pms.renderers.devices.players.UPNPPlayer;
import net.pms.store.MediaStore;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.util.UMSUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.model.action.ActionArgumentValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer
extends RendererDeviceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Renderer.class);
    public static final String NOTRANSCODE = "_NOTRANSCODE_";
    private static final String TRANSPORT_STATE = "TransportState";
    private static final String STOPPED = "STOPPED";
    private static final String PLAYING = "PLAYING";
    private static final String RECORDING = "RECORDING";
    private static final String TRANSITIONING = "TRANSITIONING";
    public static final String INSTANCE_ID = "InstanceID";
    public static final int UPNP_BLOCK = -2;
    private static final int UPNP_POSTPONE = -1;
    private static final int UPNP_NONE = 0;
    public static final int UPNP_ALLOW = 1;
    public static final int PLAYCONTROL = 1;
    public static final int VOLUMECONTROL = 2;
    private final ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private final LinkedHashSet<IRendererGuiListener> guiListeners = new LinkedHashSet();
    public final Map<String, String> data = new HashMap<String, String>();
    private final LinkedHashSet<ActionListener> listeners = new LinkedHashSet();
    public final DeviceProtocolInfo deviceProtocolInfo = new DeviceProtocolInfo();
    private int controls;
    protected ActionEvent event;
    protected Map<String, String> details;
    private Thread monitorThread;
    private volatile boolean active;
    private volatile boolean allowed;
    private volatile int userId;
    private volatile boolean renew;
    public volatile PanasonicDmpProfiles panasonicDmpProfiles;
    public boolean isGetPositionInfoImplemented = true;
    public int countGetPositionRequests = 0;
    protected BasicPlayer player;
    private StoreItem playingRes;
    private long buffer;
    private int maximumBitrateTotal = 0;
    private String automaticVideoQuality = "Automatic (Wireless)";
    private volatile MediaStore mediaStore;
    private List<String> sharedPath;
    protected Account account;
    private volatile int upnpMode = 0;

    public Renderer(String uuid) throws ConfigurationException, InterruptedException {
        this(null, null, uuid);
    }

    public Renderer(RendererConfiguration ref) throws ConfigurationException, InterruptedException {
        this(ref, null, null);
    }

    public Renderer(RendererConfiguration ref, InetAddress ia) throws ConfigurationException, InterruptedException {
        this(ref, ia, null);
    }

    public Renderer(RendererConfiguration ref, InetAddress ia, String uuid) throws ConfigurationException, InterruptedException {
        super(ref, ia, uuid);
        String id;
        if (this.isUpnpAllowed() && uuid == null && StringUtils.isNotBlank(id = this.getDeviceId()) && !id.contains(",")) {
            uuid = id;
        }
        if (!this.isAuthenticated()) {
            if (uuid == null && this.uuid != null) {
                uuid = this.uuid;
            }
            this.allowed = RendererFilter.isAllowed(uuid);
            this.userId = RendererUser.getUserId(uuid);
            this.account = AccountService.getAccountByUserId(this.userId);
        }
        this.controls = 0;
        this.active = false;
        this.details = null;
        this.event = new ActionEvent(this, 0, null);
        this.monitorThread = null;
        this.renew = false;
        this.data.put(TRANSPORT_STATE, STOPPED);
    }

    @Override
    public String getRendererName() {
        if (this.details != null && this.details.containsKey("friendlyName")) {
            return this.details.get("friendlyName");
        }
        if (this.isUpnp()) {
            return JUPnPDeviceHelper.getFriendlyName(this.uuid);
        }
        return this.getConfName();
    }

    public String getId() {
        return this.uuid != null ? this.uuid : this.getAddress().toString().substring(1);
    }

    public boolean isAuthenticated() {
        return false;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setUserId(int value) {
        if (this.userId != value) {
            this.userId = value;
            this.setAccount(AccountService.getAccountByUserId(this.userId));
            this.refreshUserIdGui(value);
        }
    }

    public int getUserId() {
        return this.userId;
    }

    public void setAccount(Account account) {
        this.account = account;
        this.resetMediaStore();
    }

    public int getAccountGroupId() {
        return this.account != null && this.account.getGroup() != null && this.account.getGroup().getId() != Integer.MAX_VALUE ? this.account.getGroup().getId() : 0;
    }

    public int getAccountUserId() {
        return this.account != null && this.account.getUser() != null && this.account.getUser().getId() != Integer.MAX_VALUE ? this.account.getUser().getId() : 0;
    }

    public boolean hasShareAccess(File value) {
        return Renderer.hasSameBasePath(this.getSharedFolders(), value.getAbsolutePath());
    }

    private synchronized void clearSharedFolders() {
        this.sharedPath = null;
    }

    private synchronized List<String> getSharedFolders() {
        if (this.sharedPath == null) {
            this.sharedPath = new ArrayList<String>();
            List<File> files = SharedContentConfiguration.getSharedFolders(this.getAccountGroupId());
            for (File file : files) {
                this.sharedPath.add(file.getAbsolutePath());
            }
        }
        return this.sharedPath;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetRenderer();
    }

    private void resetRenderer() {
        if (!this.isAuthenticated()) {
            this.allowed = RendererFilter.isAllowed(this.uuid);
            if (this.userId != RendererUser.getUserId(this.uuid)) {
                this.setUserId(RendererUser.getUserId(this.uuid));
            }
        }
        this.resetMediaStore();
        this.updateRendererGui();
        for (Renderer renderer : ConnectedRenderers.getInheritors(this)) {
            renderer.updateRendererGui();
        }
    }

    @Override
    protected void uuidChanged() {
        this.resetRenderer();
    }

    public synchronized MediaStore getMediaStore() {
        if (this.mediaStore == null) {
            this.mediaStore = new MediaStore(this);
            this.mediaStore.discoverChildren();
        }
        return this.mediaStore;
    }

    public synchronized void clearMediaStore() {
        this.clearSharedFolders();
        if (this.mediaStore != null) {
            this.mediaStore.clearChildren();
            this.mediaStore.setDiscovered(false);
            this.mediaStore.clearWeakResources();
        }
    }

    public synchronized void resetMediaStore() {
        this.clearSharedFolders();
        if (this.mediaStore != null) {
            this.mediaStore.reset();
        }
    }

    public synchronized void addFolderLimit(StoreResource res) {
        if (this.mediaStore != null) {
            this.mediaStore.setFolderLim(res);
        }
    }

    public boolean associateIP(InetAddress sa) {
        if (JUPnPDeviceHelper.isNonRenderer(sa)) {
            return false;
        }
        ConnectedRenderers.addRendererAssociation(sa, this);
        this.resetUpnpMode();
        if ((this.umsConfiguration.isAutomaticMaximumBitrate() || this.umsConfiguration.isSpeedDbg()) && !sa.isLoopbackAddress() && !sa.isAnyLocalAddress()) {
            SpeedStats.getSpeedInMBits(sa, this.getRendererName());
        }
        return true;
    }

    public Map<String, String> getUpnpDetails() {
        return JUPnPDeviceHelper.getDeviceDetails(this.uuid);
    }

    public boolean isUpnp() {
        return JUPnPDeviceHelper.isUpnpDevice(this.uuid);
    }

    public void setDetails(Map<String, String> value) {
        this.details = value;
    }

    public Map<String, String> getDetails() {
        if (this.details == null) {
            if (this.isUpnp()) {
                this.details = this.getUpnpDetails();
            } else {
                this.details = new LinkedHashMap<String, String>();
                this.details.put(Messages.getString("Name"), this.getRendererName());
                if (this.getAddress() != null) {
                    this.details.put(Messages.getString("Address"), this.getAddress().getHostAddress());
                }
            }
        }
        return this.details;
    }

    @Override
    public String getRendererIcon() {
        String icon = super.getRendererIcon();
        String deviceIcon = null;
        if (icon.equals("unknown.png") && this.uuid != null) {
            deviceIcon = JUPnPDeviceHelper.getDeviceIcon(this.uuid, 140);
        }
        return deviceIcon == null ? icon : deviceIcon;
    }

    public Map<String, String> getUPNPData() {
        return this.data;
    }

    public List<String> getUpnpServices() {
        return this.isUpnp() ? JUPnPDeviceHelper.getServiceNames(this.uuid) : null;
    }

    public boolean isOffline() {
        return !this.isActive();
    }

    public boolean isUpnpConnected() {
        return this.uuid != null && JUPnPDeviceHelper.isActive(this.uuid);
    }

    public boolean hasAssociatedAddress() {
        return ConnectedRenderers.hasInetAddressForRenderer(this);
    }

    public InetAddress getAddress() {
        InetAddress address;
        if (this.uuid != null && (address = JUPnPDeviceHelper.getInetAddress(this.uuid)) != null) {
            return address;
        }
        return ConnectedRenderers.getRendererInetAddress(this);
    }

    public boolean isUpnpControllable() {
        return JUPnPDeviceHelper.isUpnpControllable(this.uuid);
    }

    public BasicPlayer getPlayer() {
        if (this.player == null) {
            this.player = this.isUpnpControllable() ? new UPNPPlayer(this) : new PlaybackTimer(this);
        } else if (this.player instanceof PlaybackTimer && this.isUpnpControllable()) {
            this.player = new UPNPPlayer(this);
        }
        return this.player;
    }

    public void setPlayer(BasicPlayer player) {
        this.player = player;
    }

    public StoreItem getPlayingRes() {
        return this.playingRes;
    }

    public void setPlayingRes(StoreItem resource) {
        this.playingRes = resource;
        if (resource != null) {
            this.getPlayer().getState().setName(resource.getDisplayName());
            this.getPlayer().start();
        } else {
            this.getPlayer().reset();
        }
    }

    public void setBuffer(long mb) {
        this.buffer = mb < 0L ? 0L : mb;
        this.getPlayer().setBuffer(mb);
    }

    public long getBuffer() {
        return this.buffer;
    }

    public void addGuiListener(IRendererGuiListener gui) {
        this.listenersLock.readLock().lock();
        try {
            this.guiListeners.add(gui);
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    public void removeGuiListener(IRendererGuiListener gui) {
        this.listenersLock.readLock().lock();
        try {
            this.guiListeners.remove(gui);
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    public void updateRendererGui() {
        LOGGER.debug("Updating status button for {}", (Object)this.getRendererName());
        this.listenersLock.writeLock().lock();
        try {
            for (IRendererGuiListener gui : this.guiListeners) {
                gui.updateRenderer(this);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshActiveGui(boolean b) {
        this.listenersLock.writeLock().lock();
        try {
            for (IRendererGuiListener gui : this.guiListeners) {
                gui.setActive(b);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllowedGui(boolean b) {
        this.listenersLock.writeLock().lock();
        try {
            for (IRendererGuiListener gui : this.guiListeners) {
                gui.setAllowed(b);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUserIdGui(int userId) {
        this.listenersLock.writeLock().lock();
        try {
            for (IRendererGuiListener gui : this.guiListeners) {
                gui.setUserId(userId);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPlayerStateGui(PlayerState state) {
        this.listenersLock.writeLock().lock();
        try {
            for (IRendererGuiListener gui : this.guiListeners) {
                gui.refreshPlayerState(state);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    public void deleteGuis() {
        this.listenersLock.writeLock().lock();
        try {
            for (IRendererGuiListener gui : this.guiListeners) {
                gui.delete();
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    public int getMaxBandwidth() {
        if (this.maximumBitrateTotal > 0) {
            return this.maximumBitrateTotal;
        }
        int[] defaultMaxBitrates = Renderer.getVideoBitrateConfig(PMS.getConfiguration().getMaximumBitrate());
        int[] rendererMaxBitrates = new int[2];
        int maxVideoBitrate = this.getMaxVideoBitrate();
        if (maxVideoBitrate > 0) {
            rendererMaxBitrates = Renderer.getVideoBitrateConfig(Integer.toString(maxVideoBitrate));
        }
        if (rendererMaxBitrates[0] > 0 && rendererMaxBitrates[0] < defaultMaxBitrates[0]) {
            LOGGER.trace("Using video bitrate limit from {} configuration ({} Mb/s) because it is lower than the general configuration bitrate limit ({} Mb/s)", this.getRendererName(), rendererMaxBitrates[0], defaultMaxBitrates[0]);
            defaultMaxBitrates = rendererMaxBitrates;
        }
        if (this.isHalveBitrate()) {
            defaultMaxBitrates[0] = defaultMaxBitrates[0] / 2;
        }
        this.maximumBitrateTotal = defaultMaxBitrates[0] * 1000000;
        return this.maximumBitrateTotal;
    }

    public boolean nox264() {
        return false;
    }

    public void alert() {
        String transportState = this.data.get(TRANSPORT_STATE);
        if (JUPnPDeviceHelper.isUpnpDevice(this.uuid) && (this.monitorThread == null || !this.monitorThread.isAlive()) && (PLAYING.equals(transportState) || RECORDING.equals(transportState) || TRANSITIONING.equals(transportState))) {
            this.monitor();
        }
        for (ActionListener l : this.listeners) {
            l.actionPerformed(this.event);
        }
    }

    public Map<String, String> connect(ActionListener listener) {
        this.listeners.add(listener);
        return this.data;
    }

    public void disconnect(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void monitor() {
        this.monitorThread = new Thread(() -> {
            String transportState = this.data.get(TRANSPORT_STATE);
            while (this.active && (PLAYING.equals(transportState) || RECORDING.equals(transportState) || TRANSITIONING.equals(transportState))) {
                UMSUtils.sleep(1000);
                if (!this.isGetPositionInfoImplemented) continue;
                for (ActionArgumentValue o : JUPnPDeviceHelper.getPositionInfo(this)) {
                    this.data.put(o.getArgument().getName(), o.toString());
                }
                this.alert();
            }
            if (!this.active) {
                this.data.put(TRANSPORT_STATE, STOPPED);
                this.alert();
            }
        }, "UPNP-" + this.getRendererName());
        this.monitorThread.start();
    }

    public int getControls() {
        return this.controls;
    }

    public final void setControls(int value) {
        this.controls = value;
    }

    public boolean hasPlayControls() {
        return (this.getControls() & 1) != 0;
    }

    public boolean hasVolumeControls() {
        return (this.getControls() & 2) != 0;
    }

    public boolean isControllable() {
        return this.getControls() != 0;
    }

    public boolean isControllable(int type) {
        return (this.getControls() & type) != 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
        this.refreshActiveGui(b);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean b) {
        this.allowed = b;
        this.refreshAllowedGui(b);
    }

    public void setRenew(boolean b) {
        this.renew = b;
    }

    public boolean needsRenewal() {
        return !this.active || this.renew;
    }

    @Override
    public int getMaxVideoBitrate() {
        if (PMS.getConfiguration().isAutomaticMaximumBitrate() && !PMS.isRunningTests()) {
            try {
                int calculatedSpeed = this.calculatedSpeed();
                if (calculatedSpeed >= 70) {
                    this.setAutomaticVideoQuality("Automatic (Wired)");
                } else {
                    this.setAutomaticVideoQuality("Automatic (Wireless)");
                }
                return calculatedSpeed;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return 0;
            }
            catch (ExecutionException e) {
                LOGGER.debug("Automatic maximum bitrate calculation failed with: {}", (Object)e.getCause().getMessage());
                LOGGER.trace("", e.getCause());
            }
        }
        return super.getMaxVideoBitrate();
    }

    public int calculatedSpeed() throws InterruptedException, ExecutionException {
        Future<Integer> speed;
        int max = super.getMaxVideoBitrate();
        InetAddress addr = ConnectedRenderers.getRendererInetAddress(this);
        if (addr != null && (speed = SpeedStats.getSpeedInMBitsStored(addr)) != null) {
            if (max == 0) {
                return speed.get();
            }
            if (speed.get() > max && max > 0) {
                return max;
            }
            return speed.get();
        }
        return max;
    }

    private void setAutomaticVideoQuality(String value) {
        this.automaticVideoQuality = value;
    }

    public String getAutomaticVideoQuality() {
        return this.automaticVideoQuality;
    }

    public String getDefaultFilename() {
        String id = this.getId();
        return (this.getSimpleName() + "-" + (id.startsWith("uuid:") ? id.substring(5, 11) : id)).replace(" ", "") + ".conf";
    }

    public File getUsableFile() {
        File file = this.getFile();
        if (file == null || file.equals(NOFILE)) {
            String name = this.getSimpleName();
            file = name.equals(RendererConfigurations.getDefaultConf().getSimpleName()) ? new File(RendererConfigurations.getWritableRenderersDir(), this.getDefaultFilename()) : new File(RendererConfigurations.getWritableRenderersDir(), name.replace(" ", "") + ".conf");
        }
        return file;
    }

    public int getUpnpMode() {
        if (this.upnpMode == 0) {
            this.upnpMode = Renderer.getUpnpMode(this.getUpnpAllow());
        }
        return this.upnpMode;
    }

    public String getUpnpModeString() {
        return Renderer.getUpnpModeString(this.upnpMode);
    }

    public void resetUpnpMode() {
        this.setUpnpMode(Renderer.getUpnpMode(this.getUpnpAllow()));
    }

    public void setUpnpMode(int mode) {
        if (this.upnpMode != mode) {
            this.upnpMode = mode;
            if (this.upnpMode == 1) {
                String id;
                String string = id = this.uuid != null ? this.uuid : ConnectedRenderers.getUuidOf(this.getAddress());
                if (id != null) {
                    this.setUpnpAllow("true");
                    JUPnPDeviceHelper.activate(id);
                }
            }
        }
    }

    public boolean isUpnpPostponed() {
        return this.getUpnpMode() == -1;
    }

    public final boolean isUpnpAllowed() {
        return this.getUpnpMode() > 0;
    }

    public boolean verify() {
        return this.getUpnpMode() == -2 || this.getAddress() != null;
    }

    public static int getUpnpMode(String mode) {
        if (mode != null) {
            return switch (mode.trim().toLowerCase()) {
                case "false" -> -2;
                case "postpone" -> -1;
                default -> 1;
            };
        }
        return 1;
    }

    public static String getUpnpModeString(int mode) {
        return switch (mode) {
            case -2 -> "blocked";
            case -1 -> "postponed";
            case 0 -> "unknown";
            default -> "allowed";
        };
    }

    private static boolean hasSameBasePath(List<String> paths, String filename) {
        for (String path : paths) {
            if (!filename.startsWith(path)) continue;
            return true;
        }
        return false;
    }
}

