/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import net.pms.configuration.RendererConfigurations;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.iam.AuthService;
import net.pms.iam.User;
import net.pms.network.NetworkDeviceFilter;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.network.webguiserver.RendererItem;
import net.pms.renderers.RendererFilter;
import net.pms.renderers.RendererUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="RenderersApiServlet", urlPatterns={"/v1/api/renderers"}, displayName="Renderers Api Servlet")
public class RenderersApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderersApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block10: {
            try {
                String path = req.getPathInfo();
                if (path.equals("/")) {
                    JsonObject jsonResponse = new JsonObject();
                    jsonResponse.add("renderers", RendererItem.getRenderersAsJsonArray());
                    jsonResponse.addProperty("renderersBlockedByDefault", RendererFilter.getBlockedByDefault());
                    jsonResponse.addProperty("networkDevicesBlockedByDefault", NetworkDeviceFilter.getBlockedByDefault());
                    JsonArray jUsers = new JsonArray();
                    for (User user : AccountService.getAllUsers()) {
                        JsonObject jUser = new JsonObject();
                        jUser.addProperty("value", user.getId());
                        jUser.addProperty("label", user.getDisplayName());
                        jUsers.add(jUser);
                    }
                    jsonResponse.add("users", jUsers);
                    jsonResponse.addProperty("currentTime", System.currentTimeMillis());
                    RenderersApiServlet.respond(req, resp, jsonResponse.toString(), 200, "application/json");
                    break block10;
                }
                if (path.equals("/devices")) {
                    JsonObject jsonResponse = new JsonObject();
                    jsonResponse.addProperty("isLocalhost", RenderersApiServlet.isLocalhost(req));
                    jsonResponse.add("networkDevices", NetworkDeviceFilter.getNetworkDevicesAsJsonArray());
                    jsonResponse.addProperty("networkDevicesBlockedByDefault", NetworkDeviceFilter.getBlockedByDefault());
                    jsonResponse.addProperty("currentTime", System.currentTimeMillis());
                    RenderersApiServlet.respond(req, resp, jsonResponse.toString(), 200, "application/json");
                    break block10;
                }
                if (path.startsWith("/icon/")) {
                    RendererItem renderer = null;
                    String[] splitted = path.split("/");
                    if (splitted.length == 4) {
                        String rId = splitted[2];
                        try {
                            renderer = RendererItem.getRenderer(Integer.parseInt(rId));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (renderer == null || !RenderersApiServlet.getRendererIcon(req, resp, renderer.getIcon())) {
                        RenderersApiServlet.respondNotFound(req, resp);
                    }
                    break block10;
                }
                LOGGER.trace("RenderersApiServlet request not available : {}", (Object)path);
                RenderersApiServlet.respondNotFound(req, resp);
            }
            catch (RuntimeException e) {
                LOGGER.error("RuntimeException in RenderersApiServlet: {}", (Object)e.getMessage());
                RenderersApiServlet.respondInternalServerError(req, resp);
            }
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            Account account = AuthService.getAccountLoggedIn(req);
            if (account == null) {
                RenderersApiServlet.respondForbidden(req, resp);
                return;
            }
            switch (path = req.getPathInfo()) {
                case "/infos": {
                    JsonObject post = RenderersApiServlet.getJsonObjectFromBody(req);
                    JsonObject rendererInfos = RenderersApiServlet.getRendererInfos(post);
                    if (rendererInfos == null) {
                        RenderersApiServlet.respondBadRequest(req, resp);
                        return;
                    }
                    RenderersApiServlet.respond(req, resp, rendererInfos.toString(), 200, "application/json");
                    break;
                }
                case "/control": {
                    if (!account.havePermission(4096)) {
                        RenderersApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject post = RenderersApiServlet.getJsonObjectFromBody(req);
                    if (RendererItem.remoteControlRenderer(post)) {
                        RenderersApiServlet.respond(req, resp, "{}", 200, "application/json");
                        break;
                    }
                    RenderersApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/browse": {
                    if (!account.havePermission(4096)) {
                        RenderersApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject post = RenderersApiServlet.getJsonObjectFromBody(req);
                    JsonObject datas = RendererItem.getRemoteControlBrowse(post);
                    if (datas != null) {
                        RenderersApiServlet.respond(req, resp, datas.toString(), 200, "application/json");
                        break;
                    }
                    RenderersApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/renderers": {
                    if (!account.havePermission(2048)) {
                        RenderersApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject data = RenderersApiServlet.getJsonObjectFromBody(req);
                    if (data != null && data.has("rule")) {
                        String uuid = data.get("rule").getAsString();
                        if (data.has("isAllowed")) {
                            boolean isAllowed = data.get("isAllowed").getAsBoolean();
                            if ("DEFAULT".equals(uuid)) {
                                RendererFilter.setBlockedByDefault(!isAllowed);
                            } else {
                                RendererFilter.setAllowed(uuid, isAllowed);
                            }
                        }
                        if (data.has("userId")) {
                            int userId = data.get("userId").getAsInt();
                            RendererUser.setRendererUser(uuid, userId);
                        }
                    }
                    RenderersApiServlet.respond(req, resp, "{}", 200, "application/json");
                    break;
                }
                case "/devices": {
                    if (!account.havePermission(2048)) {
                        RenderersApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject data = RenderersApiServlet.getJsonObjectFromBody(req);
                    if (data != null && data.has("rule")) {
                        String rule = data.get("rule").getAsString();
                        Boolean isAllowed = data.get("isAllowed").getAsBoolean();
                        if ("DEFAULT".equals(rule)) {
                            NetworkDeviceFilter.setBlockedByDefault(isAllowed == false);
                        } else {
                            NetworkDeviceFilter.setAllowed(rule, isAllowed);
                        }
                        RenderersApiServlet.respond(req, resp, "{}", 200, "application/json");
                        break;
                    }
                    RenderersApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/reset": {
                    if (!account.havePermission(2048)) {
                        RenderersApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    CONFIGURATION.setNetworkDevicesFilter("");
                    CONFIGURATION.setNetworkDevicesBlockedByDefault(false);
                    NetworkDeviceFilter.reset();
                    CONFIGURATION.setRenderersFilter("");
                    CONFIGURATION.setRenderersBlockedByDefault(false);
                    RendererFilter.reset();
                    RenderersApiServlet.respond(req, resp, "{}", 200, "application/json");
                    break;
                }
                default: {
                    LOGGER.trace("RenderersApiServlet request not available : {}", (Object)path);
                    RenderersApiServlet.respondNotFound(req, resp);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in RenderersApiServlet: {}", (Object)e.getMessage());
            RenderersApiServlet.respondInternalServerError(req, resp);
        }
    }

    private static boolean getRendererIcon(HttpServletRequest req, HttpServletResponse resp, String icon) {
        if (icon != null) {
            try {
                File f;
                InputStream is = null;
                String mime = RenderersApiServlet.getMimeType(icon);
                if (icon.matches(".*\\S+://.*")) {
                    try {
                        URL url = URI.create(icon).toURL();
                        is = url.openStream();
                        mime = RenderersApiServlet.getMimeType(url.getPath());
                    }
                    catch (IOException e) {
                        LOGGER.debug("Unable to read icon url \"{}\", using \"{}\" instead.", (Object)icon, (Object)"unknown.png");
                        icon = "unknown.png";
                    }
                }
                if (is == null && (f = RendererConfigurations.getRenderersIconFile(icon)).isFile() && f.exists()) {
                    is = new FileInputStream(f);
                    mime = RenderersApiServlet.getMimeType(f.getName());
                }
                if (is == null) {
                    is = RenderersApiServlet.class.getResourceAsStream("/resources/images/clients/" + icon);
                    mime = RenderersApiServlet.getMimeType(icon);
                }
                if (is == null) {
                    is = RenderersApiServlet.class.getResourceAsStream("/renderers/" + icon);
                    mime = RenderersApiServlet.getMimeType(icon);
                }
                if (is == null) {
                    LOGGER.debug("Unable to read icon \"{}\", using \"{}\" instead.", (Object)icon, (Object)"unknown.png");
                    is = RenderersApiServlet.class.getResourceAsStream("/resources/images/clients/unknown.png");
                    mime = RenderersApiServlet.getMimeType("unknown.png");
                }
                if (is != null) {
                    AsyncContext async = req.startAsync();
                    if (resp.getContentType() == null && mime != null) {
                        resp.setContentType(mime);
                    }
                    resp.setContentLength(is.available());
                    resp.setStatus(200);
                    RenderersApiServlet.copyStreamAsync(is, resp.getOutputStream(), async);
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception", e);
            }
        }
        LOGGER.debug("Failed to load icon: " + icon);
        return false;
    }

    private static JsonObject getRendererInfos(JsonObject data) {
        int rId;
        RendererItem renderer;
        if (data != null && data.has("id") && (renderer = RendererItem.getRenderer(rId = data.get("id").getAsInt())) != null) {
            return renderer.getInfos();
        }
        return null;
    }
}

