/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.Paths;
import net.pms.image.Image;
import net.pms.image.ImageTypeAdapter;
import net.pms.network.HttpServletHelper;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiHttpServlet
extends HttpServletHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiHttpServlet.class);
    private static final ClassLoader CLASS_LOADER = new URLClassLoader(new URL[]{GuiHttpServlet.getUrl(String.valueOf(CONFIGURATION.getWebPath()) + "/react-client/")});
    protected static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).registerTypeAdapter((Type)((Object)Image.class), new ImageTypeAdapter()).create();

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (GuiHttpServlet.deny(req)) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            GuiHttpServlet.logHttpServletRequest(req, "");
        }
        super.service(req, resp);
    }

    protected static JsonArray getJsonArrayFromStringArray(String[] array) {
        return GSON.toJsonTree(array).getAsJsonArray();
    }

    protected static JsonObject getJsonObjectFromBody(HttpServletRequest req) {
        String reqBody = GuiHttpServlet.getBodyAsString(req);
        return GuiHttpServlet.jsonObjectFromString(reqBody);
    }

    protected static boolean writeAsync(HttpServletRequest req, HttpServletResponse resp, String filename) throws IOException {
        InputStream stream = CLASS_LOADER.getResourceAsStream(filename);
        if (stream != null) {
            String mime;
            AsyncContext async = req.startAsync();
            if (resp.getContentType() == null && (mime = GuiHttpServlet.getMimeType(filename)) != null) {
                resp.setContentType(mime);
            }
            resp.setContentLength(stream.available());
            resp.setStatus(200);
            GuiHttpServlet.logHttpServletResponse(req, resp, null, true);
            GuiHttpServlet.copyStreamAsync(stream, resp.getOutputStream(), async);
            return true;
        }
        return false;
    }

    protected static String getMimeType(String file) {
        String extension = FileUtil.getExtension(file);
        if (extension != null) {
            return switch (extension) {
                case "html" -> "text/html";
                case "css" -> "text/css";
                case "js" -> "text/javascript";
                case "ttf" -> "font/truetype";
                default -> URLConnection.guessContentTypeFromName(file);
            };
        }
        return URLConnection.guessContentTypeFromName(file);
    }

    private static JsonObject jsonObjectFromString(String str) {
        JsonObject jObject = null;
        try {
            JsonElement jElem = GSON.fromJson(str, JsonElement.class);
            if (jElem != null && jElem.isJsonObject()) {
                jObject = jElem.getAsJsonObject();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return jObject;
    }

    private static URL getUrl(String url) {
        try {
            return Paths.get(url, new String[0]).toUri().toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return null;
        }
    }
}

