/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import net.pms.formats.Format;
import net.pms.service.Services;
import net.pms.store.StoreItem;

public class StartStopListener {
    private final String rendererId;
    private final StoreItem item;
    private boolean started = false;
    private boolean stopped = false;

    public StartStopListener(String rendererId, StoreItem item) {
        this.rendererId = rendererId;
        this.item = item;
    }

    public synchronized void start() {
        assert (this.item != null);
        Format format = this.item.getFormat();
        if (!this.started && format != null && (format.isVideo() || format.isAudio())) {
            this.item.startPlaying(this.rendererId);
            this.started = true;
            Services.sleepManager().startPlaying();
        } else {
            Services.postponeSleep();
        }
    }

    public synchronized void setBytesSent(long bytesSent) {
        if (!this.started && bytesSent > 100000L) {
            this.start();
        }
    }

    public synchronized void stop() {
        if (this.started && !this.stopped) {
            this.item.stopPlaying(this.rendererId);
            this.stopped = true;
            Services.sleepManager().stopPlaying();
        }
    }
}

