/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.video.metadata;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaTableTvSeasonMetadataLocalized;
import net.pms.external.tmdb.TMDB;
import net.pms.media.video.metadata.ApiSeason;
import net.pms.media.video.metadata.TvSeasonMetadataLocalized;
import org.apache.commons.lang3.StringUtils;

public class TvSeasonMetadata {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private final Long tvSeriesId;
    private final Long tmdbTvId;
    private final ApiSeason apiSeason;
    private Map<String, TvSeasonMetadataLocalized> translations;

    public TvSeasonMetadata(Long tvSeriesId, Long tmdbTvId, ApiSeason apiSeason) {
        this.tvSeriesId = tvSeriesId;
        this.tmdbTvId = tmdbTvId;
        this.apiSeason = apiSeason;
    }

    public Long getTvSeriesId() {
        return this.tvSeriesId;
    }

    public String getAirDate() {
        return this.apiSeason.getAirDate();
    }

    public int getEpisodeCount() {
        return this.apiSeason.getEpisodeCount();
    }

    public int getTmdbId() {
        return this.apiSeason.getId();
    }

    public String getName(String lang) {
        TvSeasonMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getName())) {
            return translation.getName();
        }
        return this.apiSeason.getName();
    }

    public String getOverview(String lang) {
        TvSeasonMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getOverview())) {
            return translation.getOverview();
        }
        return this.apiSeason.getOverview();
    }

    public String getPoster(String lang) {
        TvSeasonMetadataLocalized translation = this.getTranslation(lang);
        if (translation != null && StringUtils.isNotBlank(translation.getPoster())) {
            return translation.getPoster();
        }
        return TMDB.getPosterUrl(this.getPosterPath());
    }

    public String getPosterPath() {
        return this.apiSeason.getPosterPath();
    }

    public int getSeasonNumber() {
        return this.apiSeason.getSeasonNumber();
    }

    public void ensureHavingTranslation(String lang) {
        TvSeasonMetadataLocalized loc;
        if ((lang = CONFIGURATION.getTranslationLanguage(lang)) != null && !"en-us".equals(lang) && !this.hasTranslation(lang) && this.tmdbTvId != null && this.tmdbTvId > -1L && (loc = MediaTableTvSeasonMetadataLocalized.getTvSeasonMetadataLocalized(this.tvSeriesId, lang, this.tmdbTvId, this.apiSeason)) != null) {
            this.addTranslation(lang, loc);
        }
    }

    private void addTranslation(String lang, TvSeasonMetadataLocalized value) {
        if (lang == null || value == null) {
            return;
        }
        if (this.translations == null) {
            this.translations = new HashMap<String, TvSeasonMetadataLocalized>();
        }
        this.translations.put(lang.toLowerCase(), value);
    }

    private boolean hasTranslation(String lang) {
        return this.translations != null && this.translations.containsKey(lang.toLowerCase());
    }

    private TvSeasonMetadataLocalized getTranslation(String lang) {
        if ((lang = CONFIGURATION.getTranslationLanguage(lang)) != null && this.hasTranslation(lang)) {
            return this.translations.get(lang);
        }
        return null;
    }

    public JsonObject asJsonObject(String lang) {
        lang = CONFIGURATION.getTranslationLanguage(lang);
        this.ensureHavingTranslation(lang);
        JsonObject result = new JsonObject();
        result.addProperty("airDate", this.getAirDate());
        result.addProperty("episodeCount", this.getEpisodeCount());
        result.addProperty("title", this.getName(lang));
        result.addProperty("overview", this.getOverview(lang));
        result.addProperty("poster", this.getPoster(lang));
        result.addProperty("tvSeason", this.getSeasonNumber());
        result.addProperty("tmdbID", this.getTmdbId());
        result.addProperty("tmdbTvID", this.tmdbTvId);
        return result;
    }
}

