/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.chapter;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.pms.dlna.DLNAThumbnail;
import net.pms.media.MediaLang;

public class MediaChapter
extends MediaLang {
    public static final Pattern CHAPTERS_TITLE_DEFAULT = Pattern.compile("^Chapter\\s\\d\\d$");
    public static final Pattern CHAPTERS_TITLE_TIMESTAMP = Pattern.compile("^\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d$");
    private int parentId;
    private String title;
    private double start;
    private double end;
    private Map<String, String> metadatas;
    private DLNAThumbnail thumbnail;

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, String> getMetadatas() {
        return this.metadatas;
    }

    public void setMetadatas(Map<String, String> metadatas) {
        this.metadatas = metadatas;
    }

    public void setMetadata(String key, String value) {
        if (this.metadatas == null) {
            this.metadatas = new HashMap<String, String>();
        }
        this.metadatas.put(key, value);
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        this.start = start;
    }

    public double getEnd() {
        return this.end;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    public DLNAThumbnail getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(DLNAThumbnail thumbnail) {
        this.thumbnail = thumbnail;
    }

    public static boolean isTitleDefault(String title) {
        return CHAPTERS_TITLE_DEFAULT.matcher(title).matches() || CHAPTERS_TITLE_TIMESTAMP.matcher(title).matches();
    }
}

