/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public abstract class NonGeometricBufferedImageOp
implements BufferedImageOp {
    protected final RenderingHints hints;

    protected NonGeometricBufferedImageOp(RenderingHints hints) {
        this.hints = hints;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    public Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destColorModel) {
        BufferedImage result;
        if (destColorModel == null) {
            ColorModel colorModel = src.getColorModel();
            result = new BufferedImage(colorModel, src.getRaster().createCompatibleWritableRaster(), colorModel.isAlphaPremultiplied(), null);
        } else {
            int width = src.getWidth();
            int height = src.getHeight();
            result = new BufferedImage(destColorModel, destColorModel.createCompatibleWritableRaster(width, height), destColorModel.isAlphaPremultiplied(), null);
        }
        return result;
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

