/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.musicbrainz.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import net.pms.external.musicbrainz.api.MusicBrainzTagInfo;
import net.pms.external.musicbrainz.api.MusicBrainzTagLatch;
import net.pms.external.musicbrainz.api.ReleaseRecord;
import net.pms.external.musicbrainz.api.ReleaseType;
import net.pms.util.StringUtil;
import net.pms.util.XmlUtils;
import org.apache.commons.lang3.StringUtils;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MusicBrainzUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MusicBrainzUtil.class);
    private static final long WAIT_TIMEOUT_MS = 30000L;
    private static final long EXPIRATION_TIME = 86400000L;
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = XmlUtils.xxeDisabledDocumentBuilderFactory();
    private static final String ENCODING = StandardCharsets.UTF_8.name();
    private static final Object TAG_LATCHES_LOCK = new Object();
    private static final List<MusicBrainzTagLatch> TAG_LATCHES = new ArrayList<MusicBrainzTagLatch>();

    private MusicBrainzUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MusicBrainzTagLatch reserveTagLatch(MusicBrainzTagInfo tagInfo) {
        MusicBrainzTagLatch tagLatch = null;
        boolean owner = false;
        long startTime = System.currentTimeMillis();
        while (!owner && !Thread.currentThread().isInterrupted()) {
            Object object = TAG_LATCHES_LOCK;
            synchronized (object) {
                for (MusicBrainzTagLatch latch : TAG_LATCHES) {
                    if (!latch.info.equals(tagInfo)) continue;
                    tagLatch = latch;
                    break;
                }
                if (tagLatch == null) {
                    tagLatch = new MusicBrainzTagLatch(tagInfo);
                    TAG_LATCHES.add(tagLatch);
                    owner = true;
                }
            }
            if (!owner && System.currentTimeMillis() - startTime > 30000L) {
                LOGGER.debug("A MusicBrainz search timed out while waiting it's turn");
                return null;
            }
            if (owner) continue;
            try {
                tagLatch.latch.await();
            }
            catch (InterruptedException e) {
                LOGGER.debug("A MusicBrainz search was interrupted while waiting it's turn");
                Thread.currentThread().interrupt();
                Iterator<MusicBrainzTagLatch> iterator = null;
                return iterator;
            }
            finally {
                tagLatch = null;
            }
        }
        return tagLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseTagLatch(MusicBrainzTagLatch tagLatch) {
        Object object = TAG_LATCHES_LOCK;
        synchronized (object) {
            if (!TAG_LATCHES.remove(tagLatch)) {
                LOGGER.error("Concurrency error: Held tagLatch not found in latchList");
            }
        }
        tagLatch.latch.countDown();
    }

    private static String fuzzString(String s) {
        String[] words = s.split(" ");
        StringBuilder sb = new StringBuilder("(");
        for (String word : words) {
            sb.append(StringUtil.luceneEscape(word)).append("~ ");
        }
        sb.append(')');
        return sb.toString();
    }

    private static String buildMBReleaseQuery(MusicBrainzTagInfo tagInfo, boolean fuzzy) {
        String and = MusicBrainzUtil.urlEncode(" AND ");
        StringBuilder query = new StringBuilder("release/?query=");
        boolean added = false;
        if (StringUtils.isNotBlank(tagInfo.album)) {
            if (fuzzy) {
                query.append(MusicBrainzUtil.urlEncode(MusicBrainzUtil.fuzzString(tagInfo.album)));
            } else {
                query.append(MusicBrainzUtil.urlEncode("\"" + StringUtil.luceneEscape(tagInfo.album) + "\""));
            }
            added = true;
        }
        if (StringUtils.isNotBlank(tagInfo.trackId) && (StringUtils.isBlank(tagInfo.album) || !StringUtils.isNotBlank(tagInfo.artist) && !StringUtils.isNotBlank(tagInfo.artistId))) {
            if (added) {
                query.append(and);
            }
            query.append("tid:").append(tagInfo.trackId);
            added = true;
        } else if (StringUtils.isNotBlank(tagInfo.title) && (StringUtils.isBlank(tagInfo.album) || !StringUtils.isNotBlank(tagInfo.artist) && !StringUtils.isNotBlank(tagInfo.artistId))) {
            if (added) {
                query.append(and);
            }
            query.append("recording:");
            if (fuzzy) {
                query.append(MusicBrainzUtil.urlEncode(MusicBrainzUtil.fuzzString(tagInfo.title)));
            } else {
                query.append(MusicBrainzUtil.urlEncode("\"" + StringUtil.luceneEscape(tagInfo.title) + "\""));
            }
            added = true;
        }
        if (!fuzzy && StringUtils.isNotBlank(tagInfo.year) && tagInfo.year.trim().length() > 3) {
            if (added) {
                query.append(and);
            }
            query.append("date:").append(MusicBrainzUtil.urlEncode(tagInfo.year)).append('*');
        }
        return query.toString();
    }

    private static String buildMBRecordingQuery(MusicBrainzTagInfo tagInfo, boolean fuzzy) {
        String and = MusicBrainzUtil.urlEncode(" AND ");
        StringBuilder query = new StringBuilder("recording/?query=");
        boolean added = false;
        if (StringUtils.isNotBlank(tagInfo.title)) {
            if (fuzzy) {
                query.append(MusicBrainzUtil.urlEncode(MusicBrainzUtil.fuzzString(tagInfo.title)));
            } else {
                query.append(MusicBrainzUtil.urlEncode("\"" + StringUtil.luceneEscape(tagInfo.title) + "\""));
            }
            added = true;
        }
        if (StringUtils.isNotBlank(tagInfo.trackId)) {
            if (added) {
                query.append(and);
            }
            query.append("tid:").append(tagInfo.trackId);
            added = true;
        }
        if (StringUtils.isNotBlank(tagInfo.artistId)) {
            if (added) {
                query.append(and);
            }
            query.append("arid:").append(tagInfo.artistId);
            added = true;
        } else if (StringUtils.isNotBlank(tagInfo.artist)) {
            if (added) {
                query.append(and);
            }
            query.append("artistname:");
            if (fuzzy) {
                query.append(MusicBrainzUtil.urlEncode(MusicBrainzUtil.fuzzString(tagInfo.artist)));
            } else {
                query.append(MusicBrainzUtil.urlEncode("\"" + StringUtil.luceneEscape(tagInfo.artist) + "\""));
            }
        }
        if (!fuzzy && StringUtils.isNotBlank(tagInfo.year) && tagInfo.year.trim().length() > 3) {
            if (added) {
                query.append(and);
            }
            query.append("date:").append(MusicBrainzUtil.urlEncode(tagInfo.year)).append('*');
        }
        return query.toString();
    }

    /*
     * Exception decompiling
     */
    public static String getMBID(Tag tag, boolean externalNetwork) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK], 15[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ArrayList<ReleaseRecord> parseRelease(Document document) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("release-list");
        if (nodeList.getLength() < 1) {
            return null;
        }
        Element listElement = (Element)nodeList.item(0);
        if ((nodeList = listElement.getElementsByTagName("release")).getLength() < 1) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\d{4}");
        ArrayList<ReleaseRecord> releaseList = new ArrayList<ReleaseRecord>(nodeList.getLength());
        int nodeListLength = nodeList.getLength();
        for (int i = 0; i < nodeListLength; ++i) {
            Element releaseYear;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element releaseElement = (Element)node;
            ReleaseRecord release = new ReleaseRecord();
            release.id = releaseElement.getAttribute("id");
            try {
                release.score = Integer.parseInt(releaseElement.getAttribute("ext:score"));
            }
            catch (NumberFormatException e) {
                release.score = 0;
            }
            try {
                release.album = MusicBrainzUtil.getChildElement(releaseElement, "title").getTextContent();
            }
            catch (NullPointerException e) {
                release.album = null;
            }
            Element releaseGroup = MusicBrainzUtil.getChildElement(releaseElement, "release-group");
            if (releaseGroup != null) {
                try {
                    release.type = ReleaseType.valueOf(MusicBrainzUtil.getChildElement(releaseGroup, "primary-type").getTextContent());
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    release.type = null;
                }
            }
            if ((releaseYear = MusicBrainzUtil.getChildElement(releaseElement, "date")) != null) {
                release.year = releaseYear.getTextContent();
                Matcher matcher = pattern.matcher(release.year);
                release.year = matcher.find() ? matcher.group() : null;
            } else {
                release.year = null;
            }
            Element artists = MusicBrainzUtil.getChildElement(releaseElement, "artist-credit");
            if (artists != null && artists.getChildNodes().getLength() > 0) {
                NodeList artistList = artists.getChildNodes();
                for (int j = 0; j < artistList.getLength(); ++j) {
                    Element artistNameElement;
                    Element artistElement;
                    Node node2 = artistList.item(j);
                    if (node2.getNodeType() != 1 || !node2.getNodeName().equals("name-credit") || !(node2 instanceof Element) || (artistElement = MusicBrainzUtil.getChildElement((Element)node2, "artist")) == null || (artistNameElement = MusicBrainzUtil.getChildElement(artistElement, "name")) == null) continue;
                    release.artists.add(artistNameElement.getTextContent());
                }
            }
            if (!StringUtils.isNotBlank(release.id)) continue;
            releaseList.add(release);
        }
        return releaseList;
    }

    private static ArrayList<ReleaseRecord> parseRecording(Document document) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("recording-list");
        if (nodeList.getLength() < 1) {
            return null;
        }
        Element listElement = (Element)nodeList.item(0);
        if ((nodeList = listElement.getElementsByTagName("recording")).getLength() < 1) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\d{4}");
        ArrayList<ReleaseRecord> releaseList = new ArrayList<ReleaseRecord>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element releaseListElement;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element recordingElement = (Element)node;
            ReleaseRecord releaseTemplate = new ReleaseRecord();
            try {
                releaseTemplate.score = Integer.parseInt(recordingElement.getAttribute("ext:score"));
            }
            catch (NumberFormatException e) {
                releaseTemplate.score = 0;
            }
            try {
                releaseTemplate.title = MusicBrainzUtil.getChildElement(recordingElement, "title").getTextContent();
            }
            catch (NullPointerException e) {
                releaseTemplate.title = null;
            }
            Element artists = MusicBrainzUtil.getChildElement(recordingElement, "artist-credit");
            if (artists != null && artists.getChildNodes().getLength() > 0) {
                NodeList artistList = artists.getChildNodes();
                for (int j = 0; j < artistList.getLength(); ++j) {
                    Element artistNameElement;
                    Element artistElement;
                    Node node2 = artistList.item(j);
                    if (node2.getNodeType() != 1 || !node2.getNodeName().equals("name-credit") || !(node2 instanceof Element) || (artistElement = MusicBrainzUtil.getChildElement((Element)node2, "artist")) == null || (artistNameElement = MusicBrainzUtil.getChildElement(artistElement, "name")) == null) continue;
                    releaseTemplate.artists.add(artistNameElement.getTextContent());
                }
            }
            if ((releaseListElement = MusicBrainzUtil.getChildElement(recordingElement, "release-list")) == null) continue;
            NodeList releaseNodeList = releaseListElement.getElementsByTagName("release");
            int releaseNodeListLength = releaseNodeList.getLength();
            for (int j = 0; j < releaseNodeListLength; ++j) {
                ReleaseRecord release = new ReleaseRecord(releaseTemplate);
                Element releaseElement = (Element)releaseNodeList.item(j);
                release.id = releaseElement.getAttribute("id");
                Element releaseGroup = MusicBrainzUtil.getChildElement(releaseElement, "release-group");
                if (releaseGroup != null) {
                    try {
                        release.type = ReleaseType.valueOf(MusicBrainzUtil.getChildElement(releaseGroup, "primary-type").getTextContent());
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        release.type = null;
                    }
                }
                try {
                    release.album = MusicBrainzUtil.getChildElement(releaseElement, "title").getTextContent();
                }
                catch (NullPointerException e) {
                    release.album = null;
                }
                Element releaseYear = MusicBrainzUtil.getChildElement(releaseElement, "date");
                if (releaseYear != null) {
                    release.year = releaseYear.getTextContent();
                    Matcher matcher = pattern.matcher(release.year);
                    release.year = matcher.find() ? matcher.group() : null;
                } else {
                    release.year = null;
                }
                if (!StringUtils.isNotBlank(release.id)) continue;
                releaseList.add(release);
            }
        }
        return releaseList;
    }

    protected static boolean tagSupportsFieldKey(Tag tag, FieldKey key) {
        try {
            tag.getFirst(key);
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    protected static Element getChildElement(Element element, String name) {
        NodeList list = element.getElementsByTagName(name);
        int listLength = list.getLength();
        for (int i = 0; i < listLength; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name) || !(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    protected static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UTF-8 is unsupported :O", e);
            return "";
        }
    }
}

