/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EncodingFormat {
    private static final String LPCM = "LPCM";
    private static final String MP3 = "MP3";
    private static final String WAV = "WAV";
    private static final String MP4_H264_AAC = "MP4-H264-AAC";
    private static final String MP4_H265_AC3 = "MP4-H265-AC3";
    private static final String MPEGTS_H264_AAC = "MPEGTS-H264-AAC";
    private static final String MPEGTS_H264_AC3 = "MPEGTS-H264-AC3";
    private static final String MPEGTS_H265_AAC = "MPEGTS-H265-AAC";
    private static final String MPEGTS_H265_AC3 = "MPEGTS-H265-AC3";
    private static final String MPEGPS_MPEG2_AC3 = "MPEGPS-MPEG2-AC3";
    private static final String MPEGTS_MPEG2_AC3 = "MPEGTS-MPEG2-AC3";
    private static final String HLS_MPEGTS_H264_AAC = "HLS-MPEGTS-H264-AAC";
    private static final String HLS_MPEGTS_H264_AC3 = "HLS-MPEGTS-H264-AC3";
    private static final String WMV = "WMV";
    public static final Map<String, EncodingFormat> AUDIO = Map.ofEntries(Map.entry("LPCM", new EncodingFormat("LPCM", "lpcm", "lpcm")), Map.entry("MP3", new EncodingFormat("MP3", "mp3", "mp3")), Map.entry("WAV", new EncodingFormat("WAV", "wav", "wav")));
    public static final Map<String, EncodingFormat> VIDEO = Map.ofEntries(Map.entry("MP4-H264-AAC", new EncodingFormat("MP4-H264-AAC", "mp4", "h264", "aac-lc")), Map.entry("MP4-H265-AC3", new EncodingFormat("MP4-H265-AC3", "mp4", "h265", "ac3")), Map.entry("MPEGTS-H264-AAC", new EncodingFormat("MPEGTS-H264-AAC", "mpegts", "h264", "aac-lc")), Map.entry("MPEGTS-H264-AC3", new EncodingFormat("MPEGTS-H264-AC3", "mpegts", "h264", "ac3")), Map.entry("MPEGTS-H265-AAC", new EncodingFormat("MPEGTS-H265-AAC", "mpegts", "h265", "aac-lc")), Map.entry("MPEGTS-H265-AC3", new EncodingFormat("MPEGTS-H265-AC3", "mpegts", "h265", "ac3")), Map.entry("MPEGPS-MPEG2-AC3", new EncodingFormat("MPEGPS-MPEG2-AC3", "mpegps", "mpeg2", "ac3")), Map.entry("MPEGTS-MPEG2-AC3", new EncodingFormat("MPEGTS-MPEG2-AC3", "mpegts", "mpeg2", "ac3")), Map.entry("HLS-MPEGTS-H264-AAC", new EncodingFormat("MPEGTS-H264-AAC", "hls", "h264", "aac-lc")), Map.entry("HLS-MPEGTS-H264-AC3", new EncodingFormat("MPEGTS-H264-AAC", "hls", "h264", "ac3")), Map.entry("WMV", new EncodingFormat("WMV", "wmv", "wmv", "wma")));
    private final String name;
    private final String container;
    private final String videoCodec;
    private final String audioCodec;

    public EncodingFormat(String name, String container, String audioCodec) {
        this(name, container, null, audioCodec);
    }

    public EncodingFormat(String name, String container, String videoCodec, String audioCodec) {
        this.name = name;
        this.container = container;
        this.videoCodec = videoCodec;
        this.audioCodec = audioCodec;
    }

    public String getTranscodingContainer() {
        return this.container;
    }

    public String getTranscodingVideoCodec() {
        return this.videoCodec;
    }

    public String getTranscodingAudioCodec() {
        return this.audioCodec;
    }

    public boolean isAudioFormat() {
        return this.audioCodec != null && this.videoCodec == null;
    }

    public boolean isVideoFormat() {
        return this.videoCodec != null;
    }

    public boolean isTranscodeToMP3() {
        return MP3.equals(this.name);
    }

    public boolean isTranscodeToLPCM() {
        return LPCM.equals(this.name);
    }

    public boolean isTranscodeToWAV() {
        return WAV.equals(this.name);
    }

    public boolean isTranscodeToWMV() {
        return WMV.equals(this.name);
    }

    public boolean isTranscodeToMP4H265AC3() {
        return MP4_H265_AC3.equals(this.name);
    }

    public boolean isTranscodeToAC3() {
        return "ac3".equals(this.getTranscodingAudioCodec());
    }

    public boolean isTranscodeToAAC() {
        return "aac-lc".equals(this.getTranscodingAudioCodec());
    }

    public boolean isTranscodeToH264() {
        return "h264".equals(this.getTranscodingVideoCodec());
    }

    public boolean isTranscodeToH265() {
        return "h265".equals(this.getTranscodingVideoCodec());
    }

    public boolean isTranscodeToMPEG2() {
        return "mpeg2".equals(this.getTranscodingVideoCodec());
    }

    public boolean isTranscodeToMPEGTS() {
        return "mpegts".equals(this.getTranscodingContainer());
    }

    public boolean isTranscodeToMP4() {
        return "mp4".equals(this.getTranscodingContainer());
    }

    public boolean isTranscodeToHLS() {
        return "hls".equals(this.getTranscodingContainer());
    }

    public String toString() {
        return this.name;
    }

    public static EncodingFormat getAudioEncodingFormat(String encodingFormat) {
        if (encodingFormat == null || !AUDIO.containsKey(encodingFormat)) {
            return null;
        }
        return AUDIO.get(encodingFormat);
    }

    public static List<EncodingFormat> getVideoEncodingFormats(List<String> encodingFormats) {
        ArrayList<EncodingFormat> result = new ArrayList<EncodingFormat>();
        if (encodingFormats != null && !encodingFormats.isEmpty()) {
            for (String encodingFormat : encodingFormats) {
                EncodingFormat format = EncodingFormat.getVideoEncodingFormat(encodingFormat);
                if (format == null) continue;
                result.add(format);
            }
        }
        return result;
    }

    public static EncodingFormat getVideoEncodingFormat(String encodingFormat) {
        if (encodingFormat == null || !VIDEO.containsKey(encodingFormat)) {
            return null;
        }
        return VIDEO.get(encodingFormat);
    }

    public static EncodingFormat getEncodingFormat(String encodingFormat) {
        if (encodingFormat != null) {
            if (AUDIO.containsKey(encodingFormat)) {
                return AUDIO.get(encodingFormat);
            }
            if (VIDEO.containsKey(encodingFormat)) {
                return VIDEO.get(encodingFormat);
            }
        }
        return null;
    }
}

