/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.StandardEngineId;
import net.pms.encoders.Track;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperLiteImpl;
import net.pms.io.StreamGobbler;
import net.pms.platform.PlatformUtils;
import net.pms.util.H264AnnexBInputStream;
import net.pms.util.PCMAudioOutputStream;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviDemuxerInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(AviDemuxerInputStream.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private final Track[] track = new Track[2];
    private final InputStream stream;
    private final OutputStream vOut;
    private final Thread parsing;
    private final OutputParams params;
    private Process process;
    private List<ProcessWrapper> attachedProcesses;
    private long readCount = -1L;
    private String streamVideoTag;
    private int numberOfAudioChannels;
    private OutputStream aOut;
    private long audiosize;
    private long videosize;
    private InputStream realIS;

    @Override
    public void close() throws IOException {
        if (this.process != null) {
            ProcessUtil.destroy(this.process);
        }
        super.close();
    }

    public AviDemuxerInputStream(InputStream fin, OutputParams params, List<ProcessWrapper> at) throws IOException {
        this.stream = fin;
        LOGGER.trace("Opening AVI Stream");
        this.attachedProcesses = at;
        this.params = params;
        this.aOut = params.getOutputPipes()[1].getOutputStream();
        if (params.isNoVideoEncode() && params.getForceType() != null && params.getForceType().equals("V_MPEG4/ISO/AVC") && params.getHeader() != null) {
            Runnable r;
            PipedOutputStream pout = new PipedOutputStream();
            try (H264AnnexBInputStream pin = new H264AnnexBInputStream(new PipedInputStream(pout), params.getHeader());){
                OutputStream out = params.getOutputPipes()[0].getOutputStream();
                r = () -> {
                    try {
                        int n;
                        byte[] b = new byte[524288];
                        while ((n = pin.read(b)) > -1) {
                            out.write(b, 0, n);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error(null, e);
                    }
                };
            }
            this.vOut = pout;
            new Thread(r, "Avi Demuxer").start();
        } else {
            this.vOut = params.getOutputPipes()[0].getOutputStream();
        }
        Runnable r = () -> {
            try {
                TsMuxeRVideo ts = (TsMuxeRVideo)EngineFactory.getEngine(StandardEngineId.TSMUXER_VIDEO, false, false);
                File f = new File(CONFIGURATION.getTempFolder(), "ums-tsmuxer.meta");
                try (PrintWriter pw = new PrintWriter(f);){
                    pw.println("MUXOPT --no-pcr-on-video-pid --no-asyncio --new-audio-pes --vbr --vbv-len=500");
                    String videoType = "V_MPEG-2";
                    if (params.isNoVideoEncode() && params.getForceType() != null) {
                        videoType = params.getForceType();
                    }
                    Object fps = "";
                    if (params.getForceFps() != null) {
                        fps = "fps=" + params.getForceFps() + ", ";
                    }
                    String audioType = "A_LPCM";
                    if (params.isLossyAudio()) {
                        audioType = "A_AC3";
                    }
                    pw.println(videoType + ", \"" + params.getOutputPipes()[0].getOutputPipe() + "\", " + (String)fps + "level=4.1, insertSEI, contSPS, track=1");
                    pw.println(audioType + ", \"" + params.getOutputPipes()[1].getOutputPipe() + "\", track=2");
                }
                IPipeProcess tsPipe = PlatformUtils.INSTANCE.getPipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
                ProcessWrapper pipeProcess = tsPipe.getPipeProcess();
                this.attachedProcesses.add(pipeProcess);
                pipeProcess.runInNewThread();
                tsPipe.deleteLater();
                String[] cmd = new String[]{ts.getExecutable(), f.getAbsolutePath(), tsPipe.getInputPipe()};
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.redirectErrorStream(true);
                this.process = pb.start();
                ProcessWrapperLiteImpl pwi = new ProcessWrapperLiteImpl(this.process);
                this.attachedProcesses.add(pwi);
                StreamGobbler.consume(this.process.getInputStream(), true);
                this.realIS = tsPipe.getInputStream();
                ProcessUtil.waitFor(this.process);
                LOGGER.trace("tsMuxeR muxing finished");
            }
            catch (IOException e) {
                LOGGER.error(null, e);
            }
        };
        Runnable r2 = () -> {
            try {
                this.parseHeader();
            }
            catch (IOException e) {
                LOGGER.debug("Parsing error", e);
            }
        };
        LOGGER.trace("Launching tsMuxeR muxing");
        new Thread(r, "Avi Demuxer tsMuxeR").start();
        this.parsing = new Thread(r2, "Avi Demuxer Header Parser");
        LOGGER.trace("Ready to mux");
    }

    private void parseHeader() throws IOException {
        int size;
        String command;
        LOGGER.trace("Parsing AVI stream");
        String id = AviDemuxerInputStream.getString(this.stream, 4);
        AviDemuxerInputStream.getBytes(this.stream, 4);
        String type = AviDemuxerInputStream.getString(this.stream, 4);
        if (!"RIFF".equalsIgnoreCase(id) || !"AVI ".equalsIgnoreCase(type)) {
            throw new IOException("Not AVI file");
        }
        byte[] hdrl = null;
        while (true) {
            String command2 = AviDemuxerInputStream.getString(this.stream, 4);
            int length = AviDemuxerInputStream.readBytes(this.stream, 4) + 1 & 0xFFFFFFFE;
            if ("LIST".equalsIgnoreCase(command2)) {
                command2 = AviDemuxerInputStream.getString(this.stream, 4);
                length -= 4;
                if ("movi".equalsIgnoreCase(command2)) break;
                if ("hdrl".equalsIgnoreCase(command2)) {
                    hdrl = AviDemuxerInputStream.getBytes(this.stream, length);
                }
                if ("idx1".equalsIgnoreCase(command2)) {
                    AviDemuxerInputStream.getBytes(this.stream, length);
                }
                if (!"iddx".equalsIgnoreCase(command2)) continue;
                AviDemuxerInputStream.getBytes(this.stream, length);
                continue;
            }
            AviDemuxerInputStream.getBytes(this.stream, length);
        }
        int streamNumber = 0;
        int lastTagID = 0;
        int i = 0;
        while (i < hdrl.length) {
            command = new String(hdrl, i, 4);
            size = AviDemuxerInputStream.str2ulong(hdrl, i + 4);
            if ("LIST".equalsIgnoreCase(command)) {
                i += 12;
                continue;
            }
            String command2 = new String(hdrl, i + 8, 4);
            if ("strh".equalsIgnoreCase(command)) {
                lastTagID = 0;
                if ("vids".equalsIgnoreCase(command2)) {
                    String compressor = new String(hdrl, i + 12, 4);
                    int scale = AviDemuxerInputStream.str2ulong(hdrl, i + 28);
                    int rate = AviDemuxerInputStream.str2ulong(hdrl, i + 32);
                    this.track[0] = new Track(compressor, scale, rate, -1);
                    this.streamVideoTag = new String(new char[]{(char)(streamNumber / 10 + 48), (char)(streamNumber % 10 + 48), 'd', 'b'});
                    ++streamNumber;
                    lastTagID = 1;
                }
                if ("auds".equalsIgnoreCase(command2)) {
                    int scale = AviDemuxerInputStream.str2ulong(hdrl, i + 28);
                    int rate = AviDemuxerInputStream.str2ulong(hdrl, i + 32);
                    int sampleSize = AviDemuxerInputStream.str2ulong(hdrl, i + 52);
                    this.track[1 + this.numberOfAudioChannels++] = new Track(null, scale, rate, sampleSize);
                    ++streamNumber;
                    lastTagID = 2;
                }
            }
            if ("strf".equalsIgnoreCase(command)) {
                byte[] information;
                if (lastTagID == 1) {
                    information = new byte[size];
                    System.arraycopy(hdrl, i + 8, information, 0, information.length);
                    this.track[0].setBih(information);
                }
                if (lastTagID == 2) {
                    information = new byte[size];
                    System.arraycopy(hdrl, i + 8, information, 0, information.length);
                    Track aud = this.track[1 + this.numberOfAudioChannels - 1];
                    aud.setBih(information);
                    int bitsPerSample = AviDemuxerInputStream.str2ushort(information, 14);
                    aud.setBitsPerSample(bitsPerSample);
                    int nbAudio = AviDemuxerInputStream.str2ushort(information, 2);
                    aud.setNbAudio(nbAudio);
                    long fileLength = 100L;
                    if (this.params.isLosslessAudio()) {
                        this.aOut = new PCMAudioOutputStream(this.aOut, nbAudio, 48000, bitsPerSample);
                    }
                    if (!this.params.isLossyAudio() && this.params.isLosslessAudio()) {
                        AviDemuxerInputStream.writePCMHeader(this.aOut, fileLength, nbAudio, aud.getRate(), aud.getSampleSize(), bitsPerSample);
                    }
                }
            }
            if (size % 2 != 0) {
                ++size;
            }
            i += size + 8;
        }
        LOGGER.trace("Found " + streamNumber + " stream(s)");
        boolean init = false;
        while (true) {
            try {
                command = AviDemuxerInputStream.getString(this.stream, 4);
            }
            catch (IOException e) {
                LOGGER.trace("Error reading stream: " + e.getMessage());
                break;
            }
            if (command == null) break;
            command = command.toUpperCase();
            size = AviDemuxerInputStream.readBytes(this.stream, 4);
            boolean framed = false;
            while ("LIST".equals(command) || "RIFF".equals(command) || "JUNK".equals(command)) {
                if (size < 0) {
                    size = 4;
                }
                AviDemuxerInputStream.getBytes(this.stream, "RIFF".equals(command) ? 4 : size);
                command = AviDemuxerInputStream.getString(this.stream, 4).toUpperCase();
                size = AviDemuxerInputStream.readBytes(this.stream, 4);
                if (!"LIST".equals(command) && !"RIFF".equals(command) && !"JUNK".equals(command) || size % 2 == 0) continue;
                AviDemuxerInputStream.readByte(this.stream);
            }
            String videoTag = this.streamVideoTag.substring(0, 3);
            if (command.substring(0, 3).equalsIgnoreCase(videoTag) && (command.charAt(3) == 'B' || command.charAt(3) == 'C')) {
                byte[] buffer = AviDemuxerInputStream.getBytes(this.stream, size);
                if (!command.equalsIgnoreCase("IDX1")) {
                    this.vOut.write(buffer);
                    this.videosize += (long)size;
                }
                framed = true;
            }
            if (!framed) {
                for (int i2 = 0; i2 < this.numberOfAudioChannels; ++i2) {
                    byte[] buffer = AviDemuxerInputStream.getBytes(this.stream, size);
                    if (!command.equalsIgnoreCase("IDX1")) {
                        this.aOut.write(buffer, init ? 4 : 0, init ? size - 4 : size);
                        init = false;
                        this.audiosize += (long)size;
                    }
                    framed = true;
                }
            }
            if (!framed) {
                throw new IOException("Not header: " + command);
            }
            if (size % 2 == 0) continue;
            AviDemuxerInputStream.readByte(this.stream);
        }
        LOGGER.trace("output pipes closed");
        this.aOut.close();
        this.vOut.close();
    }

    private static String getString(InputStream input, int sz) throws IOException {
        byte[] bb = AviDemuxerInputStream.getBytes(input, sz);
        return new String(bb);
    }

    private static byte[] getBytes(InputStream input, int sz) throws IOException {
        int u;
        byte[] bb = new byte[sz];
        for (int n = input.read(bb); n < sz && (u = input.read(bb, n, sz - n)) != -1; n += u) {
        }
        return bb;
    }

    private static int readBytes(InputStream input, int number) throws IOException {
        byte[] buffer = new byte[number];
        int read = input.read(buffer);
        if (read < number) {
            if (read < 0) {
                throw new IOException("End of stream");
            }
            for (int i = read; i < number; ++i) {
                buffer[i] = (byte)AviDemuxerInputStream.readByte(input);
            }
        }
        switch (number) {
            case 1: {
                return buffer[0] & 0xFF;
            }
            case 2: {
                return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
            }
            case 3: {
                return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16;
            }
            case 4: {
                return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16 | (buffer[3] & 0xFF) << 24;
            }
        }
        throw new IOException("Illegal Read quantity");
    }

    private static int readByte(InputStream input) throws IOException {
        return input.read();
    }

    public static int str2ulong(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | (data[i + 3] & 0xFF) << 24;
    }

    public static int str2ushort(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8;
    }

    public static byte[] getLe32(long value) {
        byte[] buffer = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        return buffer;
    }

    public static byte[] getLe16(int value) {
        byte[] buffer = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF)};
        return buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.readCount == -1L) {
            this.parsing.start();
            this.readCount = 0L;
        }
        for (int c = 0; (this.realIS == null || this.videosize == 0L || this.audiosize == 0L) && c < 15; ++c) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.trace("Sleep interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.realIS != null) {
            ++this.readCount;
            return this.realIS.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.readCount == -1L) {
            this.parsing.start();
            this.readCount = 0L;
        }
        for (int c = 0; (this.realIS == null || this.videosize == 0L || this.audiosize == 0L) && c < 15; ++c) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.trace("Sleep interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.realIS != null) {
            int n = this.realIS.read(b);
            this.readCount += (long)n;
            return n;
        }
        return -1;
    }

    public static void writePCMHeader(OutputStream aOut, long fileLength, int nbAudio, int rate, int sampleSize, int bitsPerSample) {
    }
}

