/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAImageResElement;
import net.pms.dlna.DlnaHelper;
import net.pms.encoders.EncodingFormat;
import net.pms.formats.Format;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.media.MediaInfo;
import net.pms.media.MediaStatus;
import net.pms.media.MediaType;
import net.pms.media.audio.MediaAudio;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.network.mediaserver.MediaServer;
import net.pms.renderers.Renderer;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.container.DVDISOFile;
import net.pms.store.container.PlaylistFolder;
import net.pms.store.container.VirtualFolderDbId;
import net.pms.store.item.RealFile;
import net.pms.util.FullyPlayed;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DidlHelper
extends DlnaHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DidlHelper.class);
    private static final SimpleDateFormat DIDL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);

    protected DidlHelper() {
    }

    public static final String getDidlResults(List<StoreResource> resultResources) {
        StringBuilder filesData = new StringBuilder();
        filesData.append("&lt;DIDL-Lite xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" xmlns:sec=\"http://www.sec.co.kr/\" xmlns:pv=\"http://www.pv.com/pvns/\"&gt;");
        for (StoreResource resource : resultResources) {
            filesData.append(DidlHelper.getDidlString(resource));
        }
        filesData.append("&lt;/DIDL-Lite&gt;");
        return StringEscapeUtils.unescapeXml(filesData.toString());
    }

    public static final String getDidlString(StoreResource resource) {
        String uclass;
        MediaType mediaType;
        RealFile realfile;
        Object title;
        MediaAudioMetadata audioMetadata;
        String updateId;
        StoreItem storeItem;
        StoreContainer storeContainer;
        Renderer renderer = resource.getDefaultRenderer();
        MediaInfo mediaInfo = resource.getMediaInfo();
        MediaStatus mediaStatus = resource.getMediaStatus();
        StoreContainer container = resource instanceof StoreContainer ? (storeContainer = (StoreContainer)resource) : null;
        StoreItem item = resource instanceof StoreItem ? (storeItem = (StoreItem)resource) : null;
        EncodingFormat encodingFormat = item != null && item.isTranscoded() ? item.getTranscodingSettings().getEncodingFormat() : null;
        Format format = item != null ? item.getFormat() : null;
        MediaSubtitle mediaSubtitle = item != null ? item.getMediaSubtitle() : null;
        StringBuilder sb = new StringBuilder();
        boolean subsAreValidForStreaming = false;
        boolean xbox360 = renderer.isXbox360();
        if (item != null) {
            if (mediaInfo != null && mediaInfo.isVideo()) {
                if (!renderer.getUmsConfiguration().isDisableSubtitles() && (!item.isTranscoded() || renderer.streamSubsForTranscodedVideo()) && mediaSubtitle != null && mediaSubtitle.isExternal() && renderer.isExternalSubtitlesFormatSupported(mediaSubtitle, item)) {
                    subsAreValidForStreaming = true;
                    LOGGER.trace("External subtitles \"{}\" can be streamed to {}", (Object)mediaSubtitle.getName(), (Object)renderer);
                } else if (mediaSubtitle != null && LOGGER.isTraceEnabled()) {
                    if (renderer.getUmsConfiguration().isDisableSubtitles()) {
                        LOGGER.trace("Subtitles are disabled");
                    } else if (mediaSubtitle.isEmbedded()) {
                        LOGGER.trace("Subtitles track {} cannot be streamed because it is internal/embedded", (Object)mediaSubtitle.getId());
                    } else if (item.isTranscoded() && !renderer.streamSubsForTranscodedVideo()) {
                        LOGGER.trace("Subtitles \"{}\" aren't supported while transcoding to {}", (Object)mediaSubtitle.getName(), (Object)renderer);
                    } else {
                        LOGGER.trace("Subtitles \"{}\" aren't valid for streaming to {}", (Object)mediaSubtitle.getName(), (Object)renderer);
                    }
                }
            }
            DidlHelper.openTag(sb, "item");
        } else {
            DidlHelper.openTag(sb, "container");
        }
        Object resourceId = resource.getResourceId();
        if (xbox360) {
            resourceId = (String)resourceId + "$";
        }
        if (item != null && renderer.needVersionedObjectId() && (updateId = MediaStoreIds.getObjectUpdateIdAsString(item.getLongId())) != null) {
            resourceId = (String)resourceId + "#" + updateId;
        }
        DidlHelper.addAttribute(sb, "id", resourceId);
        if (container != null) {
            if (!container.isDiscovered() && container.childrenCount() == 0) {
                DidlHelper.addAttribute(sb, "childCount", 1);
            } else {
                DidlHelper.addAttribute(sb, "childCount", container.childrenCount());
            }
        }
        resourceId = resource.getParentId();
        if (xbox360 && resource.getFakeParentId() == null) {
            resourceId = (String)resourceId + "$";
        }
        DidlHelper.addAttribute(sb, "parentID", resourceId);
        DidlHelper.addAttribute(sb, "restricted", "1");
        DidlHelper.endTag(sb);
        MediaVideo defaultVideoTrack = mediaInfo != null ? mediaInfo.getDefaultVideoTrack() : null;
        MediaAudio defaultAudioTrack = mediaInfo != null ? mediaInfo.getDefaultAudioTrack() : null;
        MediaAudioMetadata mediaAudioMetadata = audioMetadata = mediaInfo != null ? mediaInfo.getAudioMetadata() : null;
        if (audioMetadata != null && mediaInfo != null && mediaInfo.isAudio() && StringUtils.isNotBlank(audioMetadata.getSongname())) {
            title = "";
            if (renderer.isPrependTrackNumbers() && audioMetadata.getTrack() > 0) {
                title = (String)title + String.format("%03d - ", audioMetadata.getTrack());
            }
            title = (String)title + audioMetadata.getSongname();
        } else {
            title = container != null || subsAreValidForStreaming ? resource.getDisplayName(false) : renderer.getUseSameExtension(resource.getDisplayName(false));
        }
        if (!renderer.isThumbnails() && resource instanceof RealFile && (realfile = (RealFile)resource).isFullyPlayedMark()) {
            title = FullyPlayed.addFullyPlayedNamePrefix((String)title, resource);
        }
        if (item != null) {
            title = item.resumeStr((String)title);
        }
        DidlHelper.addXMLTagAndAttribute(sb, "dc:title", DidlHelper.encodeXML(renderer.getDcTitle((String)title, resource.getDisplayNameSuffix(), resource)));
        if (renderer.isSamsung() && resource instanceof RealFile) {
            DidlHelper.addBookmark(resource, sb, renderer.getDcTitle((String)title, resource.getDisplayNameSuffix(), resource));
        }
        if (audioMetadata != null && renderer.isSendDateMetadataYearForAudioTags() && audioMetadata.getYear() > 1000) {
            DidlHelper.addXMLTagAndAttribute(sb, "dc:date", Integer.toString(audioMetadata.getYear()));
        } else if (resource.getLastModified() > 0L && renderer.isSendDateMetadata()) {
            DidlHelper.addXMLTagAndAttribute(sb, "dc:date", DidlHelper.formatDate(new Date(resource.getLastModified())));
        }
        if (mediaInfo != null && audioMetadata != null) {
            if (StringUtils.isNotBlank(audioMetadata.getAlbum())) {
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:album", DidlHelper.encodeXML(audioMetadata.getAlbum()));
            }
            if (StringUtils.isNotBlank(audioMetadata.getArtist())) {
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:artist", DidlHelper.encodeXML(audioMetadata.getArtist()));
                DidlHelper.addXMLTagAndAttribute(sb, "dc:creator", DidlHelper.encodeXML(audioMetadata.getArtist()));
            }
            if (StringUtils.isNotBlank(audioMetadata.getComposer())) {
                DidlHelper.addXMLTagAndAttributeWithRole(sb, "upnp:artist role=\"Composer\"", DidlHelper.encodeXML(audioMetadata.getComposer()));
                DidlHelper.addXMLTagAndAttributeWithRole(sb, "upnp:author role=\"Composer\"", DidlHelper.encodeXML(audioMetadata.getComposer()));
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:composer", DidlHelper.encodeXML(audioMetadata.getComposer()));
            }
            if (StringUtils.isNotBlank(audioMetadata.getConductor())) {
                DidlHelper.addXMLTagAndAttributeWithRole(sb, "upnp:artist role=\"Conductor\"", DidlHelper.encodeXML(audioMetadata.getConductor()));
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:conductor", DidlHelper.encodeXML(audioMetadata.getConductor()));
            }
            if (StringUtils.isNotBlank(audioMetadata.getGenre())) {
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:genre", DidlHelper.encodeXML(audioMetadata.getGenre()));
            }
            if (audioMetadata.getTrack() > 0) {
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:originalTrackNumber", "" + audioMetadata.getTrack());
            }
            if (audioMetadata.getRating() != null) {
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:rating", "" + audioMetadata.getRating());
            }
        }
        if (mediaInfo != null && mediaInfo.hasVideoMetadata()) {
            MediaVideoMetadata videoMetadata = mediaInfo.getVideoMetadata();
            if (videoMetadata.isTvEpisode()) {
                if (videoMetadata.getTvSeason() != null) {
                    DidlHelper.addXMLTagAndAttribute(sb, "upnp:episodeSeason", videoMetadata.getTvSeason());
                }
                if (StringUtils.isNotBlank(videoMetadata.getTvEpisodeNumber())) {
                    DidlHelper.addXMLTagAndAttribute(sb, "upnp:episodeNumber", videoMetadata.getTvEpisodeNumberUnpadded());
                }
                if (StringUtils.isNotBlank(videoMetadata.getTvSeriesTitle())) {
                    DidlHelper.addXMLTagAndAttribute(sb, "upnp:seriesTitle", DidlHelper.encodeXML(videoMetadata.getTvSeriesTitle(null)));
                }
                if (StringUtils.isNotBlank(videoMetadata.getTvEpisodeName())) {
                    DidlHelper.addXMLTagAndAttribute(sb, "upnp:programTitle", DidlHelper.encodeXML(videoMetadata.getTvEpisodeName(null)));
                }
            }
            if (mediaStatus != null) {
                DidlHelper.addXMLTagAndAttribute(sb, "upnp:playbackCount", mediaStatus.getPlaybackCount());
                if (StringUtils.isNotBlank(mediaStatus.getLastPlaybackTime())) {
                    DidlHelper.addXMLTagAndAttribute(sb, "upnp:lastPlaybackTime", DidlHelper.encodeXML(mediaStatus.getLastPlaybackTime()));
                }
                if (StringUtils.isNotBlank(mediaStatus.getLastPlaybackPositionForUPnP())) {
                    DidlHelper.addXMLTagAndAttribute(sb, "upnp:lastPlaybackPosition", DidlHelper.encodeXML(mediaStatus.getLastPlaybackPositionForUPnP()));
                }
            }
        }
        MediaType mediaType2 = mediaType = mediaInfo != null ? mediaInfo.getMediaType() : MediaType.UNKNOWN;
        if (item != null && mediaType == MediaType.IMAGE) {
            DidlHelper.appendImage(item, sb);
        } else if (item != null) {
            int indexCount = 1;
            if (renderer.isDLNALocalizationRequired()) {
                indexCount = DidlHelper.getDLNALocalesCount();
            }
            for (int c = 0; c < indexCount; ++c) {
                DidlHelper.openTag(sb, "res");
                DidlHelper.addAttribute(sb, "xmlns:dlna", "urn:schemas-dlna-org:metadata-1-0/");
                String dlnaOrgPnFlags = DidlHelper.getDlnaOrgPnFlags(item, c);
                Object dlnaOrgFlags = "*";
                if (renderer.isSendDLNAOrgFlags()) {
                    dlnaOrgFlags = (String)(dlnaOrgPnFlags != null ? dlnaOrgPnFlags + ";" : "") + DidlHelper.getDlnaOrgOpFlags(item);
                }
                String tempString = "http-get:*:" + item.getRendererMimeType() + ":" + (String)dlnaOrgFlags;
                DidlHelper.addAttribute(sb, "protocolInfo", tempString);
                if (subsAreValidForStreaming && mediaSubtitle != null && renderer.offerSubtitlesByProtocolInfo() && !renderer.useClosedCaption()) {
                    DidlHelper.addAttribute(sb, "pv:subtitleFileType", mediaSubtitle.getType().getExtension().toUpperCase());
                    DidlHelper.addAttribute(sb, "pv:subtitleFileUri", resource.getSubsURL(mediaSubtitle));
                }
                if (renderer.getUmsConfiguration().isUpnpCdsWrite() && renderer.getUmsConfiguration().isAnonymousDevicesWrite() && (item.getRendererMimeType().toLowerCase().startsWith("audio") || item.getRendererMimeType().toLowerCase().startsWith("video"))) {
                    DidlHelper.addAttribute(sb, "importUri", MediaServer.getURL() + "/import?id=" + item.getId());
                }
                if (format != null && format.isVideo() && mediaInfo != null && mediaInfo.isMediaParsed()) {
                    long transcodedSize = renderer.getTranscodedSize();
                    if (!item.isTranscoded()) {
                        DidlHelper.addAttribute(sb, "size", mediaInfo.getSize());
                    } else if (transcodedSize != 0L) {
                        DidlHelper.addAttribute(sb, "size", transcodedSize);
                    }
                    if (mediaInfo.getDuration() != null) {
                        if (item.isResume()) {
                            long offset = item.getResume().getTimeOffset() / 1000L;
                            double duration = mediaInfo.getDuration() - (double)offset;
                            DidlHelper.addAttribute(sb, "duration", StringUtil.formatDLNADuration(duration));
                        } else if (item.getSplitRange().isEndLimitAvailable()) {
                            DidlHelper.addAttribute(sb, "duration", StringUtil.formatDLNADuration(item.getSplitRange().getDuration()));
                        } else {
                            DidlHelper.addAttribute(sb, "duration", mediaInfo.getDurationString());
                        }
                    }
                    if (defaultVideoTrack != null && defaultVideoTrack.getResolution() != null) {
                        if (item.isTranscoded() && (renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding())) {
                            DidlHelper.addAttribute(sb, "resolution", item.getResolutionForKeepAR(defaultVideoTrack.getWidth(), defaultVideoTrack.getHeight()));
                        } else {
                            DidlHelper.addAttribute(sb, "resolution", defaultVideoTrack.getResolution());
                        }
                    }
                    if (mediaInfo.getFrameRate() != null) {
                        DidlHelper.addAttribute(sb, "framerate", mediaInfo.getFrameRate());
                    }
                    DidlHelper.addAttribute(sb, "bitrate", mediaInfo.getRealVideoBitrate());
                    if (defaultAudioTrack != null) {
                        if (defaultAudioTrack.getNumberOfChannels() > 0) {
                            if (!item.isTranscoded()) {
                                DidlHelper.addAttribute(sb, "nrAudioChannels", defaultAudioTrack.getNumberOfChannels());
                            } else {
                                DidlHelper.addAttribute(sb, "nrAudioChannels", renderer.getUmsConfiguration().getAudioChannelCount());
                            }
                        }
                        if (defaultAudioTrack.getSampleRate() > 1) {
                            DidlHelper.addAttribute(sb, "sampleFrequency", defaultAudioTrack.getSampleRate());
                        }
                    }
                    if (defaultVideoTrack != null && defaultVideoTrack.getBitDepth() > 0) {
                        DidlHelper.addAttribute(sb, "colorDepth", defaultVideoTrack.getBitDepth());
                    }
                } else if (format != null && format.isImage()) {
                    if (mediaInfo != null && mediaInfo.isMediaParsed()) {
                        DidlHelper.addAttribute(sb, "size", mediaInfo.getSize());
                        if (mediaInfo.getImageInfo() != null && mediaInfo.getImageInfo().getResolution() != null) {
                            DidlHelper.addAttribute(sb, "resolution", mediaInfo.getImageInfo().getResolution());
                        }
                    } else {
                        DidlHelper.addAttribute(sb, "size", resource.length());
                    }
                } else if (format != null && format.isAudio()) {
                    if (mediaInfo != null && mediaInfo.isMediaParsed()) {
                        if (mediaInfo.getBitRate() > 0) {
                            DidlHelper.addAttribute(sb, "bitrate", mediaInfo.getBitRate());
                        }
                        if (mediaInfo.getDuration() != null && mediaInfo.getDuration() != 0.0) {
                            DidlHelper.addAttribute(sb, "duration", StringUtil.formatDLNADuration(mediaInfo.getDuration()));
                        }
                        int transcodeFrequency = -1;
                        int transcodeNumberOfChannels = -1;
                        if (defaultAudioTrack != null) {
                            if (!item.isTranscoded()) {
                                if (defaultAudioTrack.getSampleRate() > 1) {
                                    DidlHelper.addAttribute(sb, "sampleFrequency", defaultAudioTrack.getSampleRate());
                                }
                                if (defaultAudioTrack.getNumberOfChannels() > 0) {
                                    DidlHelper.addAttribute(sb, "nrAudioChannels", defaultAudioTrack.getNumberOfChannels());
                                }
                            } else {
                                if (renderer.getUmsConfiguration().isAudioResample()) {
                                    transcodeFrequency = renderer.isTranscodeAudioTo441() ? 44100 : 48000;
                                    transcodeNumberOfChannels = 2;
                                } else {
                                    transcodeFrequency = defaultAudioTrack.getSampleRate();
                                    transcodeNumberOfChannels = defaultAudioTrack.getNumberOfChannels();
                                }
                                if (transcodeFrequency > 0) {
                                    DidlHelper.addAttribute(sb, "sampleFrequency", transcodeFrequency);
                                }
                                if (transcodeNumberOfChannels > 0) {
                                    DidlHelper.addAttribute(sb, "nrAudioChannels", transcodeNumberOfChannels);
                                }
                            }
                            DidlHelper.addAttribute(sb, "bitsPerSample", defaultAudioTrack.getBitDepth());
                        }
                        if (!item.isTranscoded()) {
                            if (mediaInfo.getSize() != 0L) {
                                DidlHelper.addAttribute(sb, "size", mediaInfo.getSize());
                            }
                        } else if (defaultAudioTrack != null && mediaInfo.getDurationInSeconds() > 0.0 && transcodeFrequency > 0 && transcodeNumberOfChannels > 0) {
                            int finalSize = (int)(mediaInfo.getDurationInSeconds() * (double)transcodeFrequency * 2.0 * (double)transcodeNumberOfChannels);
                            LOGGER.trace("Calculated transcoded size for {}: {}", (Object)resource.getFileName(), (Object)finalSize);
                            DidlHelper.addAttribute(sb, "size", finalSize);
                        } else if (mediaInfo.getSize() > 0L) {
                            LOGGER.trace("Could not calculate transcoded size for {}, using file size: {}", (Object)resource.getFileName(), (Object)mediaInfo.getSize());
                            DidlHelper.addAttribute(sb, "size", mediaInfo.getSize());
                        }
                    } else {
                        DidlHelper.addAttribute(sb, "size", resource.length());
                    }
                } else {
                    DidlHelper.addAttribute(sb, "size", 0x7FFFFFFF7FFFFFFFL);
                    DidlHelper.addAttribute(sb, "duration", "09:59:59");
                    DidlHelper.addAttribute(sb, "bitrate", "1000000");
                }
                DidlHelper.endTag(sb);
                String transcodedExtension = "";
                if (encodingFormat != null && mediaInfo != null) {
                    if (mediaInfo.isVideo()) {
                        transcodedExtension = renderer.getCustomFFmpegOptions().contains("-f avi") ? "_transcoded_to.avi" : (renderer.getCustomFFmpegOptions().contains("-f flv") ? "_transcoded_to.flv" : (renderer.getCustomFFmpegOptions().contains("-f matroska") ? "_transcoded_to.mkv" : (renderer.getCustomFFmpegOptions().contains("-f mov") ? "_transcoded_to.mov" : (renderer.getCustomFFmpegOptions().contains("-f webm") ? "_transcoded_to.webm" : (encodingFormat.isTranscodeToHLS() ? "_transcoded_to.m3u8" : (encodingFormat.isTranscodeToMPEGTS() ? "_transcoded_to.ts" : (encodingFormat.isTranscodeToMP4() ? "_transcoded_to.mp4" : (encodingFormat.isTranscodeToWMV() && !xbox360 ? "_transcoded_to.wmv" : "_transcoded_to.mpg"))))))));
                    } else if (mediaInfo.isAudio()) {
                        transcodedExtension = renderer.getCustomFFmpegAudioOptions().contains("-f mp3") ? "_transcoded_to.mp3" : (renderer.getCustomFFmpegAudioOptions().contains("-f wav") ? "_transcoded_to.wav" : (renderer.getCustomFFmpegAudioOptions().contains("-f s16be") ? "_transcoded_to.pcm" : (encodingFormat.isTranscodeToMP3() ? "_transcoded_to.mp3" : (encodingFormat.isTranscodeToWAV() ? "_transcoded_to.wav" : "_transcoded_to.pcm"))));
                    }
                }
                sb.append(item.getMediaURL()).append(transcodedExtension);
                DidlHelper.closeTag(sb, "res");
            }
            if (mediaInfo != null && audioMetadata != null && mediaInfo.isAudio()) {
                DidlHelper.openTag(sb, "desc");
                DidlHelper.addAttribute(sb, "id", "2");
                DidlHelper.addAttribute(sb, "nameSpace", "http://ums/tags");
                DidlHelper.addAttribute(sb, "type", "ums-tags");
                DidlHelper.endTag(sb);
                DidlHelper.addXMLTagAndAttribute(sb, "musicbrainztrackid", audioMetadata.getMbidTrack());
                DidlHelper.addXMLTagAndAttribute(sb, "musicbrainzreleaseid", audioMetadata.getMbidRecord());
                DidlHelper.addXMLTagAndAttribute(sb, "audiotrackid", Integer.toString(audioMetadata.getAudiotrackId()));
                if (audioMetadata.getDisc() > 0) {
                    DidlHelper.addXMLTagAndAttribute(sb, "numberOfThisDisc", Integer.toString(audioMetadata.getDisc()));
                }
                if (audioMetadata.getRating() != null) {
                    DidlHelper.addXMLTagAndAttribute(sb, "rating", Integer.toString(audioMetadata.getRating()));
                }
                DidlHelper.closeTag(sb, "desc");
            }
            if (subsAreValidForStreaming && mediaSubtitle != null) {
                String subsURL = resource.getSubsURL(mediaSubtitle);
                if (renderer.useClosedCaption()) {
                    DidlHelper.openTag(sb, "sec:CaptionInfoEx");
                    DidlHelper.addAttribute(sb, "sec:type", "srt");
                    DidlHelper.endTag(sb);
                    sb.append(subsURL);
                    DidlHelper.closeTag(sb, "sec:CaptionInfoEx");
                    LOGGER.trace("Network debugger: sec:CaptionInfoEx: sec:type=srt " + subsURL);
                } else if (renderer.offerSubtitlesAsResource()) {
                    DidlHelper.openTag(sb, "res");
                    String subtitlesFormat = mediaSubtitle.getType().getExtension();
                    if (StringUtils.isBlank(subtitlesFormat)) {
                        subtitlesFormat = "plain";
                    }
                    DidlHelper.addAttribute(sb, "protocolInfo", "http-get:*:text/" + subtitlesFormat + ":*");
                    DidlHelper.endTag(sb);
                    sb.append(subsURL);
                    DidlHelper.closeTag(sb, "res");
                    LOGGER.trace("Network debugger: http-get:*:text/" + subtitlesFormat + ":*" + subsURL);
                }
            }
        }
        if (resource.getPrimaryResource() != null && mediaInfo != null && !mediaInfo.isSecondaryFormatValid()) {
            uclass = "dummy";
        } else if (container != null) {
            if (resource instanceof PlaylistFolder) {
                uclass = "object.container.playlistContainer";
            } else if (resource instanceof VirtualFolderDbId) {
                VirtualFolderDbId virtualFolderDbId = (VirtualFolderDbId)resource;
                uclass = virtualFolderDbId.getMediaTypeUclass();
            } else {
                uclass = "object.container.storageFolder";
            }
            if (xbox360 && resource.getFakeParentId() != null) {
                uclass = switch (resource.getFakeParentId()) {
                    case "7" -> "object.container.album.musicAlbum";
                    case "6" -> "object.container.person.musicArtist";
                    case "5" -> "object.container.genre.musicGenre";
                    case "F" -> "object.container.playlistContainer";
                    default -> uclass;
                };
            }
        } else {
            uclass = mediaType == MediaType.IMAGE || mediaType == MediaType.UNKNOWN && format != null && format.isImage() ? "object.item.imageItem.photo" : (mediaType == MediaType.AUDIO || mediaType == MediaType.UNKNOWN && format != null && format.isAudio() ? "object.item.audioItem.musicTrack" : (mediaInfo != null && mediaInfo.hasVideoMetadata() && (mediaInfo.getVideoMetadata().isTvEpisode() || mediaInfo.getVideoMetadata().getYear() != null) ? "object.item.videoItem.movie" : "object.item.videoItem"));
        }
        if (mediaType != MediaType.IMAGE && (container == null || uclass.startsWith("object.container.album") || renderer.isSendFolderThumbnails() || resource instanceof DVDISOFile)) {
            DidlHelper.appendThumbnail(resource, sb, mediaType, uclass.startsWith("object.container.album"));
        }
        DidlHelper.addXMLTagAndAttribute(sb, "upnp:class", uclass);
        if (item != null) {
            DidlHelper.closeTag(sb, "item");
        } else {
            DidlHelper.closeTag(sb, "container");
        }
        return sb.toString();
    }

    private static void appendImage(StoreItem item, StringBuilder sb) {
        Renderer renderer = item.getDefaultRenderer();
        MediaInfo mediaInfo = item.getMediaInfo();
        ImageInfo imageInfo = mediaInfo != null ? mediaInfo.getImageInfo() : null;
        ImageInfo thumbnailImageInf = null;
        if (item.getThumbnailImageInfo() != null) {
            thumbnailImageInf = item.getThumbnailImageInfo();
        } else if (mediaInfo != null && mediaInfo.getThumbnail() != null && mediaInfo.getThumbnail().getImageInfo() != null) {
            thumbnailImageInf = mediaInfo.getThumbnail().getImageInfo();
        }
        boolean includeGIF = imageInfo != null && imageInfo.getFormat() == ImageFormat.GIF && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.GIF_LRG, renderer);
        ArrayList<DLNAImageResElement> resElements = new ArrayList<DLNAImageResElement>();
        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_TN, thumbnailImageInf != null ? thumbnailImageInf : imageInfo, true));
        if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_TN, renderer)) {
            resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_TN, thumbnailImageInf != null ? thumbnailImageInf : imageInfo, true));
        }
        if (imageInfo != null) {
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_RES_H_V, renderer) && imageInfo.getWidth() > 0 && imageInfo.getHeight() > 0) {
                DLNAImageProfile exactResolution = DLNAImageProfile.createJPEG_RES_H_V(imageInfo.getWidth(), imageInfo.getHeight());
                resElements.add(new DLNAImageResElement(exactResolution, imageInfo, exactResolution.useThumbnailSource(imageInfo, thumbnailImageInf)));
            }
            resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_SM, imageInfo, DLNAImageProfile.JPEG_SM.useThumbnailSource(imageInfo, thumbnailImageInf)));
            if (!DLNAImageProfile.PNG_TN.isResolutionCorrect(imageInfo)) {
                if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_LRG, renderer)) {
                    resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_LRG, imageInfo, DLNAImageProfile.PNG_LRG.useThumbnailSource(imageInfo, thumbnailImageInf)));
                }
                if (includeGIF) {
                    resElements.add(new DLNAImageResElement(DLNAImageProfile.GIF_LRG, imageInfo, DLNAImageProfile.GIF_LRG.useThumbnailSource(imageInfo, thumbnailImageInf)));
                }
                if (!DLNAImageProfile.JPEG_SM.isResolutionCorrect(imageInfo)) {
                    if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_MED, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_MED, imageInfo, DLNAImageProfile.JPEG_MED.useThumbnailSource(imageInfo, thumbnailImageInf)));
                    }
                    if (!DLNAImageProfile.JPEG_MED.isResolutionCorrect(imageInfo) && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_LRG, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_LRG, imageInfo, DLNAImageProfile.JPEG_LRG.useThumbnailSource(imageInfo, thumbnailImageInf)));
                    }
                }
            }
        } else {
            resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_SM, null, false));
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_LRG, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_LRG, null, false));
            }
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_LRG, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_LRG, null, false));
            }
            LOGGER.debug("Warning: Image \"{}\" wasn't parsed when DIDL-Lite was generated", (Object)item.getName());
        }
        Collections.sort(resElements, DLNAImageResElement.getComparator(imageInfo != null ? imageInfo.getFormat() : ImageFormat.JPEG));
        for (DLNAImageResElement resElement : resElements) {
            DidlHelper.addImageResource(item, sb, resElement);
        }
        for (DLNAImageResElement resElement : resElements) {
            switch (resElement.getProfile().toInt()) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    DidlHelper.addAlbumArt(item, sb, resElement.getProfile());
                }
            }
        }
    }

    private static void appendThumbnail(StoreResource resource, StringBuilder sb, MediaType mediaType, boolean isAlbum) {
        Renderer renderer = resource.getDefaultRenderer();
        MediaInfo mediaInfo = resource.getMediaInfo();
        if (MediaType.IMAGE != mediaType) {
            ImageInfo imageInfo = null;
            if (resource.getThumbnailImageInfo() != null) {
                imageInfo = resource.getThumbnailImageInfo();
            } else if (mediaInfo != null && mediaInfo.getThumbnail() != null && mediaInfo.getThumbnail().getImageInfo() != null) {
                imageInfo = mediaInfo.getThumbnail().getImageInfo();
            }
            boolean includeGIF = imageInfo != null && imageInfo.getFormat() == ImageFormat.GIF && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.GIF_LRG, renderer);
            ArrayList<DLNAImageResElement> resElements = new ArrayList<DLNAImageResElement>();
            resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_TN, imageInfo, true));
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_SM, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_SM, imageInfo, true));
            }
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_TN, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_TN, imageInfo, true));
            }
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_LRG, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_LRG, imageInfo, true));
            }
            if (imageInfo != null) {
                if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_RES_H_V, renderer) && imageInfo.getWidth() > 0 && imageInfo.getHeight() > 0) {
                    DLNAImageProfile exactResolution = DLNAImageProfile.createJPEG_RES_H_V(imageInfo.getWidth(), imageInfo.getHeight());
                    resElements.add(new DLNAImageResElement(exactResolution, imageInfo, true));
                }
                if (includeGIF) {
                    resElements.add(new DLNAImageResElement(DLNAImageProfile.GIF_LRG, imageInfo, true));
                }
                if (!DLNAImageProfile.JPEG_SM.isResolutionCorrect(imageInfo)) {
                    if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_MED, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_MED, imageInfo, true));
                    }
                    if (!DLNAImageProfile.JPEG_MED.isResolutionCorrect(imageInfo) && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_LRG, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_LRG, imageInfo, true));
                    }
                }
            }
            Collections.sort(resElements, DLNAImageResElement.getComparator(imageInfo != null ? imageInfo.getFormat() : ImageFormat.JPEG));
            for (DLNAImageResElement resElement : resElements) {
                DidlHelper.addImageResource(resource, sb, resElement);
            }
            if (isAlbum || renderer.needAlbumArtHack()) {
                for (DLNAImageResElement resElement : resElements) {
                    switch (resElement.getProfile().toInt()) {
                        case 1: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            DidlHelper.addAlbumArt(resource, sb, resElement.getProfile());
                        }
                    }
                }
            }
        }
    }

    private static void addImageResource(StoreResource resource, StringBuilder sb, DLNAImageResElement resElement) {
        if (resource == null) {
            throw new NullPointerException("resource cannot be null");
        }
        if (resElement == null) {
            throw new NullPointerException("resElement cannot be null");
        }
        if (!resElement.isResolutionKnown() && DLNAImageProfile.JPEG_RES_H_V.equals(resElement.getProfile())) {
            throw new IllegalArgumentException("Resolution cannot be unknown for DLNAImageProfile.JPEG_RES_H_V");
        }
        Object url = null;
        if (resElement.isThumbnail()) {
            url = resource.getThumbnailURL(resElement.getProfile());
        } else if (resource instanceof StoreItem) {
            StoreItem item = (StoreItem)resource;
            url = item.getMediaURL((String)(DLNAImageProfile.JPEG_RES_H_V.equals(resElement.getProfile()) ? "JPEG_RES" + resElement.getWidth() + "x" + resElement.getHeight() : resElement.getProfile().toString()) + "_");
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            Object ciFlag = resElement.getCiFlag() == null || resElement.getCiFlag() == 0 ? "" : ";DLNA.ORG_CI=" + resElement.getCiFlag().toString();
            DidlHelper.openTag(sb, "res");
            if (resElement.getSize() != null && resElement.getSize() > 0L) {
                DidlHelper.addAttribute(sb, "size", resElement.getSize());
            }
            if (resElement.isResolutionKnown()) {
                DidlHelper.addAttribute(sb, "resolution", Integer.toString(resElement.getWidth()) + "x" + Integer.toString(resElement.getHeight()));
            }
            DidlHelper.addAttribute(sb, "xmlns:dlna", "urn:schemas-dlna-org:metadata-1-0/");
            DidlHelper.addAttribute(sb, "protocolInfo", "http-get:*:" + String.valueOf(resElement.getProfile().getMimeType()) + ":DLNA.ORG_PN=" + String.valueOf(resElement.getProfile()) + (String)ciFlag + ";DLNA.ORG_FLAGS=00900000000000000000000000000000");
            DidlHelper.endTag(sb);
            String updateId = MediaStoreIds.getObjectUpdateIdAsString(resource.getLongId());
            if (updateId != null && url != null) {
                url = ((String)url).contains("?") ? (String)url + "&update=" + updateId : (String)url + "?update=" + updateId;
            }
            sb.append((String)url);
            DidlHelper.closeTag(sb, "res");
        }
    }

    private static void addAlbumArt(StoreResource resource, StringBuilder sb, DLNAImageProfile thumbnailProfile) {
        String rendererProfile = resource.getDefaultRenderer().getAlbumArtProfile();
        if (StringUtils.isNotBlank(rendererProfile) && !rendererProfile.equalsIgnoreCase(thumbnailProfile.toString())) {
            return;
        }
        Object albumArtURL = resource.getThumbnailURL(thumbnailProfile);
        if (StringUtils.isNotBlank((CharSequence)albumArtURL)) {
            String updateId = MediaStoreIds.getObjectUpdateIdAsString(resource.getLongId());
            if (updateId != null && albumArtURL != null) {
                albumArtURL = ((String)albumArtURL).contains("?") ? (String)albumArtURL + "&update=" + updateId : (String)albumArtURL + "?update=" + updateId;
            }
            DidlHelper.openTag(sb, "upnp:albumArtURI");
            DidlHelper.addAttribute(sb, "dlna:profileID", thumbnailProfile);
            DidlHelper.addAttribute(sb, "xmlns:dlna", "urn:schemas-dlna-org:metadata-1-0/");
            DidlHelper.endTag(sb);
            sb.append((String)albumArtURL);
            DidlHelper.closeTag(sb, "upnp:albumArtURI");
        }
    }

    private static void addBookmark(StoreResource resource, StringBuilder sb, String title) {
        if (resource.getMediaStatus() != null) {
            LOGGER.debug("Setting bookmark for {} => {}", (Object)title, (Object)resource.getMediaStatus().getBookmark());
            DidlHelper.addXMLTagAndAttribute(sb, "sec:dcmInfo", DidlHelper.encodeXML(String.format("CREATIONDATE=0,FOLDER=%s,BM=%d", title, resource.getMediaStatus().getBookmark())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatDate(Date data) {
        SimpleDateFormat simpleDateFormat = DIDL_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DIDL_DATE_FORMAT.format(data);
        }
    }

    private static void openTag(StringBuilder sb, String tag) {
        sb.append("&lt;");
        sb.append(tag);
    }

    private static void endTag(StringBuilder sb) {
        sb.append("&gt;");
    }

    private static void closeTag(StringBuilder sb, String tag) {
        sb.append("&lt;/");
        sb.append(tag);
        sb.append("&gt;");
    }

    private static void addAttribute(StringBuilder sb, String attribute, Object value) {
        sb.append(' ');
        sb.append(attribute);
        sb.append("=\"");
        sb.append(value);
        sb.append("\"");
    }

    private static void addXMLTagAndAttribute(StringBuilder sb, String tag, Object value) {
        sb.append("&lt;");
        sb.append(tag);
        sb.append("&gt;");
        sb.append(value);
        sb.append("&lt;/");
        sb.append(tag);
        sb.append("&gt;");
    }

    private static void addXMLTagAndAttributeWithRole(StringBuilder sb, String tag, Object value) {
        String myTagWithoutRole = tag.split(" ")[0];
        sb.append("&lt;");
        sb.append(tag);
        sb.append("&gt;");
        sb.append(value);
        sb.append("&lt;/");
        sb.append(myTagWithoutRole);
        sb.append("&gt;");
    }

    private static String encodeXML(String s) {
        s = s.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        s = s.replace("&", "&amp;");
        return s;
    }
}

