/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.dlna.protocolinfo.DLNAOrgProfileName;
import net.pms.dlna.protocolinfo.KnownDLNAOrgProfileName;
import net.pms.dlna.protocolinfo.MimeType;
import net.pms.dlna.protocolinfo.ProtocolInfo;
import net.pms.image.ColorSpaceType;
import net.pms.image.ExifInfo;
import net.pms.image.GIFInfo;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.image.JPEGInfo;
import net.pms.image.JPEGSubsamplingNotation;
import net.pms.image.PNGInfo;
import org.jupnp.support.model.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAImageProfile
implements Comparable<DLNAImageProfile>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DLNAImageProfile.class);
    public static final MimeType MIMETYPE_GIF = new MimeType("image", "gif");
    public static final MimeType MIMETYPE_JPEG = new MimeType("image", "jpeg");
    public static final MimeType MIMETYPE_PNG = new MimeType("image", "png");
    public static final int GIF_LRG_INT = 1;
    public static final int JPEG_LRG_INT = 2;
    public static final int JPEG_MED_INT = 3;
    public static final int JPEG_RES_H_V_INT = 4;
    public static final int JPEG_SM_INT = 5;
    public static final int JPEG_TN_INT = 6;
    public static final int PNG_LRG_INT = 7;
    public static final int PNG_TN_INT = 8;
    public static final String GIF_LRG_STRING = "GIF_LRG";
    public static final String JPEG_LRG_STRING = "JPEG_LRG";
    public static final String JPEG_MED_STRING = "JPEG_MED";
    public static final String JPEG_RES_H_V_STRING = "JPEG_RES_H_V";
    public static final String JPEG_SM_STRING = "JPEG_SM";
    public static final String JPEG_TN_STRING = "JPEG_TN";
    public static final String PNG_LRG_STRING = "PNG_LRG";
    public static final String PNG_TN_STRING = "PNG_TN";
    public static final DLNAImageProfile GIF_LRG = new DLNAImageProfile(1, "GIF_LRG", 1600, 1200, null);
    public static final DLNAImageProfile JPEG_LRG = new DLNAImageProfile(2, "JPEG_LRG", 4096, 4096, null);
    public static final DLNAImageProfile JPEG_MED = new DLNAImageProfile(3, "JPEG_MED", 1024, 768, null);
    public static final DLNAImageProfile JPEG_RES_H_V = new DLNAImageProfile(4, "JPEG_RES_H_V", -1, -1, null);
    public static final DLNAImageProfile JPEG_SM = new DLNAImageProfile(5, "JPEG_SM", 640, 480, null);
    public static final DLNAImageProfile JPEG_TN = new DLNAImageProfile(6, "JPEG_TN", 160, 160, null);
    public static final DLNAImageProfile PNG_LRG = new DLNAImageProfile(7, "PNG_LRG", 4096, 4096, null);
    public static final DLNAImageProfile PNG_TN = new DLNAImageProfile(8, "PNG_TN", 160, 160, null);
    protected final int imageProfileInt;
    protected final String imageProfileStr;
    protected final MimeType mimeType;
    private final int horizontal;
    private final int vertical;

    private DLNAImageProfile(int imageProfileInt, String imageProfileStr, int horizontal, int vertical, MimeType mimeType) {
        this.imageProfileInt = imageProfileInt;
        this.imageProfileStr = imageProfileStr;
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.mimeType = mimeType;
    }

    public int toInt() {
        return this.imageProfileInt;
    }

    public String toString() {
        return this.imageProfileStr;
    }

    public String getDefaultExtension() {
        switch (this.imageProfileInt) {
            case 1: {
                return "gif";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return "jpg";
            }
            case 7: 
            case 8: {
                return "png";
            }
        }
        throw new IllegalStateException("Profile value " + this.imageProfileInt + "is not implemented in DLNAImageProfile.getDefaultExtension()");
    }

    public ImageFormat getFormat() {
        switch (this.imageProfileInt) {
            case 1: {
                return ImageFormat.GIF;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return ImageFormat.JPEG;
            }
            case 7: 
            case 8: {
                return ImageFormat.PNG;
            }
        }
        throw new IllegalStateException("Profile is missing from switch statement");
    }

    public MimeType getMimeType() {
        if (this.mimeType != null) {
            return this.mimeType;
        }
        return this.getDefaultMimeType();
    }

    public MimeType getDefaultMimeType() {
        switch (this.getFormat()) {
            case GIF: {
                return MIMETYPE_GIF;
            }
            case JPEG: {
                return MIMETYPE_JPEG;
            }
            case PNG: {
                return MIMETYPE_PNG;
            }
        }
        throw new IllegalStateException("Format is missing from switch statement");
    }

    public String getMimeTypeString() {
        return this.getMimeType().toStringWithoutParameters();
    }

    public int getMaxWidth() {
        return this.horizontal;
    }

    public int getH() {
        return this.horizontal;
    }

    public int getMaxHeight() {
        return this.vertical;
    }

    public int getV() {
        return this.vertical;
    }

    public Dimension getMaxResolution() {
        if (this.horizontal >= 0 && this.vertical >= 0) {
            return new Dimension(this.horizontal, this.vertical);
        }
        return new Dimension();
    }

    public boolean useThumbnailSource(ImageInfo imageInfo, ImageInfo thumbnailImageInfo) {
        boolean thumbIsSmaller;
        if (JPEG_TN.equals(this) || PNG_TN.equals(this)) {
            return true;
        }
        if (imageInfo == null || imageInfo.getWidth() < 1 || imageInfo.getHeight() < 1 || thumbnailImageInfo == null || thumbnailImageInfo.getWidth() < 1 || thumbnailImageInfo.getHeight() < 1) {
            return false;
        }
        boolean bl = thumbIsSmaller = thumbnailImageInfo.getWidth() < imageInfo.getWidth() || thumbnailImageInfo.getHeight() < imageInfo.getHeight();
        if (!thumbIsSmaller) {
            return this.getFormat() == thumbnailImageInfo.getFormat() || this.getFormat() != imageInfo.getFormat();
        }
        return this.getMaxWidth() <= thumbnailImageInfo.getWidth() && this.getMaxHeight() <= thumbnailImageInfo.getHeight();
    }

    public static DLNAImageProfile createJPEG_RES_H_V(int horizontal, int vertical) {
        return new DLNAImageProfile(4, "JPEG_RES_" + Integer.toString(horizontal) + "_" + Integer.toString(vertical), horizontal, vertical, null);
    }

    public static DLNAImageProfile createJPEG_RES_H_V(int horizontal, int vertical, MimeType mimeType) {
        return new DLNAImageProfile(4, "JPEG_RES_" + Integer.toString(horizontal) + "_" + Integer.toString(vertical), horizontal, vertical, mimeType);
    }

    public static DLNAImageProfile toDLNAImageProfile(int value) {
        return DLNAImageProfile.toDLNAImageProfile(value, null, null);
    }

    public static DLNAImageProfile toDLNAImageProfile(int value, MimeType mimeType) {
        return DLNAImageProfile.toDLNAImageProfile(value, null, mimeType);
    }

    public static DLNAImageProfile toDLNAImageProfile(int value, DLNAImageProfile defaultImageProfile) {
        return DLNAImageProfile.toDLNAImageProfile(value, defaultImageProfile, null);
    }

    public static DLNAImageProfile toDLNAImageProfile(int value, DLNAImageProfile defaultImageProfile, MimeType mimeType) {
        return switch (value) {
            case 1 -> {
                if (mimeType == null) {
                    yield GIF_LRG;
                }
                yield new DLNAImageProfile(1, GIF_LRG_STRING, 1600, 1200, mimeType);
            }
            case 2 -> {
                if (mimeType == null) {
                    yield JPEG_LRG;
                }
                yield new DLNAImageProfile(2, JPEG_LRG_STRING, 4096, 4096, mimeType);
            }
            case 3 -> {
                if (mimeType == null) {
                    yield JPEG_MED;
                }
                yield new DLNAImageProfile(3, JPEG_MED_STRING, 1024, 768, mimeType);
            }
            case 4 -> {
                if (mimeType == null) {
                    yield JPEG_RES_H_V;
                }
                yield new DLNAImageProfile(4, JPEG_RES_H_V_STRING, -1, -1, mimeType);
            }
            case 5 -> {
                if (mimeType == null) {
                    yield JPEG_SM;
                }
                yield new DLNAImageProfile(5, JPEG_SM_STRING, 640, 480, mimeType);
            }
            case 6 -> {
                if (mimeType == null) {
                    yield JPEG_TN;
                }
                yield new DLNAImageProfile(6, JPEG_TN_STRING, 160, 160, mimeType);
            }
            case 7 -> {
                if (mimeType == null) {
                    yield PNG_LRG;
                }
                yield new DLNAImageProfile(7, PNG_LRG_STRING, 4096, 4096, mimeType);
            }
            case 8 -> {
                if (mimeType == null) {
                    yield PNG_TN;
                }
                yield new DLNAImageProfile(8, PNG_TN_STRING, 160, 160, mimeType);
            }
            default -> defaultImageProfile;
        };
    }

    public static DLNAImageProfile toDLNAImageProfile(String argument) {
        return DLNAImageProfile.toDLNAImageProfile(argument, null, null);
    }

    public static DLNAImageProfile toDLNAImageProfile(String argument, MimeType mimeType) {
        return DLNAImageProfile.toDLNAImageProfile(argument, null, mimeType);
    }

    public static DLNAImageProfile toDLNAImageProfile(String argument, DLNAImageProfile defaultImageProfile) {
        if (argument == null) {
            return defaultImageProfile;
        }
        return DLNAImageProfile.toDLNAImageProfile(argument, defaultImageProfile, null);
    }

    public static DLNAImageProfile toDLNAImageProfile(String argument, DLNAImageProfile defaultImageProfile, MimeType mimeType) {
        Matcher matcher;
        if (argument == null) {
            return defaultImageProfile;
        }
        switch (argument = argument.toUpperCase(Locale.ROOT)) {
            case "GIF_LRG": {
                return mimeType == null ? GIF_LRG : new DLNAImageProfile(1, GIF_LRG_STRING, 1600, 1200, mimeType);
            }
            case "JPEG_LRG": {
                return mimeType == null ? JPEG_LRG : new DLNAImageProfile(2, JPEG_LRG_STRING, 4096, 4096, mimeType);
            }
            case "JPEG_MED": {
                return mimeType == null ? JPEG_MED : new DLNAImageProfile(3, JPEG_MED_STRING, 1024, 768, mimeType);
            }
            case "JPEG_RES_H_V": {
                return mimeType == null ? JPEG_RES_H_V : new DLNAImageProfile(4, JPEG_RES_H_V_STRING, -1, -1, mimeType);
            }
            case "JPEG_SM": {
                return mimeType == null ? JPEG_SM : new DLNAImageProfile(5, JPEG_SM_STRING, 640, 480, mimeType);
            }
            case "JPEG_TN": {
                return mimeType == null ? JPEG_TN : new DLNAImageProfile(6, JPEG_TN_STRING, 160, 160, mimeType);
            }
            case "PNG_LRG": {
                return mimeType == null ? PNG_LRG : new DLNAImageProfile(7, PNG_LRG_STRING, 4096, 4096, mimeType);
            }
            case "PNG_TN": {
                return mimeType == null ? PNG_TN : new DLNAImageProfile(8, PNG_TN_STRING, 160, 160, mimeType);
            }
        }
        if (argument.startsWith("JPEG_RES") && (matcher = Pattern.compile("^JPEG_RES_?(\\d+)[X_](\\d+)").matcher(argument)).find()) {
            return new DLNAImageProfile(4, "JPEG_RES_" + matcher.group(1) + "_" + matcher.group(2), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), mimeType);
        }
        return defaultImageProfile;
    }

    public static Set<DLNAImageProfile> toDLNAImageProfiles(ProtocolInfo protocolInfo) {
        HashSet<DLNAImageProfile> result = new HashSet<DLNAImageProfile>();
        if (protocolInfo != null && (protocolInfo.getProtocol() == Protocol.HTTP_GET || protocolInfo.getProtocol() == Protocol.ALL) && protocolInfo.getMimeType() != null && (protocolInfo.getMimeType().isAnyType() || "image".equals(protocolInfo.getMimeType().getType().trim().toLowerCase(Locale.ROOT)))) {
            DLNAOrgProfileName dlnaProfileName = protocolInfo.getDLNAProfileName();
            if (dlnaProfileName != null) {
                if (dlnaProfileName instanceof KnownDLNAOrgProfileName) {
                    KnownDLNAOrgProfileName knownDLNAOrgProfileName = (KnownDLNAOrgProfileName)dlnaProfileName;
                    switch (knownDLNAOrgProfileName) {
                        case GIF_LRG: {
                            result.add(GIF_LRG);
                            break;
                        }
                        case JPEG_LRG: {
                            result.add(JPEG_LRG);
                            break;
                        }
                        case JPEG_MED: {
                            result.add(JPEG_MED);
                            break;
                        }
                        case JPEG_RES_H_V: {
                            result.add(JPEG_RES_H_V);
                            break;
                        }
                        case JPEG_SM: {
                            result.add(JPEG_SM);
                            break;
                        }
                        case JPEG_TN: {
                            result.add(JPEG_TN);
                            break;
                        }
                        case PNG_LRG: {
                            result.add(PNG_LRG);
                            break;
                        }
                        case PNG_TN: {
                            result.add(PNG_TN);
                            break;
                        }
                    }
                } else {
                    DLNAImageProfile profile = DLNAImageProfile.toDLNAImageProfile(dlnaProfileName.getValue(), null, protocolInfo.getMimeType());
                    if (profile != null) {
                        result.add(profile);
                        LOGGER.trace("DLNAImageProfile parsed \"{}\" as {}", (Object)protocolInfo, (Object)profile);
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("DLNAImageProfile was unable to parse DLNA profile from \"{}\"", (Object)protocolInfo);
                    }
                }
                return result;
            }
            if (protocolInfo.getProfileName() != null) {
                return result;
            }
        }
        return result;
    }

    protected static void checkGIF(ImageInfo imageInfo, InternalComplianceResult complianceResult) {
        if (imageInfo == null || imageInfo.getFormat() != ImageFormat.GIF || !(imageInfo instanceof GIFInfo)) {
            return;
        }
        complianceResult.colorsCorrect = true;
        GIFInfo gifInfo = (GIFInfo)imageInfo;
        complianceResult.formatCorrect = "89a".equals(gifInfo.getFormatVersion());
        if (!complianceResult.formatCorrect) {
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("GIF DLNA compliance failed with wrong GIF version \"%s\"", gifInfo.getFormatVersion()));
            } else {
                complianceResult.failures.add("GIF version");
            }
        }
    }

    protected static void checkJPEG(ImageInfo imageInfo, InternalComplianceResult complianceResult) {
        if (imageInfo == null || imageInfo.getFormat() != ImageFormat.JPEG || !(imageInfo instanceof JPEGInfo)) {
            return;
        }
        JPEGInfo jpegInfo = (JPEGInfo)imageInfo;
        boolean bl = complianceResult.colorsCorrect = jpegInfo.getColorSpaceType() == ColorSpaceType.TYPE_GRAY || jpegInfo.getColorSpaceType() == ColorSpaceType.TYPE_RGB || jpegInfo.getColorSpaceType() == ColorSpaceType.TYPE_YCbCr;
        if (!complianceResult.colorsCorrect) {
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("JPEG DLNA compliance failed with illegal color space \"%s\"", new Object[]{jpegInfo.getColorSpaceType()}));
            } else {
                complianceResult.failures.add("color space");
            }
        }
        if (jpegInfo.getExifColorSpace() != null && jpegInfo.getExifColorSpace() != ExifInfo.ExifColorSpace.SRGB && jpegInfo.getExifColorSpace() != ExifInfo.ExifColorSpace.UNCALIBRATED) {
            complianceResult.colorsCorrect = false;
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("JPEG DLNA compliance failed with illegal Exif color space \"%s\"", new Object[]{jpegInfo.getExifColorSpace()}));
            } else {
                complianceResult.failures.add("Exif color space");
            }
        }
        boolean bl2 = complianceResult.formatCorrect = jpegInfo.getJFIFVersion() >= 258 || jpegInfo.getExifVersion() >= 100;
        if (!complianceResult.formatCorrect && LOGGER.isTraceEnabled()) {
            String exifVersion;
            String jfifVersion;
            String string = jfifVersion = jpegInfo.getJFIFVersion() == Integer.MIN_VALUE ? null : Double.toHexString((double)jpegInfo.getJFIFVersion() / 256.0);
            if (jfifVersion != null) {
                jfifVersion = jfifVersion.replaceFirst("0x", "").replaceFirst("p-?\\d*", "");
            }
            String string2 = exifVersion = jpegInfo.getExifVersion() == Integer.MIN_VALUE ? null : Double.toString((double)jpegInfo.getExifVersion() / 100.0);
            if (jfifVersion == null && exifVersion == null) {
                if (LOGGER.isTraceEnabled()) {
                    complianceResult.failures.add("JPEG DLNA compliance failed with missing Exif- and JFIF version");
                } else {
                    complianceResult.failures.add("missing version information");
                }
            } else if (jfifVersion == null) {
                if (LOGGER.isTraceEnabled()) {
                    complianceResult.failures.add(String.format("JPEG DLNA compliance failed with too low Exif version \"%s\"", exifVersion));
                } else {
                    complianceResult.failures.add("Exif version");
                }
            } else if (exifVersion == null) {
                if (LOGGER.isTraceEnabled()) {
                    complianceResult.failures.add(String.format("JPEG DLNA compliance failed with too low JFIF version \"%s\"", jfifVersion));
                } else {
                    complianceResult.failures.add("JFIF version");
                }
            } else if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("JPEG DLNA compliance failed with too low Exif version \"%s\" and JFIF version \"%s\"", exifVersion, jfifVersion));
            } else {
                complianceResult.failures.add("Exif and JFIF version");
            }
        }
        if (jpegInfo.getCompressionType() != JPEGInfo.CompressionType.BASELINE_HUFFMAN) {
            complianceResult.formatCorrect = false;
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("JPEG DLNA compliance failed with illegal compression type \"%s\"", new Object[]{jpegInfo.getCompressionType()}));
            } else {
                complianceResult.failures.add("compression type");
            }
        }
        if (jpegInfo.getBitDepth() != 8) {
            complianceResult.formatCorrect = false;
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("JPEG DLNA compliance failed with illegal bit depth \"%d\"", jpegInfo.getBitDepth()));
            } else {
                complianceResult.failures.add("bit depth");
            }
        }
        if (jpegInfo.getNumComponents() != 3 && jpegInfo.getNumComponents() != 1) {
            complianceResult.formatCorrect = false;
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("JPEG DLNA compliance failed with illegal number of components \"%d\"", jpegInfo.getNumComponents()));
            } else {
                complianceResult.failures.add("number of components");
            }
        }
        if (!jpegInfo.isTypicalHuffman()) {
            complianceResult.formatCorrect = false;
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add("JPEG DLNA compliance failed with non-typical Huffman tables");
            } else {
                complianceResult.failures.add("optimized");
            }
        }
        if (jpegInfo.getNumComponents() == 3 && !new JPEGSubsamplingNotation(4, 2, 2).equals(jpegInfo.getChromaSubsampling()) && !new JPEGSubsamplingNotation(4, 2, 0).equals(jpegInfo.getChromaSubsampling())) {
            complianceResult.formatCorrect = false;
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("JPEG DLNA compliance failed with illegal chroma subsampling \"%s\"", jpegInfo.getChromaSubsampling()));
            } else {
                complianceResult.failures.add("chroma subsampling");
            }
        }
    }

    protected static void checkPNG(ImageInfo imageInfo, InternalComplianceResult complianceResult) {
        if (imageInfo == null || imageInfo.getFormat() != ImageFormat.PNG || !(imageInfo instanceof PNGInfo)) {
            return;
        }
        PNGInfo pngInfo = (PNGInfo)imageInfo;
        if (pngInfo.getColorType() != null) {
            switch (pngInfo.getColorType().getNumericValue()) {
                case 0: 
                case 4: {
                    if (pngInfo.getBitDepth() == 8 || pngInfo.getBitDepth() == 16) {
                        complianceResult.colorsCorrect = true;
                        break;
                    }
                    if (LOGGER.isTraceEnabled()) {
                        complianceResult.failures.add(String.format("PNG DLNA compliance failed with illegal bit depth \"%d\"", pngInfo.getBitDepth()));
                        break;
                    }
                    complianceResult.failures.add("bit depth");
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    if (pngInfo.getBitDepth() == 8) {
                        complianceResult.colorsCorrect = true;
                        break;
                    }
                    if (LOGGER.isTraceEnabled()) {
                        complianceResult.failures.add(String.format("PNG DLNA compliance failed with illegal bit depth \"%d\"", pngInfo.getBitDepth()));
                        break;
                    }
                    complianceResult.failures.add("bit depth");
                    break;
                }
                default: {
                    if (LOGGER.isTraceEnabled()) {
                        complianceResult.failures.add(String.format("PNG DLNA compliance failed with illegal color type \"%s\"", pngInfo.getColorType()));
                        break;
                    }
                    complianceResult.failures.add("color type");
                    break;
                }
            }
        } else if (LOGGER.isTraceEnabled()) {
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add("PNG DLNA compliance failed with missing color type information");
            } else {
                complianceResult.failures.add("missing color type");
            }
        }
        if (pngInfo.isModifiedBitDepth()) {
            complianceResult.colorsCorrect = false;
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add("PNG DLNA compliance failed with non-standard bit depth");
            } else {
                complianceResult.failures.add("non-standard bit depth");
            }
        }
        boolean bl = complianceResult.formatCorrect = pngInfo.getInterlaceMethod() == PNGInfo.InterlaceMethod.NONE;
        if (!complianceResult.formatCorrect && LOGGER.isTraceEnabled()) {
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("PNG DLNA compliance failed with illegal interlace method \"%s\"", new Object[]{pngInfo.getInterlaceMethod()}));
            } else {
                complianceResult.failures.add("interlace method");
            }
        }
    }

    public static DLNAImageProfile getClosestDLNAProfile(Dimension resolution, ImageFormat format, boolean allowJPEG_RES_H_V) {
        return DLNAImageProfile.getClosestDLNAProfile(resolution.width, resolution.height, format, allowJPEG_RES_H_V);
    }

    public static DLNAImageProfile getClosestDLNAProfile(int width, int height, ImageFormat format, boolean allowJPEG_RES_H_V) {
        if (format == null) {
            throw new NullPointerException("format cannot be null");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException(String.format("Cannot find DLNA media format profile for %d x %d", width, height));
        }
        switch (format) {
            case GIF: {
                return GIF_LRG;
            }
            case JPEG: {
                if (allowJPEG_RES_H_V) {
                    return DLNAImageProfile.createJPEG_RES_H_V(width, height);
                }
                if (JPEG_TN.isResolutionCorrect(width, height)) {
                    return JPEG_TN;
                }
                if (JPEG_SM.isResolutionCorrect(width, height)) {
                    return JPEG_SM;
                }
                if (JPEG_MED.isResolutionCorrect(width, height)) {
                    return JPEG_MED;
                }
                return JPEG_LRG;
            }
            case PNG: {
                if (PNG_TN.isResolutionCorrect(width, height)) {
                    return PNG_TN;
                }
                return PNG_LRG;
            }
        }
        throw new IllegalArgumentException("Invalid format " + String.valueOf((Object)format) + " for which to find a DLNA media format profile");
    }

    public static DLNAComplianceResult checkCompliance(ImageInfo imageInfo, ImageFormat format) {
        if (imageInfo == null) {
            throw new NullPointerException("imageInfo cannot be null");
        }
        if (format == null) {
            throw new NullPointerException("format cannot be null");
        }
        InternalComplianceResult complianceResult = new InternalComplianceResult();
        switch (format) {
            case JPEG: {
                complianceResult.maxWidth = Integer.MAX_VALUE;
                complianceResult.maxHeight = Integer.MAX_VALUE;
                complianceResult.resolutionCorrect = true;
                DLNAImageProfile.checkJPEG(imageInfo, complianceResult);
                break;
            }
            case GIF: {
                DLNAImageProfile largestProfile = GIF_LRG;
                complianceResult.maxWidth = largestProfile.getMaxWidth();
                complianceResult.maxHeight = largestProfile.getMaxHeight();
                complianceResult.resolutionCorrect = largestProfile.isResolutionCorrect(imageInfo);
                if (!complianceResult.resolutionCorrect) {
                    if (LOGGER.isTraceEnabled()) {
                        complianceResult.failures.add(String.format("GIF DLNA compliance failed with wrong resolution %d x %d (limits are %d x %d)", imageInfo.getWidth(), imageInfo.getHeight(), largestProfile.getMaxWidth(), largestProfile.getMaxHeight()));
                    } else {
                        complianceResult.failures.add("resolution");
                    }
                }
                DLNAImageProfile.checkGIF(imageInfo, complianceResult);
                break;
            }
            case PNG: {
                DLNAImageProfile largestProfile = PNG_LRG;
                complianceResult.maxWidth = largestProfile.getMaxWidth();
                complianceResult.maxHeight = largestProfile.getMaxHeight();
                complianceResult.resolutionCorrect = largestProfile.isResolutionCorrect(imageInfo);
                if (!complianceResult.resolutionCorrect) {
                    if (LOGGER.isTraceEnabled()) {
                        complianceResult.failures.add(String.format("PNG DLNA compliance failed with wrong resolution %d x %d (limits are %d x %d)", imageInfo.getWidth(), imageInfo.getHeight(), largestProfile.getMaxWidth(), largestProfile.getMaxHeight()));
                    } else {
                        complianceResult.failures.add("resolution");
                    }
                }
                DLNAImageProfile.checkPNG(imageInfo, complianceResult);
                break;
            }
            default: {
                if (LOGGER.isTraceEnabled()) {
                    complianceResult.failures.add(String.format("DLNA compliance failed with illegal image format \"%s\"", new Object[]{format}));
                    break;
                }
                complianceResult.failures.add("illegal format");
            }
        }
        return DLNAComplianceResult.toDLNAComplianceResult(complianceResult);
    }

    public static DLNAComplianceResult checkCompliance(ImageInfo imageInfo, DLNAImageProfile profile) {
        if (imageInfo == null || profile == null) {
            return DLNAComplianceResult.toDLNAComplianceResult(new InternalComplianceResult());
        }
        return profile.checkCompliance(imageInfo);
    }

    public boolean isResolutionCorrect(ImageInfo imageInfo) {
        if (imageInfo == null) {
            return false;
        }
        return this.isResolutionCorrect(imageInfo.getWidth(), imageInfo.getHeight());
    }

    private boolean isResolutionCorrect(int width, int height) {
        if (width < 1 || height < 1) {
            return false;
        }
        if (this.equals(JPEG_RES_H_V)) {
            return width == this.horizontal && height == this.vertical;
        }
        return width <= this.horizontal && height <= this.vertical;
    }

    public DLNAComplianceResult checkCompliance(ImageInfo imageInfo) {
        InternalComplianceResult complianceResult = new InternalComplianceResult();
        complianceResult.maxWidth = this.horizontal;
        complianceResult.maxHeight = this.vertical;
        if (imageInfo == null) {
            return DLNAComplianceResult.toDLNAComplianceResult(complianceResult);
        }
        complianceResult.resolutionCorrect = this.isResolutionCorrect(imageInfo);
        if (!complianceResult.resolutionCorrect) {
            if (LOGGER.isTraceEnabled()) {
                complianceResult.failures.add(String.format("%s DLNA compliance failed with wrong resolution %d x %d (limits are %d x %d)", this.toString(), imageInfo.getWidth(), imageInfo.getHeight(), this.horizontal, this.vertical));
            } else {
                complianceResult.failures.add("resolution");
            }
        }
        switch (this.toInt()) {
            case 1: {
                DLNAImageProfile.checkGIF(imageInfo, complianceResult);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                DLNAImageProfile.checkJPEG(imageInfo, complianceResult);
                break;
            }
            case 7: 
            case 8: {
                DLNAImageProfile.checkPNG(imageInfo, complianceResult);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal DLNA media profile");
            }
        }
        return DLNAComplianceResult.toDLNAComplianceResult(complianceResult);
    }

    public HypotheticalResult calculateHypotheticalProperties(ImageInfo imageInfo) {
        if (imageInfo == null) {
            throw new IllegalArgumentException("calculateHypotheticalProperties: imageInfo cannot be null");
        }
        if (imageInfo.getWidth() < 1 || imageInfo.getHeight() < 1) {
            return new HypotheticalResult(Integer.MIN_VALUE, Integer.MIN_VALUE, null, true);
        }
        DLNAComplianceResult complianceResult = this.checkCompliance(imageInfo);
        if (complianceResult.isAllCorrect()) {
            return new HypotheticalResult(imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getSize(), false);
        }
        if (complianceResult.resolutionCorrect) {
            return new HypotheticalResult(imageInfo.getWidth(), imageInfo.getHeight(), null, true);
        }
        Dimension scaledResolution = ImagesUtil.calculateScaledResolution(imageInfo, this.equals(JPEG_RES_H_V) ? ImagesUtil.ScaleType.EXACT : ImagesUtil.ScaleType.MAX, this.horizontal, this.vertical);
        return new HypotheticalResult(scaledResolution.width, scaledResolution.height, null, true);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.imageProfileInt;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DLNAImageProfile)) {
            return false;
        }
        DLNAImageProfile other = (DLNAImageProfile)obj;
        return this.imageProfileInt == other.imageProfileInt;
    }

    @Override
    public int compareTo(DLNAImageProfile o) {
        if (o == null) {
            return -1;
        }
        int result = Integer.compare(this.imageProfileInt, o.imageProfileInt);
        if (result != 0) {
            return result;
        }
        if (this.imageProfileStr == null && o.imageProfileStr == null) {
            return 0;
        }
        if (this.imageProfileStr == null) {
            return 1;
        }
        if (o.imageProfileStr == null) {
            return -1;
        }
        return this.imageProfileStr.compareTo(o.imageProfileStr);
    }

    protected static class InternalComplianceResult {
        private boolean resolutionCorrect = false;
        private boolean formatCorrect = false;
        private boolean colorsCorrect = false;
        private int maxWidth;
        private int maxHeight;
        private List<String> failures = new ArrayList<String>();

        protected InternalComplianceResult() {
        }
    }

    public static class DLNAComplianceResult {
        private final boolean resolutionCorrect;
        private final boolean formatCorrect;
        private final boolean colorsCorrect;
        private final boolean allCorrect;
        private final int maxWidth;
        private final int maxHeight;
        private final List<String> failures;

        public DLNAComplianceResult(boolean resolutionCorrect, boolean formatCorrect, boolean colorsCorrect, int maxWidth, int maxHeight, List<String> failures) {
            this.resolutionCorrect = resolutionCorrect;
            this.formatCorrect = formatCorrect;
            this.colorsCorrect = colorsCorrect;
            this.allCorrect = resolutionCorrect && formatCorrect && colorsCorrect;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.failures = failures;
        }

        protected static DLNAComplianceResult toDLNAComplianceResult(InternalComplianceResult result) {
            return new DLNAComplianceResult(result.resolutionCorrect, result.formatCorrect, result.colorsCorrect, result.maxWidth, result.maxHeight, result.failures);
        }

        public boolean isResolutionCorrect() {
            return this.resolutionCorrect;
        }

        public boolean isFormatCorrect() {
            return this.formatCorrect;
        }

        public boolean isColorsCorrect() {
            return this.colorsCorrect;
        }

        public boolean isAllCorrect() {
            return this.allCorrect;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public List<String> getFailures() {
            return Collections.unmodifiableList(this.failures);
        }
    }

    public static class HypotheticalResult {
        public final int width;
        public final int height;
        public final Long size;
        public final boolean conversionNeeded;

        public HypotheticalResult(int width, int height, Long size, boolean conversionNeeded) {
            if (width < 1 || height < 1) {
                this.width = Integer.MIN_VALUE;
                this.height = Integer.MIN_VALUE;
            } else {
                this.width = width;
                this.height = height;
            }
            this.size = size;
            this.conversionNeeded = conversionNeeded;
        }

        public String toString() {
            return "HypotheticalResult [width=" + this.width + ", height=" + this.height + ", size=" + this.size + ", conversionNeeded=" + this.conversionNeeded + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conversionNeeded ? 1231 : 1237);
            result = 31 * result + this.height;
            result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
            result = 31 * result + this.width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HypotheticalResult)) {
                return false;
            }
            HypotheticalResult other = (HypotheticalResult)obj;
            if (this.conversionNeeded != other.conversionNeeded) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
                return false;
            }
            return this.width == other.width;
        }
    }
}

