/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.external.tmdb.TMDB;
import net.pms.media.video.metadata.ApiSeason;
import net.pms.media.video.metadata.TvSeasonMetadataLocalized;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableTvSeasonMetadataLocalized
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableTvSeasonMetadataLocalized.class);
    public static final String TABLE_NAME = "TV_SEASON_METADATA_LOCALIZED";
    private static final int TABLE_VERSION = 1;
    private static final String COL_LANGUAGE = "LANGUAGE";
    private static final String COL_ID = "ID";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_TVSEASON = "TVSEASON";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_OVERVIEW = "OVERVIEW";
    private static final String COL_POSTER = "POSTER";
    private static final String COL_TITLE = "TITLE";
    private static final String TABLE_COL_LANGUAGE = "TV_SEASON_METADATA_LOCALIZED.LANGUAGE";
    private static final String TABLE_COL_TVSERIESID = "TV_SEASON_METADATA_LOCALIZED.TVSERIESID";
    private static final String TABLE_COL_TVSEASON = "TV_SEASON_METADATA_LOCALIZED.TVSEASON";
    private static final String SQL_GET_ALL_TVSERIESID = "SELECT * FROM TV_SEASON_METADATA_LOCALIZED WHERE TV_SEASON_METADATA_LOCALIZED.TVSERIESID = ? AND TV_SEASON_METADATA_LOCALIZED.TVSEASON = ?";
    private static final String SQL_GET_ALL_LANGUAGE_TVSERIESID = "SELECT * FROM TV_SEASON_METADATA_LOCALIZED WHERE TV_SEASON_METADATA_LOCALIZED.LANGUAGE = ? AND TV_SEASON_METADATA_LOCALIZED.TVSERIESID = ? AND TV_SEASON_METADATA_LOCALIZED.TVSEASON = ?";
    private static final String SQL_DELETE_TVSERIESID = "DELETE FROM TV_SEASON_METADATA_LOCALIZED WHERE TV_SEASON_METADATA_LOCALIZED.TVSERIESID = ?";
    private static final int SIZE_LANGUAGE = 5;

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableTvSeasonMetadataLocalized.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 1) {
                    MediaTableTvSeasonMetadataLocalized.upgradeTable(connection, version);
                } else if (version > 1) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableTvSeasonMetadataLocalized.dropTable(connection, TABLE_NAME);
                MediaTableTvSeasonMetadataLocalized.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
            }
        } else {
            MediaTableTvSeasonMetadataLocalized.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 1);
        int version = currentVersion;
        if (version < 1) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                default: 
            }
            throw new IllegalStateException(MediaTableTvSeasonMetadataLocalized.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 1));
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableTvSeasonMetadataLocalized.execute(connection, "CREATE TABLE TV_SEASON_METADATA_LOCALIZED(ID IDENTITY PRIMARY KEY, LANGUAGE VARCHAR(5) NOT NULL, TVSERIESID BIGINT NOT NULL, TVSEASON INTEGER NOT NULL, MODIFIED BIGINT, OVERVIEW CLOB, POSTER VARCHAR, TITLE VARCHAR, CONSTRAINT TV_SEASON_METADATA_LOCALIZED_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE)", "CREATE INDEX IF NOT EXISTS TV_SEASON_METADATA_LOCALIZED_LANGUAGE_TVSERIESID_TVSEASON_IDX ON TV_SEASON_METADATA_LOCALIZED(LANGUAGE, TVSERIESID, TVSEASON)");
    }

    private static void set(Connection connection, Long tvSeriesId, Integer seasonNumber, TvSeasonMetadataLocalized metadata, String language) {
        if (tvSeriesId == null || tvSeriesId < 0L || seasonNumber == null || StringUtils.isBlank(language)) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ALL_LANGUAGE_TVSERIESID, 1003, 1008);){
            ps.setString(1, language);
            ps.setLong(2, tvSeriesId);
            ps.setInt(3, seasonNumber);
            try (ResultSet rs = ps.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !rs.next();
                if (isCreatingNewRecord) {
                    rs.moveToInsertRow();
                    rs.updateString(COL_LANGUAGE, StringUtils.left(language, 5));
                    rs.updateLong(COL_TVSERIESID, (long)tvSeriesId);
                    rs.updateInt(COL_TVSEASON, (int)seasonNumber);
                }
                rs.updateLong(COL_MODIFIED, System.currentTimeMillis());
                rs.updateString(COL_OVERVIEW, metadata == null ? null : metadata.getOverview());
                rs.updateString(COL_POSTER, metadata == null ? null : metadata.getPoster());
                rs.updateString(COL_TITLE, metadata == null ? null : metadata.getName());
                if (isCreatingNewRecord) {
                    rs.insertRow();
                } else {
                    rs.updateRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, tvSeriesId, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static Map<String, TvSeasonMetadataLocalized> getAllTvSeasonMetadataLocalized(Connection connection, Long tvSeriesId, Integer seasonNumber) {
        HashMap<String, TvSeasonMetadataLocalized> result = new HashMap<String, TvSeasonMetadataLocalized>();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ALL_TVSERIESID);){
            ps.setLong(1, tvSeriesId);
            ps.setInt(2, seasonNumber);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    TvSeasonMetadataLocalized metadata = new TvSeasonMetadataLocalized();
                    metadata.setOverview(rs.getString(COL_OVERVIEW));
                    metadata.setPoster(rs.getString(COL_POSTER));
                    metadata.setName(rs.getString(COL_TITLE));
                    result.put(rs.getString(COL_LANGUAGE), metadata);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in TV_SEASON_METADATA_LOCALIZED for \"{}\": {}", (Object)tvSeriesId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TvSeasonMetadataLocalized getTvSeasonMetadataLocalized(Long tvSeriesId, String language, Long tmdbId, ApiSeason apiSeason) {
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            if (connection == null) return null;
            TvSeasonMetadataLocalized tvSeasonMetadataLocalized = MediaTableTvSeasonMetadataLocalized.getTvSeasonMetadataLocalized(connection, tvSeriesId, language, tmdbId, apiSeason);
            return tvSeasonMetadataLocalized;
        }
        catch (Exception e) {
            LOGGER.error("Error while getting metadata for web interface");
            LOGGER.debug("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TvSeasonMetadataLocalized getTvSeasonMetadataLocalized(Connection connection, Long tvSeriesId, String language, Long tmdbId, ApiSeason apiSeason) {
        if (connection == null) return null;
        if (tvSeriesId == null) return null;
        if (tvSeriesId < 0L) return null;
        if (apiSeason == null) return null;
        if (StringUtils.isBlank(language)) {
            return null;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ALL_LANGUAGE_TVSERIESID);){
            ps.setString(1, language);
            ps.setLong(2, tvSeriesId);
            ps.setInt(3, apiSeason.getSeasonNumber());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.first()) {
                    TvSeasonMetadataLocalized result = new TvSeasonMetadataLocalized();
                    result.setOverview(rs.getString(COL_OVERVIEW));
                    result.setPoster(rs.getString(COL_POSTER));
                    result.setName(rs.getString(COL_TITLE));
                    TvSeasonMetadataLocalized tvSeasonMetadataLocalized = result;
                    return tvSeasonMetadataLocalized;
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in TV_SEASON_METADATA_LOCALIZED for \"{}\": {}", (Object)tvSeriesId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        LOGGER.trace("Looking for localized metadata for TVSeries \"{}\": saison {}", (Object)tvSeriesId, (Object)apiSeason.getSeasonNumber());
        TvSeasonMetadataLocalized result = new TvSeasonMetadataLocalized();
        VideoMetadataLocalized loc = TMDB.getVideoMetadataLocalized(language, "tv_season", null, tmdbId, apiSeason.getSeasonNumber(), null);
        if (loc != null) {
            if (loc.getOverview() != null && !loc.getOverview().equals(apiSeason.getOverview())) {
                result.setOverview(loc.getOverview());
            }
            if (loc.getTitle() != null && !loc.getTitle().equals(apiSeason.getName())) {
                result.setName(loc.getTitle());
            }
            result.setPoster(loc.getPoster());
        }
        MediaTableTvSeasonMetadataLocalized.set(connection, tvSeriesId, apiSeason.getSeasonNumber(), result, language);
        return result;
    }

    public static void clearTvSeasonMetadataLocalized(Connection connection, Long tvSeriesId) {
        if (connection == null || tvSeriesId == null || tvSeriesId < 0L) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_DELETE_TVSERIESID);){
            ps.setLong(1, tvSeriesId);
            ps.execute();
        }
        catch (SQLException e) {
            LOGGER.error("Database error in TV_SEASON_METADATA_LOCALIZED for deleting \"{}\": {}", (Object)tvSeriesId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

