/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.dlna.DLNAThumbnail;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableThumbnails
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableThumbnails.class);
    public static final String TABLE_NAME = "THUMBNAILS";
    private static final int TABLE_VERSION = 1;
    protected static final String COL_THUMBNAIL = "THUMBNAIL";
    private static final String COL_ID = "ID";
    private static final String COL_MD5 = "MD5";
    private static final String COL_MODIFIED = "MODIFIED";
    public static final String TABLE_COL_ID = "THUMBNAILS.ID";
    private static final String TABLE_COL_MD5 = "THUMBNAILS.MD5";
    private static final String SQL_GET_ID = "SELECT * FROM THUMBNAILS WHERE THUMBNAILS.ID = ? LIMIT 1";
    private static final String SQL_GET_ID_MD5 = "SELECT THUMBNAILS.ID FROM THUMBNAILS WHERE THUMBNAILS.MD5 = ? LIMIT 1";
    private static final String SQL_INSERT_ID_MD5 = "INSERT INTO THUMBNAILS (THUMBNAIL, MODIFIED, MD5) VALUES (?, ?, ?)";
    private static final String SQL_DELETE_ID = "DELETE FROM THUMBNAILS WHERE THUMBNAILS.ID = ?";
    private static final String SQL_CLEANUP = "DELETE FROM THUMBNAILS WHERE NOT EXISTS (SELECT TV_SERIES.THUMBID FROM TV_SERIES WHERE TV_SERIES.THUMBID = THUMBNAILS.ID) AND NOT EXISTS (SELECT FILES.THUMBID FROM FILES WHERE FILES.THUMBID = THUMBNAILS.ID)";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableThumbnails.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 1) {
                    MediaTableThumbnails.upgradeTable(connection, version);
                } else if (version > 1) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableThumbnails.dropTable(connection, TABLE_NAME);
                MediaTableThumbnails.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
            }
        } else {
            MediaTableThumbnails.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 1);
        int version = currentVersion;
        if (version < 1) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                default: 
            }
            throw new IllegalStateException(MediaTableThumbnails.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 1));
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableThumbnails.execute(connection, "CREATE TABLE THUMBNAILS(ID IDENTITY, THUMBNAIL OTHER NOT NULL, MODIFIED TIMESTAMP, MD5 VARCHAR UNIQUE NOT NULL)");
    }

    public static synchronized Long setThumbnail(Connection connection, DLNAThumbnail thumbnail) {
        Long l;
        block9: {
            String md5Hash = DigestUtils.md5Hex(thumbnail.getBytes(false));
            Long existingId = MediaTableThumbnails.getThumbnailId(connection, md5Hash);
            if (existingId != null) {
                return existingId;
            }
            PreparedStatement insertStatement = connection.prepareStatement(SQL_INSERT_ID_MD5, 1);
            try {
                insertStatement.setObject(1, thumbnail);
                insertStatement.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                insertStatement.setString(3, md5Hash);
                insertStatement.executeUpdate();
                l = MediaTableThumbnails.getThumbnailId(connection, md5Hash);
                if (insertStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (insertStatement != null) {
                        try {
                            insertStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "writing md5", md5Hash, TABLE_NAME, e.getMessage());
                    LOGGER.trace("", e);
                    return null;
                }
            }
            insertStatement.close();
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Long getThumbnailId(Connection connection, String md5Hash) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ID_MD5);){
            statement.setString(1, md5Hash);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Long l = resultSet.getLong(COL_ID);
                return l;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "searching md5", md5Hash, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static DLNAThumbnail getThumbnail(Connection connection, Long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void cleanup(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_CLEANUP);){
            int rows = statement.executeUpdate();
            LOGGER.trace("Removed {} entries in \"{}\"", (Object)rows, (Object)TABLE_NAME);
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\": {}", "medias", "removing entries", TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

