/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.formats.v2.SubtitleType;
import net.pms.media.MediaInfo;
import net.pms.media.subtitle.MediaSubtitle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableSubtracks
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableSubtracks.class);
    public static final String TABLE_NAME = "SUBTRACKS";
    private static final int TABLE_VERSION = 5;
    private static final String COL_ID = "ID";
    public static final String COL_FILEID = "FILEID";
    private static final String COL_LANG = "LANG";
    private static final String COL_STREAMID = "STREAMID";
    private static final String COL_DEFAULT_FLAG = "DEFAULT_FLAG";
    private static final String COL_FORCED_FLAG = "FORCED_FLAG";
    private static final String COL_OPTIONALID = "OPTIONALID";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_FORMAT_TYPE = "FORMAT_TYPE";
    private static final String COL_EXTERNALFILE = "EXTERNALFILE";
    private static final String COL_CHARSET = "CHARSET";
    private static final String TABLE_COL_ID = "SUBTRACKS.ID";
    private static final String TABLE_COL_FILEID = "SUBTRACKS.FILEID";
    private static final String TABLE_COL_EXTERNALFILE = "SUBTRACKS.EXTERNALFILE";
    private static final String SQL_GET_ALL_FILEID = "SELECT * FROM SUBTRACKS WHERE SUBTRACKS.FILEID = ?";
    private static final String SQL_GET_ALL_FILEID_ID_EXTERNALFILE = "SELECT * FROM SUBTRACKS WHERE SUBTRACKS.FILEID = ? AND SUBTRACKS.ID = ? AND SUBTRACKS.EXTERNALFILE = ?";
    private static final String SQL_DELETE_EXTERNALFILE = "DELETE FROM SUBTRACKS WHERE SUBTRACKS.EXTERNALFILE = ?";
    private static final String SQL_DELETE_BY_FILEID_ID_GREATER_OR_EQUAL = "DELETE FROM SUBTRACKS WHERE SUBTRACKS.FILEID = ? AND SUBTRACKS.ID >= ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableSubtracks.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 5) {
                MediaTableSubtracks.upgradeTable(connection, version);
            } else if (version > 5) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableSubtracks.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 5);
        }
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 5);
        block10: for (int version = currentVersion.intValue(); version < 5; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    if (!MediaTableSubtracks.isColumnExist(connection, TABLE_NAME, "TYPE")) continue block10;
                    LOGGER.trace("Renaming column name TYPE to FORMAT_TYPE");
                    MediaTableSubtracks.executeUpdate(connection, "ALTER TABLE SUBTRACKS ALTER COLUMN `TYPE` RENAME TO FORMAT_TYPE");
                    continue block10;
                }
                case 2: {
                    try {
                        MediaTableSubtracks.executeUpdate(connection, "ALTER TABLE SUBTRACKS RENAME CONSTRAINT PKSUB TO SUBTRACKS_PK");
                    }
                    catch (SQLException sQLException) {}
                    continue block10;
                }
                case 3: {
                    MediaTableSubtracks.executeUpdate(connection, "ALTER TABLE SUBTRACKS ADD COLUMN IF NOT EXISTS DEFAULT_FLAG BOOLEAN");
                    MediaTableSubtracks.executeUpdate(connection, "ALTER TABLE SUBTRACKS ADD COLUMN IF NOT EXISTS FORCED_FLAG BOOLEAN");
                    continue block10;
                }
                case 4: {
                    MediaTableSubtracks.executeUpdate(connection, "ALTER TABLE SUBTRACKS ADD COLUMN IF NOT EXISTS STREAMID INTEGER");
                    MediaTableSubtracks.executeUpdate(connection, "ALTER TABLE SUBTRACKS ADD COLUMN IF NOT EXISTS OPTIONALID BIGINT");
                    continue block10;
                }
                default: {
                    throw new IllegalStateException(MediaTableSubtracks.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 5));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 5);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableSubtracks.execute(connection, "CREATE TABLE SUBTRACKS (ID INTEGER NOT NULL, FILEID BIGINT NOT NULL, LANG VARCHAR(3), STREAMID INTEGER, OPTIONALID BIGINT, DEFAULT_FLAG BOOLEAN, FORCED_FLAG BOOLEAN, TITLE VARCHAR(255), FORMAT_TYPE INTEGER, EXTERNALFILE VARCHAR(1000) NOT NULL DEFAULT '', CHARSET VARCHAR(255), CONSTRAINT SUBTRACKS_PK PRIMARY KEY(FILEID, ID, EXTERNALFILE), CONSTRAINT SUBTRACKS_FILEID_PK FOREIGN KEY(FILEID) REFERENCES FILES(ID) ON DELETE CASCADE)");
    }

    public static void insertOrUpdateSubtitleTracks(Connection connection, long fileId, MediaInfo media) throws SQLException {
        if (connection == null || fileId < 0L || media == null) {
            return;
        }
        int trackCount = media.getSubtitleTrackCount();
        try (PreparedStatement updateStatment = connection.prepareStatement(SQL_DELETE_BY_FILEID_ID_GREATER_OR_EQUAL);){
            updateStatment.setLong(1, fileId);
            updateStatment.setInt(2, trackCount);
            updateStatment.executeUpdate();
        }
        if (trackCount == 0) {
            return;
        }
        try (PreparedStatement updateStatement = connection.prepareStatement(SQL_GET_ALL_FILEID_ID_EXTERNALFILE, 1003, 1008);){
            for (MediaSubtitle subtitleTrack : media.getSubtitlesTracks()) {
                String externalFile = subtitleTrack.getExternalFile() != null ? subtitleTrack.getExternalFile().getPath() : "";
                updateStatement.setLong(1, fileId);
                updateStatement.setInt(2, subtitleTrack.getId());
                updateStatement.setString(3, externalFile);
                ResultSet rs = updateStatement.executeQuery();
                try {
                    boolean isCreatingNewRecord;
                    boolean bl = isCreatingNewRecord = !rs.next();
                    if (isCreatingNewRecord) {
                        rs.moveToInsertRow();
                        rs.updateLong(COL_FILEID, fileId);
                        rs.updateInt(COL_ID, subtitleTrack.getId());
                        rs.updateString(COL_EXTERNALFILE, externalFile);
                    }
                    rs.updateString(COL_LANG, StringUtils.left(subtitleTrack.getLang(), 3));
                    MediaTableSubtracks.updateInteger(rs, COL_STREAMID, subtitleTrack.getStreamOrder());
                    MediaTableSubtracks.updateLong(rs, COL_OPTIONALID, subtitleTrack.getOptionalId());
                    rs.updateBoolean(COL_DEFAULT_FLAG, subtitleTrack.isDefault());
                    rs.updateBoolean(COL_FORCED_FLAG, subtitleTrack.isForced());
                    rs.updateString(COL_TITLE, StringUtils.left(subtitleTrack.getTitle(), 255));
                    rs.updateInt(COL_FORMAT_TYPE, subtitleTrack.getType().getStableIndex());
                    rs.updateString(COL_CHARSET, StringUtils.left(subtitleTrack.getSubCharacterSet(), 255));
                    if (isCreatingNewRecord) {
                        rs.insertRow();
                        continue;
                    }
                    rs.updateRow();
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<MediaSubtitle> getSubtitleTracks(Connection connection, long fileId) {
        ArrayList<MediaSubtitle> result;
        block41: {
            result = new ArrayList<MediaSubtitle>();
            ArrayList<String> externalFileReferencesToRemove = new ArrayList<String>();
            if (connection == null || fileId < 0L) {
                return result;
            }
            try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_FILEID);){
                stmt.setLong(1, fileId);
                try (ResultSet elements = stmt.executeQuery();){
                    while (elements.next()) {
                        File externalFile;
                        String fileName = elements.getString(COL_EXTERNALFILE);
                        File file = externalFile = StringUtils.isNotBlank(fileName) ? new File(fileName) : null;
                        if (externalFile != null && !externalFile.exists()) {
                            externalFileReferencesToRemove.add(externalFile.getPath());
                            continue;
                        }
                        MediaSubtitle sub = new MediaSubtitle();
                        sub.setId(elements.getInt(COL_ID));
                        sub.setLang(elements.getString(COL_LANG));
                        sub.setStreamOrder(MediaTableSubtracks.toInteger(elements, COL_STREAMID));
                        sub.setOptionalId(MediaTableSubtracks.toLong(elements, COL_OPTIONALID));
                        sub.setDefault(elements.getBoolean(COL_DEFAULT_FLAG));
                        sub.setForced(elements.getBoolean(COL_FORCED_FLAG));
                        sub.setTitle(elements.getString(COL_TITLE));
                        sub.setType(SubtitleType.valueOfStableIndex(elements.getInt(COL_FORMAT_TYPE)));
                        sub.setExternalFileOnly(externalFile);
                        sub.setSubCharacterSet(elements.getString(COL_CHARSET));
                        LOGGER.trace("Adding subtitles from the database: {}", (Object)sub.toString());
                        result.add(sub);
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("Database error in SUBTRACKS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
                LOGGER.trace("", e);
            }
            finally {
                if (externalFileReferencesToRemove.isEmpty()) break block41;
                for (String externalFileReferenceToRemove : externalFileReferencesToRemove) {
                    LOGGER.trace("Deleting cached external subtitles from database because the file \"{}\" doesn't exist", (Object)externalFileReferenceToRemove);
                    try (PreparedStatement ps = connection.prepareStatement(SQL_DELETE_EXTERNALFILE);){
                        ps.setString(1, MediaTableSubtracks.sqlQuote(externalFileReferenceToRemove));
                        ps.executeUpdate();
                    }
                    catch (SQLException se) {
                        LOGGER.error("Error deleting cached external subtitles: {}", (Object)se.getMessage());
                        LOGGER.trace("", se);
                    }
                }
            }
        }
        return result;
    }
}

