/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import org.h2.jdbc.JdbcSQLIntegrityConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableMetadata
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableMetadata.class);
    public static final String TABLE_NAME = "METADATA";
    private static final int TABLE_VERSION = 3;
    private static final String COL_M_KEY = "M_KEY";
    private static final String COL_M_VALUE = "M_VALUE";
    private static final String SQL_GET_ALL = "SELECT * FROM METADATA WHERE M_KEY = ? LIMIT 1";
    private static final String SQL_GET_M_VALUE = "SELECT M_VALUE FROM METADATA WHERE M_KEY = ? LIMIT 1";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableMetadata.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 3) {
                MediaTableMetadata.upgradeTable(connection, version);
            } else if (version > 3) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableMetadata.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        try {
            block8: for (int version = currentVersion.intValue(); version < 3; ++version) {
                LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
                switch (version) {
                    case 1: {
                        MediaTableMetadata.executeUpdate(connection, "DROP INDEX IF EXISTS IDX_KEY");
                        MediaTableMetadata.executeUpdate(connection, "ALTER TABLE METADATA ALTER COLUMN IF EXISTS `KEY` RENAME TO M_KEY");
                        MediaTableMetadata.executeUpdate(connection, "ALTER TABLE METADATA ALTER COLUMN IF EXISTS `VALUE` RENAME TO M_VALUE");
                        MediaTableMetadata.executeUpdate(connection, "CREATE UNIQUE INDEX IF NOT EXISTS METADATA_M_KEY_IDX ON METADATA(M_KEY)");
                        continue block8;
                    }
                    case 2: {
                        MediaTableMetadata.executeUpdate(connection, "ALTER INDEX IF EXISTS IDX_M_KEY RENAME TO METADATA_M_KEY_IDX");
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException(MediaTableMetadata.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                    }
                }
            }
            try {
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
            catch (SQLException e) {
                LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
                throw new SQLException(e);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed upgrading database \"{}\" table {} for {}", "medias", TABLE_NAME, e.getMessage());
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableMetadata.execute(connection, "CREATE TABLE METADATA (M_KEY VARCHAR(255) NOT NULL, M_VALUE VARCHAR(255) NOT NULL)", "CREATE UNIQUE INDEX METADATA_M_KEY_IDX ON METADATA(M_KEY)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMetadataValue(Connection connection, String key) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_M_VALUE);){
            statement.setString(1, key);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString(1);
                return string;
            }
        }
        catch (Exception se) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "reading value", key, TABLE_NAME, se.getMessage());
            LOGGER.error(null, se);
        }
        return null;
    }

    public static void setOrUpdateMetadataValue(Connection connection, String key, String value) {
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ALL, 1005, 1008);){
            statement.setString(1, key);
            if (trace) {
                LOGGER.trace("Searching for value in METADATA with \"{}\" before update", (Object)statement);
            }
            try (ResultSet result = statement.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !result.next();
                if (isCreatingNewRecord) {
                    result.moveToInsertRow();
                }
                result.updateString(COL_M_KEY, key);
                result.updateString(COL_M_VALUE, value);
                if (isCreatingNewRecord) {
                    result.insertRow();
                } else {
                    result.updateRow();
                }
            }
            catch (JdbcSQLIntegrityConstraintViolationException e) {
                LOGGER.debug("Attempting to recover from error: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
                MediaTableMetadata.executeUpdate(connection, "DROP INDEX IF EXISTS IDX_M_KEY");
                String query = "DELETE FROM METADATA WHERE M_KEY = " + MediaTableMetadata.sqlQuote(key);
                try {
                    MediaTableMetadata.execute(connection, query);
                    LOGGER.debug("Recovery seems successful, recreating unique index");
                }
                catch (SQLException se) {
                    LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "deleting value", key, TABLE_NAME, se.getMessage());
                    LOGGER.trace("", se);
                }
                MediaTableMetadata.executeUpdate(connection, "CREATE UNIQUE INDEX METADATA_M_KEY_IDX ON METADATA(M_KEY)");
            }
            catch (Exception e) {
                LOGGER.error("Error while writing metadata: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        catch (Exception e2) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" for \"{}\" in \"{}\": {}", "medias", "writing value", key, value, TABLE_NAME, e2.getMessage());
            LOGGER.trace("", e2);
        }
    }
}

