/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.MediaStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableFilesStatus
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableFilesStatus.class);
    public static final String TABLE_NAME = "FILES_STATUS";
    private static final int TABLE_VERSION = 14;
    private static final String COL_ID = "ID";
    private static final String COL_USERID = "USERID";
    private static final String COL_FILENAME = "FILENAME";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_BOOKMARK = "BOOKMARK";
    private static final String COL_ISFULLYPLAYED = "ISFULLYPLAYED";
    private static final String COL_PLAYCOUNT = "PLAYCOUNT";
    private static final String COL_DATELASTPLAY = "DATELASTPLAY";
    private static final String COL_LASTPLAYBACKPOSITION = "LASTPLAYBACKPOSITION";
    public static final String TABLE_COL_FILENAME = "FILES_STATUS.FILENAME";
    public static final String TABLE_COL_USERID = "FILES_STATUS.USERID";
    public static final String TABLE_COL_ISFULLYPLAYED = "FILES_STATUS.ISFULLYPLAYED";
    public static final String TABLE_COL_PLAYCOUNT = "FILES_STATUS.PLAYCOUNT";
    public static final String TABLE_COL_DATELASTPLAY = "FILES_STATUS.DATELASTPLAY";
    private static final String SQL_GET_ALL = "SELECT * FROM FILES_STATUS WHERE FILES_STATUS.FILENAME = ? AND FILES_STATUS.USERID = ? LIMIT 1";
    private static final String SQL_GET_ISFULLYPLAYED = "SELECT FILES_STATUS.ISFULLYPLAYED FROM FILES_STATUS WHERE FILES_STATUS.FILENAME = ? AND FILES_STATUS.USERID = ? LIMIT 1";
    private static final String SQL_GET_MOVED = "SELECT ?, USERID, BOOKMARK, ISFULLYPLAYED, PLAYCOUNT, DATELASTPLAY FROM FILES_STATUS WHERE FILES_STATUS.FILENAME = ?";
    private static final String SQL_GET_USER = "SELECT FILES_STATUS.FILENAME, ?, BOOKMARK, ISFULLYPLAYED, PLAYCOUNT, DATELASTPLAY FROM FILES_STATUS WHERE FILES_STATUS.USERID = ?";
    private static final String SQL_DELETE = "DELETE FROM FILES_STATUS WHERE FILES_STATUS.FILENAME = ?";
    private static final String SQL_DELETE_LIKE = "DELETE FROM FILES_STATUS WHERE FILES_STATUS.FILENAME LIKE STRINGENCODE(?) || '%'";
    private static final String SQL_DELETE_USER = "DELETE FROM FILES_STATUS WHERE FILES_STATUS.USERID = ?";
    private static final String SQL_INSERT_MOVED = "INSERT INTO FILES_STATUS(FILENAME, USERID, BOOKMARK, ISFULLYPLAYED, PLAYCOUNT, DATELASTPLAY) SELECT ?, USERID, BOOKMARK, ISFULLYPLAYED, PLAYCOUNT, DATELASTPLAY FROM FILES_STATUS WHERE FILES_STATUS.FILENAME = ?";
    private static final String SQL_INSERT_USERCOPY = "INSERT INTO FILES_STATUS(FILENAME, USERID, BOOKMARK, ISFULLYPLAYED, PLAYCOUNT, DATELASTPLAY) SELECT FILES_STATUS.FILENAME, ?, BOOKMARK, ISFULLYPLAYED, PLAYCOUNT, DATELASTPLAY FROM FILES_STATUS WHERE FILES_STATUS.USERID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableFilesStatus.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 14) {
                    MediaTableFilesStatus.upgradeTable(connection, version);
                } else if (version > 14) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableFilesStatus.dropTable(connection, TABLE_NAME);
                MediaTableFilesStatus.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 14);
            }
        } else {
            MediaTableFilesStatus.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 14);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        MediaTableFilesStatus.LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", new Object[]{"medias", "FILES_STATUS", currentVersion, 14});
        block30: for (version = currentVersion; version < 14; ++version) {
            MediaTableFilesStatus.LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", new Object[]{"medias", "FILES_STATUS", version, version + 1});
            switch (version) {
                case 1: {
                    if (!MediaTableFilesStatus.isColumnExist(connection, "FILES_STATUS", "FILEID")) ** GOTO lbl39
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS ADD FILENAME VARCHAR(1024)");
                    fileStatusEntries = new HashSet<String>();
                    stmt = connection.prepareStatement("SELECT FILES.ID AS FILES_ID, FILES_STATUS.FILENAME AS FILES_FILENAME FROM FILES LEFT JOIN FILES_STATUS ON FILES.ID = FILES_STATUS.FILEID");
                    try {
                        rs = stmt.executeQuery();
                        try {
                            while (rs.next()) {
                                filename = rs.getString("FILES_FILENAME");
                                if (fileStatusEntries.contains(filename)) continue;
                                fileStatusEntries.add(filename);
                                query = "UPDATE FILES_STATUS SET FILENAME = " + MediaTableFilesStatus.sqlQuote(filename) + " WHERE FILEID = " + rs.getInt("FILES_ID");
                                statement2 = connection.createStatement();
                                try {
                                    statement2.execute(query);
                                }
                                finally {
                                    if (statement2 != null) {
                                        statement2.close();
                                    }
                                }
                                MediaTableFilesStatus.LOGGER.info("Updating fully played entry for " + filename);
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
lbl39:
                    // 2 sources

                    MediaTableFilesStatus.executeUpdate(connection, "DELETE FROM FILES_STATUS WHERE FILENAME IS NULL");
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS ALTER COLUMN IF EXISTS FILENAME SET  NOT NULL");
                    MediaTableFilesStatus.executeUpdate(connection, "DROP INDEX IF EXISTS FILEID_IDX");
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS DROP COLUMN IF EXISTS FILEID");
                    MediaTableFilesStatus.executeUpdate(connection, "CREATE UNIQUE INDEX IF NOT EXISTS FILES_STATUS_FILENAME_IDX ON FILES_STATUS(FILENAME)");
                    continue block30;
                }
                case 2: {
                    continue block30;
                }
                case 3: {
                    MediaTableFilesStatus.executeUpdate(connection, "DROP INDEX IF EXISTS ISFULLYPLAYED_IDX");
                    MediaTableFilesStatus.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS FILES_STATUS_ISFULLYPLAYED_IDX ON FILES_STATUS(ISFULLYPLAYED)");
                    continue block30;
                }
                case 4: 
                case 5: 
                case 6: {
                    continue block30;
                }
                case 7: {
                    MediaTableFilesStatus.dropReferentialsConstraint(connection, "FILES_STATUS");
                    if (!MediaTableFilesStatus.dropReferentialsConstraint(connection, "FILES_STATUS")) continue block30;
                    throw new SQLException("The upgrade from v7 to v8 failed to remove the old constraints");
                }
                case 8: {
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS ADD COLUMN IF NOT EXISTS BOOKMARK INTEGER DEFAULT 0");
                    continue block30;
                }
                case 9: {
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS ADD COLUMN IF NOT EXISTS DATELASTPLAY TIMESTAMP");
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS ADD COLUMN IF NOT EXISTS PLAYCOUNT INTEGER DEFAULT 0");
                    continue block30;
                }
                case 10: {
                    continue block30;
                }
                case 11: {
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS ADD COLUMN IF NOT EXISTS LASTPLAYBACKPOSITION DOUBLE PRECISION DEFAULT 0.0");
                    continue block30;
                }
                case 12: {
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER INDEX IF EXISTS FILENAME_IDX RENAME TO FILES_STATUS_FILENAME_IDX");
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER INDEX IF EXISTS ISFULLYPLAYED_IDX RENAME TO FILES_STATUS_ISFULLYPLAYED_IDX");
                    continue block30;
                }
                case 13: {
                    MediaTableFilesStatus.dropUniqueConstraint(connection, "FILES_STATUS", "FILENAME");
                    MediaTableFilesStatus.executeUpdate(connection, "ALTER TABLE FILES_STATUS ADD COLUMN IF NOT EXISTS USERID INTEGER DEFAULT 0");
                    MediaTableFilesStatus.executeUpdate(connection, "CREATE UNIQUE INDEX IF NOT EXISTS FILES_STATUS_FILENAME_USERID_IDX ON FILES_STATUS(FILENAME, USERID)");
                    continue block30;
                }
                default: {
                    throw new IllegalStateException(MediaTableFilesStatus.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", new Object[]{"medias", "FILES_STATUS", version, 14}));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, "FILES_STATUS", 14);
        }
        catch (SQLException e) {
            MediaTableFilesStatus.LOGGER.error("Failed setting the table version of the {} for {}", (Object)"FILES_STATUS", (Object)e.getMessage());
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableFilesStatus.execute(connection, "CREATE TABLE FILES_STATUS(ID IDENTITY PRIMARY KEY, FILENAME VARCHAR(1024) NOT NULL, USERID INTEGER DEFAULT 0, MODIFIED TIMESTAMP, ISFULLYPLAYED BOOLEAN DEFAULT FALSE, BOOKMARK INTEGER DEFAULT 0, DATELASTPLAY TIMESTAMP, PLAYCOUNT INTEGER DEFAULT 0, LASTPLAYBACKPOSITION DOUBLE PRECISION DEFAULT 0.0)", "CREATE UNIQUE INDEX FILES_STATUS_FILENAME_USERID_IDX ON FILES_STATUS(FILENAME, USERID)", "CREATE INDEX IF NOT EXISTS FILES_STATUS_ISFULLYPLAYED_IDX ON FILES_STATUS(ISFULLYPLAYED)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaStatus getMediaStatus(Connection connection, String fullPathToFile, int userId) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ALL);){
            statement.setString(1, fullPathToFile);
            statement.setInt(2, userId);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return null;
                MediaStatus media = new MediaStatus();
                media.setFullyPlayed(rs.getBoolean(COL_ISFULLYPLAYED));
                media.setPlaybackCount(rs.getInt(COL_PLAYCOUNT));
                media.setLastPlaybackTime(rs.getString(COL_DATELASTPLAY));
                media.setLastPlaybackPosition(rs.getDouble(COL_LASTPLAYBACKPOSITION));
                media.setBookmark(rs.getInt(COL_BOOKMARK));
                MediaStatus mediaStatus = media;
                return mediaStatus;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "getting data", TABLE_NAME, fullPathToFile, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static void setFullyPlayed(Connection connection, String fullPathToFile, int userId, boolean isFullyPlayed) {
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ALL, 1005, 1008);){
            statement.setString(1, fullPathToFile);
            statement.setInt(2, userId);
            if (trace) {
                LOGGER.trace("Searching for file in FILES_STATUS with \"{}\" before setFullyPlayed", (Object)statement);
            }
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    if (result.getBoolean(COL_ISFULLYPLAYED) == isFullyPlayed) {
                        if (trace) {
                            LOGGER.trace("Found file entry in FILES_STATUS and it already has ISFULLYPLAYED set to {}", (Object)result.getBoolean(COL_ISFULLYPLAYED));
                        }
                    } else {
                        if (trace) {
                            LOGGER.trace("Found file entry \"{}\" in FILES_STATUS; setting ISFULLYPLAYED to {}", (Object)fullPathToFile, (Object)isFullyPlayed);
                        }
                        result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                        result.updateBoolean(COL_ISFULLYPLAYED, isFullyPlayed);
                        result.updateRow();
                    }
                } else {
                    if (trace) {
                        LOGGER.trace("File entry \"{}\" not found in FILES_STATUS, inserting new row with ISFULLYPLAYED set to {}", (Object)fullPathToFile, (Object)isFullyPlayed);
                    }
                    result.moveToInsertRow();
                    result.updateString(COL_FILENAME, fullPathToFile);
                    result.updateInt(COL_USERID, userId);
                    result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                    result.updateBoolean(COL_ISFULLYPLAYED, isFullyPlayed);
                    result.insertRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\" for \"{}\": {}", "medias", "writing status", isFullyPlayed, TABLE_NAME, fullPathToFile, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void setLastPlayed(Connection connection, String fullPathToFile, int userId, Double lastPlaybackPosition) {
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ALL, 1005, 1008);){
            statement.setString(1, fullPathToFile);
            statement.setInt(2, userId);
            if (trace) {
                LOGGER.trace("Searching for file in FILES_STATUS with \"{}\" before setLastPlayed", (Object)statement);
            }
            try (ResultSet result = statement.executeQuery();){
                int playCount;
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !result.next();
                if (isCreatingNewRecord) {
                    playCount = 1;
                    result.moveToInsertRow();
                    result.updateString(COL_FILENAME, fullPathToFile);
                    result.updateInt(COL_USERID, userId);
                } else {
                    playCount = result.getInt(COL_PLAYCOUNT) + 1;
                }
                result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                result.updateTimestamp(COL_DATELASTPLAY, new Timestamp(System.currentTimeMillis()));
                result.updateInt(COL_PLAYCOUNT, playCount);
                if (lastPlaybackPosition != null) {
                    result.updateDouble(COL_LASTPLAYBACKPOSITION, (double)lastPlaybackPosition);
                }
                if (isCreatingNewRecord) {
                    result.insertRow();
                } else {
                    result.updateRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing last played date", TABLE_NAME, fullPathToFile, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void setBookmark(Connection connection, String fullPathToFile, int userId, int bookmark) {
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ALL, 1005, 1008);){
            statement.setString(1, fullPathToFile);
            statement.setInt(2, userId);
            if (trace) {
                LOGGER.trace("Searching for file in {} with \"{}\" before setBookmark", (Object)TABLE_NAME, (Object)statement);
            }
            try (ResultSet result = statement.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !result.next();
                if (isCreatingNewRecord) {
                    result.moveToInsertRow();
                    result.updateString(COL_FILENAME, fullPathToFile);
                    result.updateInt(COL_USERID, userId);
                    result.updateBoolean(COL_ISFULLYPLAYED, false);
                }
                result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                result.updateInt(COL_BOOKMARK, bookmark);
                if (isCreatingNewRecord) {
                    if (trace) {
                        LOGGER.trace("Inserting bookmark in {}: \"{}\" ", (Object)TABLE_NAME, (Object)bookmark);
                    }
                    result.insertRow();
                } else {
                    if (trace) {
                        LOGGER.trace("Updating existing bookmark in {}: \"{}\" ", (Object)TABLE_NAME, (Object)bookmark);
                    }
                    result.updateRow();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\" for \"{}\": {}", "medias", "writing bookmark", bookmark, TABLE_NAME, fullPathToFile, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void remove(Connection connection, String filename, boolean useLike) {
        try {
            String sql = useLike ? SQL_DELETE_LIKE : SQL_DELETE;
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, filename);
                int rows = statement.executeUpdate();
                LOGGER.trace("Removed entries {} in FILES_STATUS for filename \"{}\"", (Object)rows, (Object)filename);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "removing entries", TABLE_NAME, filename, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void createCopyOnFileMoved(Connection connection, String fullPathToFile, String fullPathToNewFile) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_INSERT_MOVED);){
            statement.setString(1, fullPathToNewFile);
            statement.setString(2, fullPathToFile);
            int rows = statement.executeUpdate();
            LOGGER.trace("Copied entries {} in FILES_STATUS for filename \"{}\"", (Object)rows, (Object)fullPathToNewFile);
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "Copying entries", TABLE_NAME, fullPathToNewFile, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Boolean isFullyPlayed(Connection connection, String fullPathToFile, int userId) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ISFULLYPLAYED);){
            statement.setString(1, fullPathToFile);
            statement.setInt(2, userId);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Searching FILES_STATUS with \"{}\"", (Object)statement);
            }
            try (ResultSet result = statement.executeQuery();){
                if (!result.next()) return null;
                Boolean bl = result.getBoolean(COL_ISFULLYPLAYED);
                return bl;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "looking up file status", TABLE_NAME, fullPathToFile, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static void deleteUser(Connection connection, int userId) {
        if (connection == null || userId < 1) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_DELETE_USER);){
            statement.setInt(1, userId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Error deleteUser:{}", (Object)e.getMessage());
        }
    }

    public static void copyUserEntries(Connection connection, int userId, int userIdDest) {
        if (connection == null || userId < 0 || userIdDest < 1) {
            return;
        }
        MediaTableFilesStatus.deleteUser(connection, userIdDest);
        try (PreparedStatement statement = connection.prepareStatement(SQL_INSERT_USERCOPY);){
            statement.setInt(1, userIdDest);
            statement.setInt(2, userId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Error copyUserEntries:{}", (Object)e.getMessage());
        }
    }
}

