/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableTablesVersions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableContainerFiles
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableContainerFiles.class);
    protected static final String TABLE_NAME = "CONTAINER_FILES";
    private static final int TABLE_VERSION = 1;
    private static final String COL_CONTAINER_ID = "ID";
    private static final String COL_FILEID = "FILEID";
    private static final String TABLE_COL_CONTAINER_ID = "CONTAINER_FILES.ID";
    private static final String TABLE_COL_FILEID = "CONTAINER_FILES.FILEID";
    private static final String SQL_DELETE_ID = "DELETE FROM CONTAINER_FILES WHERE CONTAINER_FILES.ID = ?";
    private static final String SQL_DELETE_ID_FILEID = "DELETE FROM CONTAINER_FILES WHERE CONTAINER_FILES.ID = ? AND CONTAINER_FILES.FILEID = ?";
    private static final String SQL_DELETE_FILEID = "DELETE FROM CONTAINER_FILES WHERE CONTAINER_FILES.FILEID = ?";
    private static final String SQL_GET_ALL_BY_ID = "SELECT * FROM CONTAINER_FILES WHERE CONTAINER_FILES.ID = ?";
    private static final String SQL_GET_ALL_BY_FILEID = "SELECT * FROM CONTAINER_FILES WHERE CONTAINER_FILES.FILEID = ?";
    private static final String SQL_GET_ALL_BY_ID_FILEID = "SELECT * FROM CONTAINER_FILES WHERE CONTAINER_FILES.ID = ? AND CONTAINER_FILES.FILEID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableContainerFiles.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 1) {
                MediaTableContainerFiles.upgradeTable(connection, version);
            } else if (version > 1) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableContainerFiles.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableContainerFiles.execute(connection, "CREATE TABLE CONTAINER_FILES (ID BIGINT, FILEID BIGINT)", "CREATE UNIQUE INDEX CONTAINER_FILES_ID_FILEID_IDX ON CONTAINER_FILES(ID, FILEID)");
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 1);
        int version = currentVersion;
        if (version < 1) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                default: 
            }
            throw new IllegalStateException(MediaTableContainerFiles.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 1));
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 1);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    protected static void deleteContainer(Connection connection, long containerId) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement updateStatment = connection.prepareStatement(SQL_DELETE_ID);){
            updateStatment.setLong(1, containerId);
            updateStatment.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete container entries for {} ", (Object)containerId, (Object)e);
        }
    }

    public static void deleteContainerEntry(Long containerId, Long entryId) {
        if (containerId == null || entryId == null) {
            return;
        }
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            MediaTableContainerFiles.deleteContainerEntry(connection, containerId, entryId);
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete container entry {} for {} ", entryId, containerId, e);
        }
    }

    private static void deleteContainerEntry(Connection connection, long containerId, long entryId) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement updateStatment = connection.prepareStatement(SQL_DELETE_ID_FILEID);){
            updateStatment.setLong(1, containerId);
            updateStatment.setLong(2, entryId);
            updateStatment.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete container entry {} for {} ", entryId, containerId, e);
        }
        if (Boolean.FALSE.equals(MediaTableContainerFiles.isInContainer(connection, entryId))) {
            MediaTableFiles.removeEntry(connection, entryId);
        }
    }

    protected static void deleteEntry(Connection connection, long entryId) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement updateStatment = connection.prepareStatement(SQL_DELETE_FILEID);){
            updateStatment.setLong(1, entryId);
            updateStatment.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error("Cannot delete entry {}", (Object)entryId, (Object)e);
        }
    }

    public static void addContainerEntry(Long containerId, Long entryId) {
        if (containerId == null || entryId == null) {
            return;
        }
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            MediaTableContainerFiles.addContainerEntry(connection, containerId, entryId);
        }
        catch (Exception e) {
            LOGGER.error("Cannot add container entry {} for {} ", entryId, containerId, e);
        }
    }

    private static void addContainerEntry(Connection connection, long containerId, long entryId) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ALL_BY_ID_FILEID, 1003, 1008);){
            ps.setLong(1, containerId);
            ps.setLong(2, entryId);
            try (ResultSet result = ps.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !result.next();
                if (isCreatingNewRecord) {
                    LOGGER.debug("Adding container entry {} for {} ", (Object)entryId, (Object)containerId);
                    result.moveToInsertRow();
                    result.updateLong(COL_CONTAINER_ID, containerId);
                    result.updateLong(COL_FILEID, entryId);
                    result.insertRow();
                } else {
                    LOGGER.trace("Container entry {} for {} already exists", (Object)entryId, (Object)containerId);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Cannot add container entry {} for {} ", entryId, containerId, e);
        }
    }

    protected static List<Long> getContainerFileIds(Connection connection, Long containerId) {
        if (connection == null || containerId == null) {
            return List.of();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_BY_ID);){
            stmt.setLong(1, containerId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    result.add(MediaTableContainerFiles.toLong(rs, COL_FILEID));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in CONTAINER_FILES for \"{}\": {}", (Object)containerId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static Boolean isInContainer(Connection connection, Long fileId) {
        if (connection == null || fileId == null) {
            return null;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_BY_FILEID);){
            Boolean bl;
            block15: {
                stmt.setLong(1, fileId);
                ResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("Database error in CONTAINER_FILES for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
            return false;
        }
    }
}

